PRO lanl_geo_eph_commons

COMMON lanl_geo_eph, sat_names, eph_names,  yunits, lanl_geo_eph_control

sat_names = ['1976-059', '1977-007', '1979-053', '1981-025', '1982-019', $
             '1984-037', '1984-129', '1987-097', '1989-046', '1990-095', $
             '1991-080', '1994-084', 'LANL-97A', 'LANL-01A', 'LANL-02A' ]

eph_names = ['Geo Lat', 'Geo Long', 'Radius']
yunits    = ['deg.',    'deg.',     'R!DE!N']

;finally, set up a structure for all the variables needed by the
;lanl geo eph  module to control the behaviour of the module. This
;replaces the old use of "ioptions, options and soptions" tags of the
;plotinfo structure by a user defined structure which contains mre
;descriptive and verbose tags for easier use.

lanl_geo_eph_control = { $
  sc_id:0,      sc_id_info:'Index into sat_names, Geo Satellite ID', $
  product:0,    product_info:'Index into eph_names, choice of original '+$
                             'ephemeris coord', $
  ticks:0,      ticks_info:'Plot Style; 0: line, 1: x-axis ticks', $
  orig:0,       orig_info:'Coord source; 0: original, 1: model'}

;now get the papco_panel tags for the papco_panel_Add_MagMod_Widgets
;tags, add them to lanl_geo_eph_control
lanl_geo_eph_control = CREATE_STRUCT(lanl_geo_eph_control, $
                           papco_panel_Add_MagMod_Widgets(/STRUCT_ONLY))

;finally name the control structure. This is required for load/save operations!
lanl_geo_eph_control = CREATE_STRUCT(name = 'lanl_geo_eph_control_a', $
                       lanl_geo_eph_control)

END
