


PRO a_lanl_geo_eph, T1 = T1, T2 = T2,MJDT = MJDT, SAT_ID = SAT_ID, EXTMOD = EXTMOD, MAG_DYN = MAG_DYN, VERBOSE = VERBOSE
                                ; lanl_geo_eph common blocks 
  COMMON lanl_geo_eph, sat_names, eph_names,  yunits, lanl_geo_eph_control 
  COMMON geo_eph_data, eph_header, eph_data 
  COMMON lanl_geo_eph_tick, time, yray, mag_model, tick_plotinfo 
  COMMON get_error, get_err_no, get_err_msg 
  COMMON mjdt, mjdt_start, mjdt_end
papco, /set_only ;only initializes papco then exists.

IF NOT keyword_set(T1) THEN BEGIN
    message, 'No start time (T1) defined', /cont & return
ENDIF 

IF NOT keyword_set(T2) THEN BEGIN
    message, 'No end time (T2) defined', /cont & return
ENDIF 



IF keyword_set(MJDT) THEN BEGIN 
   mjdt_start = T1
   mjdt_end = T2
ENDIF ELSE BEGIN 
   result = convert_timeToSeconds(T1, /T90, /MJDT)
   IF result.err EQ 0 THEN mjdt_start =result.value ELSE BEGIN
      message, 'Error in start time (T1)', /cont
      print,  result.errtext
      return
   ENDELSE 

   result = convert_timeToSeconds(T2, /T90, /MJDT)
   IF result.err EQ 0 THEN mjdt_end =result.value ELSE BEGIN
      message, 'Error in end time (T2)', /cont
      print,  result.errtext
      return
   ENDELSE 
ENDELSE  

;tai1=utc2tai({mjd:mjdt_start.mjd, time:mjdt_start.t*1000})
;tai2=utc2tai({mjd:mjdt_end.mjd, time:mjdt_end.t*1000})    


  eph_plotinfo = papco_getplotinfostruct()
  eph_control = lanl_geo_eph_control 
;     eph_control.SC_ID = control.SC_ID+8 
  eph_control.ORIG = 1          ;mag model coords 
  eph_control.L_CALC = 0        ; McIlwain 
  IF NOT keyword_set(EXTMOD) THEN EXTMOD = 5
  eph_control.EXTERNAL_MODEL = extmod ;olson pfitzer 72
  eph_control.INTERNAL_MODEL = 0 
  IF keyword_set(MAG_DYN) THEN eph_control.mag_dyn = 1
  eph_control.sc_id = where(strupcase(sat_names) EQ strupcase(sat_id))
  eph_control.mag_proc = 1
  eph_plotinfo.USR_PTR1 = ptr_new(eph_control) 
  eph_control.mag_proc = 2
  panel = [0, 1, 1]
  orbitNo = 0
;plotinfo we set above
  IsRead = 0
  output = 2

  draw_lanl_geo_eph, panel, eph_plotinfo, orbitNo, $
                       get_data_call, slice_type, IsRead, OUTPUT=OUTPUT
;  r_geo_eph, eph_plotinfo, VERBOSE=VERBOSE 
  
  IF get_err_no NE 0 THEN BEGIN  
     print, get_err_msg
  endIF  
  
  

END 


