;******************************************************************************
;* PROCEDURE:     
;*      PRO lanl_gps_set_commons
;* 
;* DESCRIPTION:  
;*      simply sets up a couple of often used arrays in common blocks.
;*
;* INPUTS:       
;*      none
;*                  
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      lanl_gps_panel_event_refresh, /keywords
;******************************************************************************
PRO lanl_gps_commons
  
COMMON lanl_gps, sat_id, energy_names_1, energy_names_2, energy_names_3, $
    energy_names_41, energy_names_54, $
    fit_energy_names_1, fit_energy_names_2, singles_names_1, energy_names, $
    eph_names, style_names, select_names, energy_intcal, gain, energy_ch, $
    flux_cal_names, lanl_gps_control
  
sat_id=['ns08', 'ns10', 'ns18', 'ns24', 'ns28', 'ns33', 'ns39','ns41', 'ns54']
  
singles_names_1=['LES1', 'HES1']; 'LES2', 'HES2']
  
;BDD I, ns08, ns10
energy_names_1= ['E1', 'E2', 'E3', 'E4', 'P1', 'P2', 'P3', 'P4']

;BDD II, ns33, ns24, etc
energy_names_2= ['LE1 0.2-0.4' ,'LE2 0.4-0.8','LE3 0.8-1.6', 'LE4 1.6-3.2' ,$
                 'LE5 > 3.2'   ,'HE1 4.5-5.9','HE2 > 5.9',   'LP1 9.0-15' ,$
                 'LP2 15-25'   , 'LP3 > 25'  ,'HP1 > 50']  
  
energy_names_3= ['LE1 [>0.200]' ,'LE2 [>0.400]', 'LE3 [>0.800]', $
                 'LE4 [>1.600]' ,'LE5 [>3.200]', 'HE1 4.5-5.9', $
                 'HE2 > 5.9'  ,'LP1 9.0-15', 'LP2 15-25'  , $
                 'LP3 > 25'   ,'HP1 > 50']

;BDD I, ns08,10
fit_energy_names_1=['CH1 orig','CH2 orig','CH3 orig', $
                    'CH4 orig','CH5 orig','CH6 orig', $
                    'CH1 fit','CH2 fit','CH3 fit', $
                    'CH4 fit','CH5 fit','CH6 fit', $
                    'FIT Temp','FIT Density ','FIT Quality']
  
;BDD II, ns33, ns24, etc
fit_energy_names_2=['FIT Density','FIT Temp',$
                    'CH1 fit','CH2 fit','CH3 fit','CH4 fit', $
                    'CH5 fit','CH6 fit','CH7 fit','CH8 fit', $
                    'CH9 fit','CH10 fit','Ch11 fit']
  
;bdd IIR instrument
energy_names_41=['E1 [> 0.08]','E2 [> 0.25]','E3 [> 0.48]','E4 [> 0.90]', $
                 'E5 [> 1.64]','E6 [> 2.88]','E7 [> 4.97]','E8 [> 7.57]', $
                 'P1 [> 1.27]','P2 [> 5.32]','P3 [> 9.46]','P4 [> 15.8]', $
                 'P5 [> 24.3]','P6 [> 35.5]','P7 [> 50.4]','P8 [> 54.1]']

;cxd instrument
energy_names_54=['LEP E1 [0.14-0.23]','LEP E2 [0.23-0.41]', $
                 'LEP E3 [0.41-0.77]','LEP E4 [0.77-1.25]', $
                 'LEP E5 [>1.25]', $
                 'HXP1 E6 [1.3-1.7]','HXP1 E7 [1.7-2.2]', $
                 'HXP1 E8 [2.2-3.0]','HXP1 E9 [3.0-4.1]', $
                 'HXP1 E10 [4.1-5.8]','HXP1 E11 [>5.8]', $
                 'LEP P1 [6.0-10]','LEP P2 [10-50]',' HXP1 P3A [16-57]', $
                 'HXP2 P4 [57-75]','HXP2 P5 [>75]']

;--- coherent channel energies (common energies interpolated for all BDD's) ---
coh_ch = '0.280, 0.400, 0.560, 0.800, 1.120, 1.600, 2.240, 3.200'

;--- deafult maxwellian fit energies ------------------------------------------
fit_ch='0.2 0.4 0.8 1.0 2.0 4.0 8.0'

style_names=   ['ch','ch./L (stk)','ch./L (3D)', $
                'psd','psd/L','Rad. Cut.' ]

flux_cal_names=['counts/s', 'int.flux (bowtie)', $
                'diff.flux (bowtie)', 'fit param', $
                'diff.flux (fit)', 'PSD (fit)', $
                'int.flux (coherent)', 'diff.flux (coherent)']
    
energy_names=energy_names_3
  
energy_ch=fltarr(11,2)
energy_ch(*,0)=[0.2,0.4,0.8,1.6,3.2,4.5,5.9, 9.0,15.0,25.0,50.0]
energy_ch(*,1)=[0.4,0.8,1.6,3.2,-1.,5.9,-1.,15.0,25.0,-1.0,-1.0]
  
gain=5
  
; intercallibration matrix for GPS satellites. Take ns24 as reference.  
dummy={intercal,satid:'',ch:fltarr(11)}
energy_intcal=replicate(dummy,7)
energy_intcal(*).satid= ['ns08','ns10','ns18','ns24','ns28','ns33','ns39']
energy_intcal(*).ch(*)=1
  
;set factors for ns33
energy_intcal(5).ch= [0.5,0.5,0.45,0.1,1.0,1.0,1.0,1.0,1.0,1.0,1.0]

;enter variables for filtering the data
select_names = ['L', 'L_STAR', 'MLT', 'MLAT']
select_frmts = ['(f4.1)', '(f4.1)', '(f4.1)', '(f5.1)']
 
;finally, set up a structure for all the variables needed by the
;lanl geo eph  module to control the behaviour of the module. This
;replaces the old use of "ioptions, options and soptions" tags of the
;plotinfo structure by a user defined structure which contains mre
;descriptive and verbose tags for easier use.

lanl_gps_control = { $
  sc_id:0,       sc_id_info:'Index into sat_id, GPS Satellite ID', $
  singles:0,     singles_info:'0: normal channels, 1:singles rate channels', $
  plot_style:0,  plot_style_info:'Index into style_names, style of plot', $
  product:0,     product_info:'Channels to plot, bit toggle', $
  sngl_prod:0,   sngl_prod_info:'Single cannels to plot, bit toggle', $
  orig:0,        orig_info:'original (0) or model (1) filter coords', $
  seg_av:0,      seg_av_info:'0: plot filtered segments, 1: average',  $
  reload:0,      reload_info:'0: reload data, 1: adopt from memory',  $
  spec:0,        spec_info:'0: line plot; 1:spec color plot', $
  cal:0,         cal_info:'Index into flux_cal_names, callibration choice', $
  dead_time:0,   dead_time_info:'dead time correction, 0: on ;1: off', $
  chanlab:0,     chanlab_info:'label channels, 0: on ;1: off', $
  eqcor:0,       eqcor_info:'correct to equator, 0: on ;1: off', $
  diag:0,        diag_info:'diagnostics, 0: on ;1: off', $
  bckg:0,        bckg_info:'subtract background, 0: on ;1: off', $
  pad_n:0.0,     pad_n_info:'Pitch Angle Dist. fit n, sin^n', $
  fit_ch:fit_ch, fit_ch_info:'String of space seperated MeV energies '+ $
                            'to evaluate fit at', $
  coh_ch:coh_ch, coh_ch_info:'String of space seperated MeV energies '+ $
                            'to evaluate coherent energies at', $
  psd_mu:'',     psd_mu_info:'String of comma seperated mu (keV/nT) '+ $
                            'to evaluate psd at', $
  filter:0,     filter_info:'Index into select_names filter variable to use'}

;now get the papco_panel tags for the papco_panel_Add_MagMod_Widgets
;tags, add them to lanl_gps_control
lanl_gps_control = CREATE_STRUCT(lanl_gps_control, $
                       papco_panel_Add_MagMod_Widgets(/STRUCT_ONLY))
  
;now get the papco panel tags for the various select variables.
FOR i = 0, n_elements(select_names)-1 DO $
  lanl_gps_control = CREATE_STRUCT(lanl_gps_control, $
        papco_panel_AddVar_Sel_Widgets(aBase, select_names(i), $
                                       select, st, en, v1, v2, vr, $
                                       select_frmts(i), /STRUCT_ONLY))

;finally name the control structure. This is required for load/save operations!
lanl_gps_control = CREATE_STRUCT(name = 'lanl_gps_controla', lanl_gps_control)


END 
