;******************************************************************************
;* file lanl_gps_slice.pro
;*      USER_LVAL_slice_lanl_gps
;*      vert_slice_lanl_gps
;* end
;******************************************************************************

;******************************************************************************
;* PROCEDURE:     
;*      PRO vert_slice_lanl_gps, panelNr, seconds, yValue
;* 
;* DESCRIPTION:  
;*      Draw a slice for lanl_gps
;*      calling a separate window for the plot.
;*      slice_type in draw_lanl_gps must be set to +2 to enable this feature.
;*
;* INPUTS:       
;*      panelNr     an integer, the number of the panel for which the slice 
;*                  is to be drawn
;*      seconds     time of mouse click, a float
;*      yvalue      y-value of mouse click, a float
;*      
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      called by papco_DrawSLice (in $papco_PATH/papco_cursor.pro)
;*
;* MODIFICATION HISTORY:       
;*      December 1995, written by R.Friedel at Goddard
;******************************************************************************
PRO vert_slice_lanl_gps, panelNr, seconds, yValue, READDATA=READDATA, $
                         NOWIDGET = NOWIDGET, PANEL=PANEL, NUTITLE=NUTITLE

COMMON papco_vert_slice, slice_widget
COMMON plot_composer, widgetdata

; add in here any other common blocks you would need to make your plot data
; available. The common block included here is a dummy for illustration.
; papco uses the the getdatacall you set in papco_add_lanl_gps to read the
; data you need for the slice. As long as you stay in one panel with the 
; mouse, the data is not read again. When you swittch panels, the new data is 
; read. 
COMMON lanl_gps_data, input_header, input_data
COMMON slice_lanl_gps
COMMON lanl_gps
COMMON mjdt, mjdt_start, mjdt_end ;common time limit in mjdt
COMMON papco_color_names
  
cols=[black, red, green]
  
IF keyword_set(NOWIDGET) THEN BEGIN
    slice_widget = {mult:0, oplot:1, nplot:1}
ENDIF ELSE WIDGET_CONTROL,/HOURGLASS

thisPlot=widgetData.plotsDrawn(panelNr)
; use the same typevector, etc as is used in the call to your plot
; routine. thisPlot contains the full papco structure of plot information for
; the panel in which the mouse was clicked in. 
thisPlotdrawn=widgetData.plotsDrawn(panelNr)
thisPlotInfo =widgetData.plotinfos(panelNr)
   
;get control variables for this module
control = *thisplotinfo.USR_PTR1
sat_name = sat_id(control.sc_id)   ;GPS satellite name, string
nodata = -99.0


satid =  control.sc_id
type  =  thisPlotInfo.typeVector
opts  =  thisPlotInfo.options
iopts =  thisplotInfo.ioptions
plot_style = control.plot_style
sat = sat_id(control.sc_id)       ;GPS satellite name, string
ndat = n_elements(time)

time_str=papco_cursor_time(seconds,panelNr)
time_mjdt=papco_cursor_time(seconds,panelNr,/mjdt)

time_str=str_sep(time_str,' ')  

; select the index for the time chosen out of the time array
CASE plot_style OF 
    1: BEGIN                  ;L versus time cut plots
        tt=(time(*,0)+time(*,1))/2.0
        DiffTimes=ABS(tt - seconds)    
        result=MIN(DiffTimes, timeIndex)
        if difftimes(timeindex) gt 5l*60*60 then c=0 else c=1

        ;timeIndex = where( (seconds GT time(*, 0) ) AND $
        ;                   (seconds LE time(*, 1) ), c)
        ;timeIndex = timeIndex(0)

        print,timeIndex
        IF c EQ 0 THEN BEGIN
              message, 'No data for this time', /cont
              return
        ENDIF
    END
    ELSE: BEGIN 
        DiffTimes=ABS(time - seconds)   ; this sets timeIndex to the index with
        result=MIN(DiffTimes, timeIndex)   ; t(index) is closest to 'seconds'
    END
ENDCASE

data_time=mjdt_start 
data_time.mjd=data_time.mjd + fix(seconds / 86400)
data_time.t=time(timeIndex) mod 86600
data_time_str=convert_secondsToTime(data_time,/t90,/mjdt, /country)
data_time_str=str_sep(data_time_str,' ')

doplot=0
  
; set plotPar structure  
plotpar=extra_plotPar  
plotPar.ylog=1 & plotPar.color=1
plotpar.XTICKFORMAT="(f8.2)"
plotpar=create_struct(plotpar,{ytickformat:''})
plotpar=create_struct(plotpar,{ytitle:''})
plotpar=create_struct(plotpar,{YTICKS:0})
plotpar=create_struct(plotpar,{XLOG:1})
plotpar=create_struct(plotpar,{XTICKS:0})
plotpar=create_struct(plotpar,{XMINOR:0})
plotpar=create_struct(plotpar,{XTITLE:'Energy [MeV]'})  

IF slice_widget.mult THEN nplot = slice_widget.nplot >  1 ELSE nplot = 1

IF NOT slice_widget.oplot THEN BEGIN ;set up multi plot
    IF nplot GT 1 THEN BEGIN
        !P.POSITION = 0
        !P.REGION = 0
        nx = fix(sqrt(nplot+1)) & ny = nx
        WHILE nx*ny LT nplot+1 DO nx = nx+1
        !p.multi = [0, nx, ny, 0, 0]
        !X.margin = [4, 4]
        !Y.margin = [4, 3]
        skip = 0
    ENDIF ELSE nx = 1      
ENDIF 

FOR i = 0, nplot-1 DO BEGIN 
    
CASE plot_style OF
    0:BEGIN                     ;channel versus time

        CASE  iopts(8) OF       ;calibration choice
            
            0: BEGIN
                ;select indices of channels to plot
                n_ch=n_elements(energy_names)
                index=intarr(n_ch)
                for j=0,n_ch-1 do if (type(1) and 2^j) eq 2^j then index(j)=1
                index=where(index ne 0,c)
                y=yray(index,i)
                names=energy_names(index)
                x=findgen(n_elements(index))
                plotPar.xrange=[0, n_ch-1]
                plotpar.psym=-4
                plotpar.symsize=2 
                plotpar.XTITLE='channel #'
                plotpar.XLOG=0
                plotpar.XTICKS=n_ch-1
                plotpar.XTICKFORMAT=''
                plotpar=create_struct(plotpar,{XTICKNAME:names})
                plotpar=create_struct(plotpar,{XTICKV:x})
                uyt=uytitle
                info2=''
                doplot=1
                slice_utitle=utitle+'!CChannels, Counts'
            END  
            1: begin 
                message,'cannot draw spectrum for integral channels',/cont
            END 
            2: BEGIN
                if type(0) eq 5 then begin
                n_ch=n_elements(energy_names)
                index=intarr(n_ch)
                ;select indices of channels to plot
                for j=0,n_ch-1 do if (type(1) and 2^j) eq 2^j then index(j)=1
                index=where(index ne 0,c)
                y=yray(index,i)
                x_str=energy_names(index)
                x=fltarr(n_elements(index))
                for j=0,n_elements(index)-1 do $
                  if energy_ch(j,1) eq -1 then x(j)=energy_ch(j,0) else $
                  x(j)=(energy_ch(j,1)+energy_ch(j,0))/2
                plotPar.xrange=[0.1,10]
                plotpar.psym=-4
                plotpar.symsize=2
                uyt=uytitle
                info2=''
                doplot=1    
                slice_utitle=utitle+'!CBowtie, Diff Flux'
              endif  
            end  
            3: begin 
                message,'cannot draw spectrum for fit parameters',/cont
            END 
          
            4: BEGIN    ;FIT data for ns08, ns10, ns33, ns54
                
                CASE 1 OF 
                   (sat eq 'ns54'): BEGIN
                       y = yray(*, (timeindex+i) < (ndat-1))
                       x=float(energy_names)
                       uyt='[cts]s!u-1!ncm!u-2!nsr!u-1!nMeV!u-1!n'
                       slice_utitle=utitle
                       info2 = ''
                       doplot=1 
                       xst = min(x, max = xen)
                       plotPar.XRANGE = [xst, xen]
                       plotPar.YRANGE(0) = thisplotinfo.YSCALEMIN
                       plotPar.YRANGE(1) = thisplotinfo.YSCALEMAX
                       slice_utitle=utitle+'!C' + $
                         'x: '+varprt(xst)+'!C   '+varprt(xen)+ '!C' + $
                         'y: '+varprt(plotpar.YRANGE(0))+'!C   '+$
                               varprt(plotpar.YRANGE(1))+'!C'
                    END 
                    ELSE: BEGIN
                        ;find index for FIT parameters
                        result=strpos(energy_names,'FIT Density')
                        index=where(result ne -1,c)
                        if c eq 1 then n=yray(index(0),i) else n=0 
                        result=strpos(energy_names,'FIT Temp')
                        index=where(result ne -1,c)
                        if c eq 1 then T=yray(index(0),i) else T=0        
                        if(T le 0) OR (n le 0) then begin
                             erase  &  return
                        endif  
                        result=eval_rel_maxw(n, T)
                        x=result.E
                        y=result.J
                        doplot=1
                        plotPar.xrange=[0.1,10]
                        plotPar.yrange=[1e2,1e7]
                        uyt='[cts]s!u-1!ncm!u-2!nsr!u-1!nMeV!u-1!n'
                        slice_utitle=utitle+'!CFIT Diff Flux'
                        info2='Te='+varprt(T)+' MeV, n='+varprt(n)+' cm-3'
                    END 
                ENDCASE        
            END  
        ENDCASE      

    END  
    
    1: BEGIN                  ;L versus time cut plots
        plotPar.XRANGE = extra_plotPar.YRANGE
        plotPar.YRANGE = extra_plotPar.ZRANGE
        plotpar.XTITLE='L-value'
        plotpar.XLOG = 0
        uyt = uztit
        info2=''
        doplot=1
        slice_utitle=utitle
        x = yarr
        y = yray(timeindex, *)
    END
    ELSE: BEGIN 

    END
ENDCASE    
      
IF doplot EQ 0 THEN BEGIN
    message,'Panel does not contain spectrum plot, cannot do slice',/cont
    GOTO, out
ENDIF 
  
; set the panel window for the slice to full window
IF keyword_set(PANEL) THEN panel = panel ELSE panel = [0, 1, 1]


IF keyword_set(NOWIDGET) THEN BEGIN
    noerase = 1
    tick_frmt = 'noticks'
    plotPar.xtitle = ''
ENDIF ELSE BEGIN
    plotPar.ytitle = uyt
    IF i EQ 0 THEN erase
    noerase = 0
    tick_frmt = ''
ENDELSE 

IF slice_widget.oplot THEN BEGIN    ;do overplots
    plotPar.xtickformat=tick_frmt & plotPar.ytickformat=tick_frmt
    IF i EQ 0 THEN plot,x,y, _extra=plotPar, NOERASE = noerase $
    ELSE oplot,x,y, color = black+i
ENDIF ELSE BEGIN    ;do multi plots 
    
    IF i EQ nx-1 THEN skip = 1
    IF nplot GT 1 THEN BEGIN
        plotPar.xtickformat='noticks'
        plotPar.ytickformat='noticks'
        !p.multi(0) = (nx*ny)-(i+skip)
    ENDIF 
    plot,x,y, _extra=plotPar, NOERASE = noerase
ENDELSE


IF keyword_set(NOWIDGET) THEN BEGIN 
    IF (NOWIDGET EQ  2) THEN  BEGIN
        panelset, PANEL  
        right_side_label, panel, slice_utitle
    ENDIF 
    GOTO, out
ENDIF 


ENDFOR 

slice_utitle=slice_utitle+$
    '!CData Times:!C'+data_time_str(0)+'!C'+data_time_str(1)
right_side_label,[0,1,1],slice_utitle
  
out:
IF keyword_set(NOWIDGET) THEN return

info1=string(time_str(0)+' '+time_str(1), $
      yValue, format="('time: ',A20,'   Y-value: ',G10.2)")
; these calls put your info strings in the provided labels of the slice widget
WIDGET_CONTROL, slice_widget.lbl_slice1, SET_VALUE=info1
WIDGET_CONTROL, slice_widget.lbl_slice2, SET_VALUE=info2
  
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO levelzero_lanl_gps, seconds, yvalue
;*                                     
;* DESCRIPTION:  
;*      This procedure calls the widget for level zero data access 
;*      for this plottype. 
;*      slice_type in draw_lanl_gps must be set to +4 to enable this feature.
;*
;* INPUTS:       
;*      seconds           T90 time at which mouse is clicked
;*      yvalue            y-value at which mouse is clicked
;*
;* OUTPUTS: 
;*      none
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      levelzero_lanl_gps, seconds, yvalue
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel at Goddard
;******************************************************************************
pro levelzero_lanl_gps, seconds, yvalue

; The actual procedure is very dependent on what the level zero widget 
; application needs. An example is in $papco_MODULES/addpapco_swe_plots.pro.
; Provided as parameters to be passed to the new application, are the values
; of the mouse pointer when clicked. 
;
; The main widget remains active and can be swittched to (e.g. to get a new
; time from the graph) by using a "Parent" button in the new application
; which then executes the line
;            current_appl=xregistered('papco_main') 
; to swittch back to the papco main calling widget. 

; call the levelzero widget.  
;   lanl_gps_levelzero, seconds, yvalue

; the following line is printed on your xterm as a check to see if papco
; correctly called this routine. If there is a problem make sure your naming 
; convention is O.K. : This routine MUST be called levelzero_lanl_gps, 
; where lanl_gps is the name of the panel you have set in papcoadd_lanl_gps.

    print, 'got to the levelzero interface  ',seconds, yvalue

END


;******************************************************************************
;* PROCEDURE:     
;*      PRO WriteSlice_lanl_gps, panelNr, seconds, yValue
;* 
;* DESCRIPTION:  
;*      Draw a Write Paneldata slice for lanl_gps
;*      calling a seperate window for the widget
;*      slice_type in draw_ceppad must be set to +32 to enable this feature.
;*
;* INPUTS:       
;*      panelNr     an integer, the number of the panel for which the slice 
;*                  is to be drawn
;*      seconds     time of mouse click, a float
;*      yvalue      y-value of mouse click, a float
;*      
;* KEYWORDS:
;*      READDATA    if set the data needs to be re-read from file
;* 
;* CALLING SEQUENCE:
;*      called by papco_DrawSLice (in $papco_PATH/papco_cursor.pro)
;*
;* MODIFICATION HISTORY:       
;*      may 1997, written by R.Friedel
;******************************************************************************
PRO WriteSlice_lanl_gps, panelNr, seconds, yValue,READDATA=READDATA

COMMON PAPCO_WRITE_PANELDATA, sliceWidgetData
COMMON PLOT_COMPOSER, widgetData
COMMON lanl_gps_data, input_header, input_data

;   common lanl_gps_data, input_header, input_data
;   common lanl_gps_ephem, lanl_gps_ephem
;   common mjdt, mjdt_start, mjdt_end    ;common time limits in mjdt

   WIDGET_CONTROL,/HOURGLASS
   thisPlot=widgetData.plotsDrawn(panelNr)

; use the same typevector, swittch etc as is used in the call to your plot
; routine. thisPlot contains the full papco structure of plot information for
; the panel in which the mouse was clicked in. 

   thisPlot=widgetData.plotsDrawn(panelNr)
   type=thisPlot.typeVector
   getdatacall=thisPlot.get_data_call

;read the data if needed

;   if READDATA then begin 
;      callgood=execute(getdatacall)
;      r_lanl_gps_ephem
;   endif

; select the index for the time chosen out of the time array

;   DiffTimes=ABSlanl_gps(.time - seconds)
                                        ; this sets timeIndex to the index 
;   result=MIN(DiffTimes, tidx)         ; closest to 'seconds'

; these strings are user-definable output strings to label the slice window.
; The "write Panelinfo" window papco supplies has 6 lines of user-definable
; text. 

   info1='L-Value:'
   info2='User data  1'
   info3='User label 2'
   info4='User data 2'
   info5='User label 3'
   info6='User data 3'

; Time and y-value of mouse click are automatically put into labels.
; The calls below put your info strings in the provided user labels (max 6).
;
; NB NB NB:
; However, only info2, info4, info6 are written to file in the form
; info2+info4+info6.
;
; The idea is that info1 will have the labels for the data in info2, info3 the
; labels for the data in info4, and info5 the labels for the data in info6.
; Time and y-value of mouse click are written first, then info2+info4+info6
; followed by a user defined comment from the Write Paneldata window.

   WIDGET_CONTROL, sliceWidgetData.lbl_slice1, SET_VALUE=info1
   WIDGET_CONTROL, sliceWidgetData.lbl_slice2, SET_VALUE=info2
   WIDGET_CONTROL, sliceWidgetData.lbl_slice3, SET_VALUE=info3
   WIDGET_CONTROL, sliceWidgetData.lbl_slice4, SET_VALUE=info4
   WIDGET_CONTROL, sliceWidgetData.lbl_slice5, SET_VALUE=info5
   WIDGET_CONTROL, sliceWidgetData.lbl_slice6, SET_VALUE=info6

END


;******************************************************************************
PRO USER_MULTI_VERT_slice_lanl_gps_event, Event

COMMON USER_MULTI_VERT_Slice_cluster_rapid, slice_widget
COMMON slice_calls, slice_calls

widget_control,event.id,get_uvalue=ev
  
CASE ev OF 

    'pb_done' :  widget_control, slice_widget.base, /destroy
    'pb_help':   xdisplayfile, papco_helpfile('papco_slice.help'), $
                  title='papco online-help', group=event.top
    'pb_print':  begin ;loop through slices for all panels if needed
stop
      slice_widget.rsl_lines=0
      for i=0,n_elements(slice_calls)-1 do begin
        close_dev=[i,n_elements(slice_calls)-1]
        papco_printmenu_event,slice_calls(i), CLOSE_DEV=close_dev
      endfor  
    end
    'pb_output': begin
      ;establish error handler
      if widgetData.default_trap eq 1 then $
        catch, error_status else error_status=0
      if error_status ne 0 then begin    ;call error handler
        papco_error_handler, $
          error_status, proc_call, '', [0,0,0], /NO_ERR_DRAW
        error_status=0 & catch, /CANCEL ;disable error catching
        return
      endif
      tmp_str=slice_widget.slice_call  &  tmp_str=str_sep(tmp_str,',')
      proc_call=tmp_str(0)  &  panelNr=fix(tmp_str(1))
      seconds=float(tmp_str(2))  &  yValue=float(tmp_str(3))
      CALL_PROCEDURE,proc_call,panelNr,seconds,yValue,/OUTPUT
      catch, /CANCEL        ;disable error catching 
    end  
    else : begin & end
ENDCASE 

END


;******************************************************************************
PRO USER_MULTI_VERT_slice_lanl_gps, panelNr, seconds, yValue, CLOSE=CLOSE, $
                                    OVERPLOT=OVERPLOT, READDATA=READDATA, $
                                    NOWIDGET=NOWIDGET, PANEL=PANEL, $
                                    NUTITLE=NUTITLE, _EXTRA=E

COMMON USER_MULTI_VERT_Slice_cluster_rapid, slice_widget
COMMON plot_composer, widgetdata
COMMON slice_calls, slice_calls

; if slice window exists, bring it in front. ELSE, create it ------------------
if not xregistered('USER_MULTI_VERT_Slice_lanl_gps') then begin
    
    slice_base=widget_base(column=1, group=widgetdata.main_base, $
                           title='_USER_MULTI_VERT_Slice_lanl_gps')
    
;-- setup draw area -----------------------------------------------------------
    draw_base=WIDGET_BASE(Slice_base, COLUMN=1, /FRAME)
    dw_Slice  =WIDGET_DRAW(draw_base, XSIZE=700, YSIZE=700)

;-- set up label fields for user data -----------------------------------------
    user_label_base=WIDGET_BASE(slice_base, COLUMN=1, /FRAME)
    lbl_slice1=WIDGET_LABEL(user_label_base,VALUE=strcenter('uservalues',80))
    lbl_slice2=WIDGET_LABEL(user_label_base,VALUE=strcenter('uservalues',80))
   
    
;-- set up buttons for the Actions --------------------------------------------
    Butt_Base=WIDGET_BASE(Slice_Base, ROW=1, /FRAME)
    pb_help=WIDGET_BUTTON(Butt_Base, Value=strcenter('Help', 12), $
                          UVALUE='pb_help')
    
    pb_print=WIDGET_BUTTON(Butt_Base, Value=strcenter('Print', 12), $
                           UVALUE='pb_print')
    pb_output=WIDGET_BUTTON(Butt_Base, Value=strcenter('Output', 12), $
                           UVALUE='pb_output')    

    pb_done=WIDGET_BUTTON(Butt_Base, Value=strcenter('Close', 12), $
                          UVALUE='pb_done')

    slice_widget={rsl_lines:0, $ 
                  base:slice_base, $
                  dw_slice:dw_slice, $
		  lbl_slice1:lbl_slice1, $
                  lbl_slice2:lbl_slice2, $
                  pb_output:pb_output, $
                  slice_call:'', $
	          panelNr:panelNr, $
                  lastPanelDrawn:-1}
    
    widget_control, slice_base, /realize
    xmanager, 'USER_MULTI_VERT_Slice_lanl_gps', slice_base, /JUST_REG
    
ENDIF                           ; end construct slice window
    
IF keyword_set(NOPLOT) THEN return

WIDGET_CONTROL,/HOURGLASS


COMMON slice_lanl_gps
COMMON lanl_gps
COMMON lanl_gps_l, lanl_gps_l
COMMON mjdt, mjdt_start, mjdt_end ;common time limit in mjdt
COMMON papco_color_names

;--- now, we need to get the data --------------------------------------------
;    but we will only read the data, if the panel the user clicked is not the
;    panel that he last clicked into (in this case, the data is already read).
IF slice_widget.lastPanelDrawn NE panelNr THEN begin
    papco_get_slice_data, panelNr
    READDATA=1
endif else READDATA=0  

;--- prepare the drawing widget for plotting ----------------------------------
if !D.name eq 'X' then begin
    widget_control, slice_widget.dw_slice, get_value=drawindex
    wset, drawindex
endif  

;--- store the current coordinate system --------------------------------------
old_x = !x  &  old_y = !y  &  old_p = !p
  
; NOW do plot into draw window!!! ---------------------------------------------


thisPlot=widgetData.plotsDrawn(panelNr)
; use the same typevector, etc as is used in the call to your plot
; routine. thisPlot contains the full papco structure of plot information for
; the panel in which the mouse was clicked in. 
thisPlotdrawn=widgetData.plotsDrawn(panelNr)
thisPlotInfo =widgetData.plotinfos(panelNr)
   
satid =  thisPlotInfo.typeVector(0)
type  =  thisPlotInfo.typeVector
opts  =  thisPlotInfo.options
iopts =  thisplotInfo.ioptions
plot_style = thisPlotInfo.typeVector(2)

time_str=papco_cursor_time(seconds,panelNr)
time_mjdt=papco_cursor_time(seconds,panelNr,/mjdt)

info1=string(time_str, yValue, format="('time: ',A20,'   Y-value: ',f9.2)")
; these calls put your info strings in the provided labels of the slice widget
WIDGET_CONTROL, slice_widget.lbl_slice1, SET_VALUE=info1

; select the index for the time chosen out of the time array
CASE plot_style OF 
    5: BEGIN                  ;L versus time cut plots
        timeIndex = where(seconds GT (time(*, 0) ) AND $
                         (seconds LE time(*, 1)), c)
        timeIndex = timeIndex(0)
        IF c EQ 0 THEN BEGIN
              message, 'No data for this time', /cont
              GOTO, done_slice
        ENDIF
    END
    ELSE: BEGIN 
        DiffTimes=ABS(time - seconds)   ; this sets timeIndex to the index with
        result=MIN(DiffTimes, timeIndex)   ; t(index) is closest to 'seconds'
    END
ENDCASE

data_time=mjdt_start 
data_time.mjd=data_time.mjd + fix(seconds / 86400)
data_time.t=time(timeIndex) mod 86600
data_time_str=convert_secondsToTime(data_time,/t90,/mjdt, /country)
data_time_str=str_sep(data_time_str,' ')

; set the panel window to do !P.multi

!p.position = 0
!P.REGION = 0
!p.multi = [0, 4, 4, 0, 0]
!X.margin = [6, 6]
!Y.margin = [5, 5]
!Y.ticks=0 & !X.ticks=0 

; set plotPar structure  
plotpar=extra_plotPar  
plotPar.ylog=1
plotPar.color=1
plotpar.XTICKFORMAT="(f8.2)"
plotpar.linestyle = 0
plotpar=create_struct(plotpar,{YTICKS:0})
plotpar=create_struct(plotpar,{XLOG:0})
plotpar=create_struct(plotpar,{XTICKS:0})
plotpar=create_struct(plotpar,{XMINOR:0})
plotpar=create_struct(plotpar,{XTITLE:'L value'})  

CASE plot_style OF
    5: BEGIN                        ;trap boundary - this makes all L v. time
        xst = lanl_gps_l.L_ARR(0)
        xen = lanl_gps_l.L_ARR(n_elements(lanl_gps_l.L_ARR)-1)
        xen = 10
        plotPar.XRANGE = [xst, xen]
        plotPar.YRANGE = [1e0, 1e4]
        plotpar.XLOG = 0
    END
    ELSE: BEGIN
        message, ' This lanl_gps product not supported', /cont
        GOTO, done_slice
    END 
ENDCASE 

tags = tag_names(lanl_gps_l)
n_ch = n_elements(tags)-2
erase

FOR m = 0, 15 DO BEGIN
    !p.multi(0) = 16-m

    ;plot L v count plots for all channels for given time period.

    ;do plot axis first, no data
    plot,  findgen(4), _extra = plotpar, /nodata,  title = varprt(m)
    
    x = lanl_gps_l.L_ARR
    
    FOR ch = 0, n_ch-1 DO BEGIN
        y = transpose(lanl_gps_l.(ch+2)(timeindex+m, *))  
        oplot, x, y, color = black+ch

    ENDFOR     
    
ENDFOR 


; these two info strings are user-definable output strings to label the slice 
; window. To calculate the time use the start time in mjdt and the seconds 
; passed in. If your plot uses the papco philosophy then the time axis is in 
; running seconds since the start of the start day.
   
info1='This string not used yet'
info2=string(time_str, yValue, format="('time: ',A20,'   Y-value: ',f9.2)")
   
; these calls put your info strings in the provided labels of the slice widget
WIDGET_CONTROL, slice_widget.lbl_slice1, SET_VALUE=info1
WIDGET_CONTROL, slice_widget.lbl_slice2, SET_VALUE=info2 
  
done_slice:

;--- restore the coordinate-system --------------------------------------------
!x = old_x  &  !y = old_y  &  !p = old_p 
  
;--- keep old panel number- used for detecting panel changed of mouse ---------
slice_widget.lastPanelDrawn = panelNr   

END



;******************************************************************************
PRO USER_LVAL_slice_lanl_gps_event, Event

COMMON USER_LVAL_Slice_cluster_rapid, slice_widget
COMMON slice_calls, slice_calls

widget_control,event.id,get_uvalue=ev
  
CASE ev OF 

    'pb_done' :  widget_control, slice_widget.base, /destroy
    'pb_help':   xdisplayfile, papco_helpfile('papco_slice.help'), $
                  title='papco online-help', group=event.top
    'pb_print':  begin ;loop through slices for all panels if needed
stop
      slice_widget.rsl_lines=0
      for i=0,n_elements(slice_calls)-1 do begin
        close_dev=[i,n_elements(slice_calls)-1]
        papco_printmenu_event,slice_calls(i), CLOSE_DEV=close_dev
      endfor  
    end
    'pb_output': begin
      ;establish error handler
      if widgetData.default_trap eq 1 then $
        catch, error_status else error_status=0
      if error_status ne 0 then begin    ;call error handler
        papco_error_handler, $
          error_status, proc_call, '', [0,0,0], /NO_ERR_DRAW
        error_status=0 & catch, /CANCEL ;disable error catching
        return
      endif
      tmp_str=slice_widget.slice_call  &  tmp_str=str_sep(tmp_str,',')
      proc_call=tmp_str(0)  &  panelNr=fix(tmp_str(1))
      seconds=float(tmp_str(2))  &  yValue=float(tmp_str(3))
      CALL_PROCEDURE,proc_call,panelNr,seconds,yValue,/OUTPUT
      catch, /CANCEL        ;disable error catching 
    end  
    else : begin & end
ENDCASE 

END


;******************************************************************************
PRO USER_LVAL_slice_lanl_gps, panelNr, seconds, yValue, CLOSE=CLOSE, $
                              OVERPLOT=OVERPLOT, READDATA=READDATA, $
                              NOWIDGET=NOWIDGET, PANEL=PANEL, $
                              NUTITLE=NUTITLE, _EXTRA=E

COMMON USER_LVAL_Slice_cluster_rapid, slice_widget
COMMON plot_composer, widgetdata
COMMON slice_calls, slice_calls
COMMON lanl_gps

COMMON slice_lanl_gps
COMMON lanl_gps
COMMON lsort, lanl_gps_l

COMMON mjdt, mjdt_start, mjdt_end ;common time limit in mjdt
COMMON papco_color_names

cols = [red, green, blue, violet, dark_green, royal_blue]

; plotinfo contains the full papco structure of plot information for
; the panel in which the mouse was clicked in. 
thisplotinfo =widgetData.plotinfos(panelNr)
thisplotdrawn=widgetData.plotsDrawn(panelNr)

;get control variables for this module
control = *thisplotinfo.USR_PTR1
sat_name = sat_id(control.sc_id)   ;GPS satellite name, string
nodata = -99.0
  
satid =  control.sc_id
sat = sat_id(control.sc_id)   ;GPS satellite name, string
type  =  thisPlotInfo.typeVector
opts  =  thisPlotInfo.options
iopts =  thisplotInfo.ioptions
style =  control.plot_style

if keyword_set(OVERPLOT) then overplot=OVERPLOT else overplot=0
if keyword_set(NOWIDGET) then nowidget=NOWIDGET else nowidget=0

;--- now, we need to get the data --------------------------------------------
;    but we will only read the data, if the panel the user clicked is not the
;    panel that he last clicked into (in this case, the data is already read).

IF NOT keyword_set(slice_widget) THEN lastPanelDrawn = -1 $
  ELSE lastPanelDrawn = slice_widget.lastPanelDrawn

IF lastPanelDrawn NE panelNr THEN BEGIN
    ;don't use automatic read, specify plotinfo directly and call draw_lanl_gps
    new_plotinfo = thisPlotInfo
    new_control = control 
    ;set plot type trapping boundary, this "makes" all L-sorted data.
    new_control.plot_style = 5 ;trapp. boundary
    new_plotifo.USR_PTR1 = ptr_new(new_control)
    draw_lanl_gps, [0, 0, 1], new_plotinfo, 0, get_data_call, slice_type, 0, $
                   OUTPUT = 2
    READDATA=1
    time = lanl_gps_l.t_cut
endif else READDATA=0  

IF keyword_set(NOWIDGET) THEN BEGIN
    slice_widget={overplot:overplot, $
                  slice_call:'', $
	          panelNr:panelNr, $
                  lastPanelDrawn:-1}    
    goto, plotonly
ENDIF

; see if slice window needs to be closed --------------------------------------
IF keyword_set(CLOSE) THEN BEGIN
    if xregistered('USER_LVAL_Slice_lanl_gps') THEN $
      if n_elements(slice_widget) gt 0 then begin
	if slice_widget.base ne 0 then $
          widget_control, slice_widget.base, /destroy
        slice_widget.base=0
      endif
    return
ENDIF 

; if slice window exists, bring it in front. ELSE, create it ------------------
if not xregistered('USER_LVAL_Slice_lanl_gps') then begin
    
    slice_base=widget_base(column=1, group=widgetdata.main_base, $
                           title='_USER_LVAL_Slice_lanl_gps')
    
;-- setup draw area -----------------------------------------------------------
    draw_base=WIDGET_BASE(Slice_base, COLUMN=1, /FRAME)
    dw_Slice  =WIDGET_DRAW(draw_base, XSIZE=600, YSIZE=500)

;-- set up label fields for user data -----------------------------------------
    user_label_base=WIDGET_BASE(slice_base, COLUMN=1, /FRAME)
    lbl_slice1=WIDGET_LABEL(user_label_base,VALUE=strcenter('uservalues',80))
    lbl_slice2=WIDGET_LABEL(user_label_base,VALUE=strcenter('uservalues',80))
   
    
;-- set up buttons for the Actions --------------------------------------------
    Butt_Base=WIDGET_BASE(Slice_Base, ROW=1, /FRAME)
    pb_help=WIDGET_BUTTON(Butt_Base, Value=strcenter('Help', 12), $
                          UVALUE='pb_help')
    
    pb_print=WIDGET_BUTTON(Butt_Base, Value=strcenter('Print', 12), $
                           UVALUE='pb_print')
    pb_output=WIDGET_BUTTON(Butt_Base, Value=strcenter('Output', 12), $
                           UVALUE='pb_output')    

    pb_done=WIDGET_BUTTON(Butt_Base, Value=strcenter('Close', 12), $
                          UVALUE='pb_done')

    slice_widget={rsl_lines:0, $ 
                  base:slice_base, $
                  dw_slice:dw_slice, $
		  lbl_slice1:lbl_slice1, $
                  lbl_slice2:lbl_slice2, $
                  pb_output:pb_output, $
                  overplot:overplot, $
                  slice_call:'', $
	          panelNr:panelNr, $
                  lastPanelDrawn:-1}
    
    widget_control, slice_base, /realize
    xmanager, 'USER_LVAL_Slice_lanl_gps', slice_base, /JUST_REG
    
ENDIF                           ; end construct slice window

WIDGET_CONTROL,/HOURGLASS

; set the panel window for the slice to full window
!p.position=[0.1,0.1,0.75,0.95]  
IF keyword_set(PANEL) THEN panel = panel ELSE panel = [0, 1, 1]
panelset, panel

;--- prepare the drawing widget for plotting ----------------------------------
if !D.name eq 'X' then begin
    widget_control, slice_widget.dw_slice, get_value=drawindex
    wset, drawindex
endif  

plotonly:

;--- store the current coordinate system --------------------------------------
old_x = !x  &  old_y = !y  &  old_p = !p
  
; NOW do plot into draw window!!! ---------------------------------------------

time_str=papco_cursor_time(seconds,panelNr)
time_mjdt=papco_cursor_time(seconds,panelNr,/mjdt)

; select the index for the time chosen out of the time array
t = (time(*, 0)+time(*, 1) ) /2.0
DiffTimes=ABS(t - seconds)   ; this sets timeIndex to the index with
result=MIN(DiffTimes, timeIndex)   ; t(index) is closest to 'seconds'

data_time=mjdt_start 
data_time.mjd=data_time.mjd + fix(seconds / 86400)
data_time.t=time(timeIndex) mod 86600
data_time_str=convert_secondsToTime(data_time,/t90,/mjdt, /country)
data_time_str=str_sep(data_time_str,' ')

; set plotPar structure  
plotpar=extra_plotPar  
plotPar.ylog=1
plotPar.color=1
plotpar.XTICKFORMAT="(f8.2)"
plotpar.linestyle = 0
plotpar=create_struct(plotpar,{YTICKS:0})
plotpar=create_struct(plotpar,{XLOG:0})
plotpar=create_struct(plotpar,{XTICKS:0})
plotpar=create_struct(plotpar,{XMINOR:0})
plotpar=create_struct(plotpar,{XTITLE:'L value'})  

CASE 1 OF
    (style EQ 1) OR (style EQ 5): BEGIN 
        xst = floor(lanl_gps_l.L_ARR(0))
        xen = ceil(lanl_gps_l.L_ARR(n_elements(lanl_gps_l.L_ARR)-1))
        xen = 10
        plotPar.XRANGE = [xst, xen]
        plotPar.YRANGE =  [thisplotinfo.ZSCALEMIN, thisplotinfo.ZSCALEMAX]
        plotpar.XLOG = 0
        utitle='LANL-GPS '+sat + '!C'
        utitle = utitle+'x: '+varprt(xst)+'!C   '+varprt(xen)+ '!C'
        utitle = utitle+'y: '+varprt(plotpar.YRANGE(0))+'!C   '+$
                              varprt(plotpar.YRANGE(1))+'!C'
    END
    ELSE: BEGIN
        message, ' This lanl_gps product not supported', /cont
        GOTO, done_slice
    END 
ENDCASE 

tags = tag_names(lanl_gps_l)
n_ch = n_elements(tags)-2

;plot L v count plots for all channels for given time period.

IF keyword_set(NOWIDGET) THEN BEGIN
    plotPar.xtickformat='noticks'
    plotPar.xtitle=''
    plotPar=create_struct(plotPar, {ytickformat:'noticks'})
ENDIF ELSE erase 

;do plot axis first, no data
plot,  findgen(4), _extra = plotpar, /nodata

x = lanl_gps_l.L_ARR
ech_label = '!C!C!C!C'

FOR ch = 0, n_ch-1 DO BEGIN
    y = transpose(lanl_gps_l.(ch+2)(timeindex, *))  
    oplot, x, y, color = cols(ch)
ENDFOR 

IF keyword_set(NOWIDGET) THEN BEGIN 
    IF (NOWIDGET eq 2) THEN  BEGIN
        panelset, PANEL  
        right_side_label, panel, utitle
        FOR ch = 0, n_ch-1 DO BEGIN
            ech_label = ech_label+'!C'
            utitle = ech_label+energy_names(ch)
            right_side_label, panel, utitle, color = cols(ch)
        ENDFOR 
    ENDIF 
    GOTO, done_slice
ENDIF 

right_side_label, panel, utitle, /NOEXTEND
FOR ch = 0, n_ch-1 DO BEGIN
    ech_label = ech_label+'!C'
    utitle = ech_label+energy_names(ch)
    right_side_label, panel, utitle, color = cols(ch), /NOEXTEND
ENDFOR 

; these two info strings are user-definable output strings to label the slice 
; window. To calculate the time use the start time in mjdt and the seconds 
; passed in. If your plot uses the papco philosophy then the time axis is in 
; running seconds since the start of the start day.
   
info1='This string not used yet'
info2=string(time_str, yValue, format="('time: ',A20,'   Y-value: ',f9.2)")

; these calls put your info strings in the provided labels of the slice widget
WIDGET_CONTROL, slice_widget.lbl_slice1, SET_VALUE=info1
WIDGET_CONTROL, slice_widget.lbl_slice2, SET_VALUE=info2 
  
done_slice:

;--- restore the coordinate-system --------------------------------------------
!x = old_x  &  !y = old_y  &  !p = old_p 
  
;--- keep old panel number- used for detecting panel changed of mouse ---------
slice_widget.lastPanelDrawn = panelNr   

END
