;******************************************************************************
;* file papcoadd_lanl_gps
;*      papcoadd_lanl_gps
;*      papcoadd_lanl_gps_slice_thumbs
;* end
;*
;******************************************************************************

;******************************************************************************
;* PROCEDURE:
;*      PRO addplottype_lanl_gps,plottypes_base,buttonGeometry,pb_plottype
;*
;* DESCRIPTION:
;*      This procedure adds a button for this lanl_gps to the plottypes_base.
;*      The UVALUE declared here is critical, since it is used to construct
;*      the procedure names of all procedures contained in this add-in
;*      package, so that they can be automatically called when needed.
;*      The button itself can contain access to a sub-menu for further
;*      lanl_gpss.
;*
;* INPUTS:
;*      plottypes_base  the widget ID of the parent widget to contain the
;*                      plottype buttons.
;*
;* OUTPUTS:
;*      pb_plottype     the widget ID of the button created here.
;*      buttonGeometry  size of the button. Only used in simple
;*                      WIDGET_BUTTON to make them the same size as the
;*                      compound CW_PDMENU, pulldown for sub-types.
;*
;* KEYWORDS:
;*       none
;*
;* CALLING SEQUENCE:
;*      addplottype_lanl_gps,plottypes_base,buttonGeometry,pb_plottype
;******************************************************************************
pro addplottype_lanl_gps, plottypes_base, buttonGeometry, pdm_lanl_gps

MenuDesc = [ $
            { CW_PDMENU_S, 3, strcenter('LANL GPS',12) }, $
            { CW_PDMENU_S, 0, ' configure lanl gps ' }, $
            { CW_PDMENU_S, 0, ' lanl gps' }, $
            { CW_PDMENU_S, 2, ' lanl gps slice thumbs' }]

pdm_lanl_gps = CW_PDMENU(plottypes_base, MenuDesc, $
                         UVALUE='pdm_lanl_gps')

END

;******************************************************************************
;* PROCEDURE:
;*      PRO addpanel_lanl_gps
;*
;* DESCRIPTION:
;*      Calls the panel editor for this plottype and adds the plot to the
;*      panel window.
;*      Using an instance of the papco_PLOTINFO structure called "defaults"
;*      the default settings of the panel editor can be controlled. The
;*      desired default values for the plotinfo tags need to be edited by
;*      the user. This plotinfo structure will be passed to the panel editor
;*      When it is first called for the lanl_gps.
;*      "panelEditor" must be set to the name of the panel editor routine.
;*
;* INPUTS:
;*      event           event value of papco main window. This is
;*                      only used if there are plot sub_types,
;*                      for example see papcoadd_crres_plots
;* OUTPUTS:
;*      none
;*
;* KEYWORDS:
;*      none
;*
;* CALLING SEQUENCE:
;*      addpanel_lanl_gps
;***************************************************************************
pro addpanel_lanl_gps,event

  common get_error, get_err_no, get_err_msg

; The case statement here needs an entry for every submenu type you
; added in  the first procedure in this file (addplottype_lanl_gps).
; For each submenu entry, you will need to specify the panelEditor to use.

; The FIRST time you use this module you will have to configure it,
; i.e. set the data paths etc. Once you have done this PAPCO will
; write a lanl_gps.config file into your papco_user_XX/papco_modules_defaults
; directory.
; So here we check if this lanl_gps.config file exists, and if not,
; we disallow the execution of any other option apart from "configure
; lanl_gps". In this way the user is forced to configure the module
; before using it the first time!

r_module_config, strlowcase('lanl_gps'), config_data, msg
if (get_err_no ne 0) and (event.value ne 1) then begin
    print,'%addpanel_lanl_gps: You need to configure the module first'
    papco_module_configure,'lanl_gps'
    return
endif

panelKind='lanl_gps'

CASE event.value of
    1: BEGIN
        papco_module_configure, panelKind
    end
    2: BEGIN
        panelEditor=panelkind+'_panel'
        defaults=papco_getPlotInfoStruct() ;returns a basic plotinfo structure
        defaults.typeVector=[3,8191,0,0]  ;set some tags to desired defaults
        defaults.ioptions(17:19)=[55,20,0]
        defaults.options(0:1)=[55.0,20.0]
        defaults.options(2:3)=[1.0,12.0]
        papco_Add_Plot, panelEditor, panelKind, initialPlotInfo=defaults
    end
    3: BEGIN
        panelKind=panelKind+'_slice_thumbs'
        panelEditor=panelKind+'_panel'
        defaults=papco_getPlotInfoStruct() ;returns a basic plotinfo structure
        defaults.typeVector=[0,0,0,0]      ;set some tags to desired defaults
        papco_Add_Plot, panelEditor, panelKind, initialPlotInfo=defaults
    END
    else: begin
        message, 'Nothing defined for this submenu entry', /cont
        return
    END
ENDCASE

END

;******************************************************************************
FUNCTION lanl_gps_slice_thumbs_panel, aPlotInfo, GROUP=group, ACTION=ACTION

return, papco_slice_panel(aPlotInfo, GROUP=group, ACTION=ACTION, $
                          MODULE='lanl_gps')

END

;******************************************************************************
;* PROCEDURE:
;*      PRO plottable_lanl_gps, plottable
;*
;* DESCRIPTION:
;*      Sets a variable to indicate plottable with / without orbit.
;*      PAPCO provides "set time by orbit" feature for CRRES and POLAR
;*      so far. Included for compatibility with older CRRES modules
;*      which ONLY use orbit as input to their read/plot routines
;*      (plotting over orbit boundaries is not enabled for CRRES)
;*
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "plottable_" plus
;*      the panel_kind you have set for your submenu entry in
;*      addpanel_lanl_gps.
;*
;* INPUTS:
;*      none
;*
;* OUTPUTS:
;*      plottable        a boolean 0 if plottable only by orbit
;*                                 1 if plottable by time also.
;*
;* KEYWORDS:
;*      none
;*
;* CALLING SEQUENCE:
;******************************************************************************
PRO plottable_lanl_gps, plottable

   plottable=1     ; 1 -> plotable without orbit info, by time
                   ; 0 -> plotable only by orbit number not by time
END

;******************************************************************************
PRO plottable_lanl_gps_slice_thumbs, plottable

   plottable=1     ; 1 -> plotable without orbit info, by time
                   ; 0 -> plotable only by orbit number not by time
END

;******************************************************************************
;* PROCEDURE:
;*      PRO canget_lanl_gps, canget
;*
;* DESCRIPTION:
;*      Sets a variable to indicate that lanl_gps support the OUTPUT
;*      functionality.
;*
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "canget_" plus
;*      the panel_kind you have set for your submenu entry in
;*      addpanel_lanl_gps.
;*
;* INPUTS:
;*      none
;*
;* OUTPUTS:
;*      canget         a boolean 0 if this feature is not available
;*                               1 if this feature is available
;*
;* KEYWORDS:
;*      none
;*
;* CALLING SEQUENCE:
;*      canget_lanl_gps, canget
;******************************************************************************
PRO canget_lanl_gps, canget

   canget=  1      ; 1 -> plot routine can return just data to file
                   ; 0 -> feature disabled
END

;******************************************************************************
PRO canget_lanl_gps_slice_thumbs, canget

   canget=  1      ; 1 -> plot routine can return just data to file
                   ; 0 -> feature disabled
END

;******************************************************************************
;* PROCEDURE:
;*      PRO descriptor_lanl_gps, plotInfo, descriptStr
;*
;* DESCRIPTION:
;*      Constructs the string used to label plots in the panel window.
;*      The plotinfo structure passed in here is the panel's plotinfo
;*      as returned by the panel editor for this lanl_gps. You can use
;*      the information in that structure to construct some informative
;*      label for the panel which then appears in the Panel Compose list.
;*
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "descriptor_" plus
;*      the panel_kind you have set for your submenu entry in
;*      addpanel_lanl_gps.
;*
;* INPUTS:
;*      plotInfo        structure containing all data for this plot.
;*                      (structure type: papco_PLOTINFO,
;*                                             see papco_variables.text)
;*
;* OUTPUTS:
;*      descriptStr     a string containing the label
;*
;* KEYWORDS:
;*      none
;*
;* CALLING SEQUENCE:
;*      descriptor_lanl_gps, plotInfo, descriptStr
;******************************************************************************
pro descriptor_lanl_gps, plotInfo, descriptStr

COMMON lanl_gps

;get control variables for this module
control = *plotinfo.USR_PTR1
sat_name = sat_id(control.sc_id)

descriptStr = descriptStr + sat_name + ', ' + $
              style_names(control.plot_style) + ', ' + $
              flux_cal_names(control.cal)

END

;******************************************************************************
PRO descriptor_lanl_gps_slice_thumbs, plotInfo, descriptStr

descriptStr=descriptStr+'Slice Thumb plot'

END

;******************************************************************************
;* PROCEDURE:
;*      PRO draw_lanl_gps, panelVector, currPlotInfo, orbitNo $
;*                          get_data_call, slice_type, IsRead
;* DESCRIPTION:
;*      This procedure performs the actual data read call and the plot call
;*      for this plottype. The user need to pass to his plot routine all the
;*      parameters needed, typically these parameters are stored in the
;*      currplotinfo structure or constructed from them. The currplotinfo
;*      structure tags normally used for passing information from the panel
;*      editor to the plot routine are:
;*          type_vector - a four element array for choosing the type of data
;*                        (eg. elec or ion, diff or integ., pitch angle,
;*                             or sector, channel ....)
;*          swittch      - a three element vector for specific plot appearance
;*                        (eg. smoothing/averaging, interpolating ...)
;*          filename    - a filename
;*
;*      These tags have grown out of traditional usage and can be used for
;*      anything the user wants to use them for. There are plenty variables
;*      for most applications: Adding a new tag to the plotinfo structure
;*      is not user-definable but need to be done at the papco core level.
;*
;*      The panelVector MUST be passed to your plotroutine as it is used
;*      to set the panel position.
;*      The _EXTRA=extra_PlotInfo should be passed if you intend to make use
;*      of papco functionality such as overplotting, linestyle choice and
;*      color bar choice.
;*
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "draw_" plus
;*      the panel_kind you have set for your submenu entry in
;*      addpanel_lanl_gps.
;*
;* INPUTS:
;*      panelVector    position of the plot (see papco_conventions.text, 6)
;*      currPlotInfo   structure containing all data for this plot.
;*                     (structure papco_PLOTINFO, see papco_variables.text)
;*
;* OUTPUTS:
;*      get_data_call  a string containing the data call. Used by other
;*                     routines that need to know how to get the data
;*                     in a panel, e.g. to draw spectra, distribution functions
;*      IsRead         a boolean which is set when the the data is read the
;*                     first time. Useful if a given data-read puts data
;*                     into commons which can be plotted in many ways.
;*                     When set, data does not have to be read again.
;   slice_type:   Selects which slices are supported and for which slice
;                 routines have been written.
;                 This is an integer logical with 16 swittches. Currently
;                 there are 5 papco slices. You may extend this by
;                 further USER slices up to a total of 16 slices.
;                     0 = disable all slices
;                     1 = papco Zoom                 (2^0)
;                     2 = papco View Slice           (2^1)
;                     4 = papco Access level Zero    (2^2)
;                     8 = papco Write Paneldata      (2^3)
;                    16 = papco Hair Cursor          (2^4)
;                    32 = USER slice A or not used   (2^5)
;                    64 = USER slice B or not used   (2^6)
;                    "     "     "   "  "  "    "      "
;                 32768 = USER slice Z or not used  (2^15)
;
;   You can support more than one type of slice by arithmetically adding the
;   options, eg slice_type=1+4  support Zoom and Level Zero
;*
;* KEYWORDS:
;*      OUTPUT        if set then plot routine should output data to file,
;*                    as well as to screen.
;*
;* CALLING SEQUENCE:
;*      draw_lanl_gps, panelVector, currPlotInfo, orbitNo, $
;*                      get_data_call, slice_type, IsRead, NODATA=NODATA
;******************************************************************************
pro draw_lanl_gps, panel, PlotInfo, orbitNo, $
                   get_data_call, slice_type, IsRead, $
                   OUTPUT=OUTPUT

COMMON extra, extra_PlotInfo  ; passes in papco-set keywords structure

control = *plotinfo.USR_PTR1

plot_style = control.plot_style ;spec, line, L-stack
CASE 1 OF
    (plot_style EQ 1) OR (plot_style EQ 2) OR (plot_style EQ 4): $
          plot_call = 'p_lanl_gps_lspec'
    ELSE: plot_call = 'p_lanl_gps_line'
ENDCASE

get_data_call='' ; use new method, class plot routine

; as papco dynamically allocates slice values for the user defined
; slices, one needs to be able to find out this assignment! Use the
; following function to find out the slice values for any slices you
; might have added for your module, so that you know which values to enable!

;slice_assigned_value=papco_slice_value('USER Defined Slice A')

; set up which mouse functions to allow
slice_assigned_value_1 = papco_slice_value('USER MULTI VERT')
slice_assigned_value_2 = papco_slice_value('USER LVAL')
slice_type=1+2+8+16
slice_type = slice_type+slice_assigned_value_1+slice_assigned_value_2

IF NOT IsRead THEN BEGIN               ; check if data has already been read
    r_lanl_gps, PlotInfo, satid, VERBOSE = VERBOSE  ; read data

    ;read singles files too!
    if control.singles  eq 1 then r_lanl_gps_singles ,satid 

    ; check the read for success.
    IF papco_Draw_CheckResult(PlotInfo.panelKind, $
                              panel, orbitNr, $
                              PlotInfo.typeVector, $
                              PlotInfo.channel)       THEN IsRead=1 $
    ELSE IsRead=0
ENDIF

IF IsRead THEN call_procedure, plot_call, panel, PlotInfo, $
                               OUTPUT=OUTPUT, _EXTRA=extra_PlotInfo

if not control.reload then IsRead=0  ;always need to re-read this data.

; Note: The structure extra_PlotInfo passed to the plot routine contains the
;       following tags:
;                  overPlot               - overplot swittch
;                  plots_AtThisPosition   - no. of overplots here
;                  subtable               - index of papco colortable
;                  PSYM                   - linestyle keyword for plot
;                  COLOR                  - linecolor keyword for plot
;
;       They are set by papco and your plot routine can use them if you
;       want to support that functionality.

END

;******************************************************************************
PRO draw_lanl_gps_slice_thumbs, panelVector, currPlotInfo, orbitNo, $
                        get_data_call, slice_type, IsRead, OUTPUT=OUTPUT

papco_draw_slice, panelVector, currPlotInfo, orbitNo, get_data_call, $
                  slice_type, IsRead, MODULE='lanl_gps'

END
