;------------------------------------------------------------------------------
; routine to multiply channels by applicable gemetric factors.

pro desp_gps_count2flux, time_mjdt, data, satid, energy_ch
  
now = double(time_mjdt.mjd)+time_mjdt.t / 86400.0d
  
convert_t90_to_date, time_mjdt, year, day_oy, hour, minute, second,$
                        month, cmonth, day_om, /mjdt 
Ndays = 365.d0
if (year eq 4*(year/4) or year eq 400*(year/400)) then Ndays=366.d0
dec_y = double(year)+(day_oy + double(hour*3600+minute*60+second)/86400.d0)/double(Ndays)
threshold_e=''
  
case satid of
    'ns08': BEGIN
        geom_factor=[0.00330, 0.01065, 0.00434, 0.03630, $
                     1.0,  1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
        threshold_e=[0.400,  0.800,  1.600,  3.2,  3.75,   5.]
        energy_ch=fltarr(n_elements(threshold_e)-1,2)
        FOR i=0,n_elements(threshold_e)-2 DO BEGIN 
            energy_ch(i,0)=threshold_e(i)
            energy_ch(i,1)=threshold_e(i+1)
        ENDFOR 
        return
    END 
    'ns10': BEGIN 
        geom_factor=[0.00330, 0.01065, 0.00434, 0.03630, $
                     1.0,  1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
        threshold_e=[ 0.400,  0.800,  1.600,  3.2,  3.75,  5.]
        energy_ch=fltarr(n_elements(threshold_e)-1,2)
        FOR i=0,n_elements(threshold_e)-2 DO BEGIN 
            energy_ch(i,0)=threshold_e(i)
            energy_ch(i,1)=threshold_e(i+1)
        ENDFOR 
        return
    END 
    'ns18': begin
      result=convert_date_to_t90(doy=124, year=1990, $
                                 hour=0, minutes=50, seconds=24, /MJDT)
      tg4to5_1=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=164, year=1990, $
                                 hour=18, minutes=44, seconds=0, /MJDT)
      tg5to3=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=166, year=1990, $
                                 hour=9, minutes=14, seconds=23, /MJDT)
      tg3to4=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=187, year=1990, $
                                 hour=21, minutes=17, seconds=55, /MJDT)
      tg4to5_2=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=256, year=1990, $
                                 hour=3, minutes=25, seconds=37, /MJDT)
      tg5to4=double(result.mjd)+result.t / 86400.0d
      
      result=convert_date_to_t90(doy=276, year=1990, $
                                 hour=5, minutes=33, seconds=35, /MJDT)
      tg4to5_3=double(result.mjd)+result.t / 86400.0d
      
;      print,now,tg4to5_1,tg5to3,tg3to4,tg4to5_2,tg5to4,tg4to5_3
      case 1 of
        (now lt tg4to5_1): begin
          gain=4
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.340,    0.600,    1.2,    2.4,    0.00, $
                       0.0, 0.0]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]
	  
	  e_bg = [2.5,1.292,1.174,0.417,0.065,2.84,0.915]
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
        end  
        (now lt tg5to3 and now ge tg4to5_1): begin
          gain=5
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 1.5e-2, $
                       2.e-3,2.e-3]
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.41,    0.75,    1.3,    4., $
                       0., 0.0]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 0.4685*dec_y-930.17
	  if dec_y le 1992.386277d0 then e_bg(1) = 2.042 else e_bg(1) = 2.958
	  e_bg(2) = 0.3713*dec_y-738.07
	  e_bg(3) = 0.5415*dec_y-1076.9
	  e_bg(4) = 0.0793*dec_y-157.69
	  e_bg(5) = 0.7307*dec_y-1452.4
	  e_bg(6) = 0.8168*dec_y-1624.8
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
         end  
        (now lt tg3to4 and now ge tg5to3): begin   
          gain=3
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.80,    1.6,    0.00,    0.00,    0.00, $
                       0.0, 0.0]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.795,0.292,0.238,0.096,0.012,0.,0.]
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
        end  
        (now lt tg4to5_2 and now ge tg3to4): begin
          gain=4
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.340,    0.600,    1.2,    2.4,    0.00, $
                       0.0, 0.0]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]
	  
	  e_bg = [2.5,1.292,1.174,0.417,0.065,2.84,0.915]
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
        end  
        (now lt tg5to4 and now ge tg4to5_2): begin
          gain=5
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 1.5e-2, $
                       2.e-3,2.e-3]
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.41,    0.75,    1.3,    4., $
                       0., 0.0]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 0.4685*dec_y-930.17
	  if dec_y le 1992.386277d0 then e_bg(1) = 2.042 else e_bg(1) = 2.958
	  e_bg(2) = 0.3713*dec_y-738.07
	  e_bg(3) = 0.5415*dec_y-1076.9
	  e_bg(4) = 0.0793*dec_y-157.69
	  e_bg(5) = 0.7307*dec_y-1452.4
	  e_bg(6) = 0.8168*dec_y-1624.8
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
        end  
        (now lt tg4to5_3 and now ge tg5to4): begin
          gain=4
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.340,    0.600,    1.2,    2.4,    0.00, $
                       0.0, 0.0]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]
	  
	  e_bg = [2.5,1.292,1.174,0.417,0.065,2.84,0.915]
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
        end  
        (now ge tg4to5_3): begin
          gain=5
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 1.5e-2, $
                       2.e-3,2.e-3]
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.41,    0.75,    1.3,    4., $
                       0., 0.0]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 0.4685*dec_y-930.17
	  if dec_y le 1992.386277d0 then e_bg(1) = 2.042 else e_bg(1) = 2.958
	  e_bg(2) = 0.3713*dec_y-738.07
	  e_bg(3) = 0.5415*dec_y-1076.9
	  e_bg(4) = 0.0793*dec_y-157.69
	  e_bg(5) = 0.7307*dec_y-1452.4
	  e_bg(6) = 0.8168*dec_y-1624.8
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
         end  
      endcase

    end
    'ns24': begin
      result=convert_date_to_t90(doy=119, year=1992, $
                                 hour=8, minutes=45, seconds=35, /MJDT)
      tg6to5_1=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=109, year=1996, $
                                 hour=5, minutes=57, seconds=36, /MJDT)
      tg5to6_1=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=120, year=1996, $
                                 hour=23, minutes=48, seconds=00, /MJDT)
      tg6to5_2=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=123, year=1996, $
                                 hour=6, minutes=16, seconds=47, /MJDT)
      tg5to6_2=double(result.mjd)+result.t / 86400.0d

      case 1 of
        (now lt tg6to5_1): begin
          gain=6
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.5,    0.56,    0.85,    1.45, $
                       0., 0.]
          if dec_y gt 1994.d0 then begin
             threshold_e(0)=float(1.70309206090069d-03*(dec_y)^3 - 1.02176688470920d+01*(dec_y)^2 + 2.04335557960076d+04*dec_y - 1.36211721705640d+07)
             threshold_e(1)=float(2.06647073783550d-03*(dec_y)^3 - 1.23801880634617d+01*(dec_y)^2 + 2.47231817408602d+04*dec_y - 1.64573763840246d+07)
             threshold_e(2)=float(2.67637434021761d-03*(dec_y)^3 - 1.60068679879345d+01*(dec_y)^2 + 3.19112922273761d+04*dec_y - 2.12061060576962d+07)
             threshold_e(3)=float(0.4683497d0*dec_y - 933.9221d0)
             threshold_e(4)=float(0.d0)
             threshold_e(5)=float(0.d0)
             threshold_e(6)=float(0.d0)
	  endif
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  if dec_y le 1994.d0 then e_bg(0) = -5.5772d0*dec_y + 11123.d0 else e_bg(0) = -1.8174d0*dec_y + 3642.5d0
	  e_bg(1) =  -0.1506d0*dec_y + 302.94d0
	  if dec_y le 1994.d0 then e_bg(2) = 0.3925d0*dec_y - 780.78d0 else e_bg(2) = -9.12648139398d-02*dec_y^3 + 5.46924902641d+02*dec_y^2 - 1.09252312916d+06*dec_y + 7.27465161775d+08
	  if dec_y le 1994.d0 then e_bg(3) = 0.6217d0*dec_y - 1237.7d0 else e_bg(3) = -0.9269d0*dec_y + 1854.7d0
	  if dec_y le 1994.d0 then e_bg(4) = 0.0837d0*dec_y - 166.73d0 else e_bg(4) = -0.0854d0*dec_y + 170.79d0
	  if dec_y le 1994.d0 then e_bg(5) = 1.1381d0*dec_y - 2260.7d0 else e_bg(5) = -0.9186d0*dec_y + 1841.1d0
	  if dec_y le 1994.d0 then e_bg(6) = 0.3772d0*dec_y - 750.64d0 else e_bg(6) = -0.667d0*dec_y + 1335.7d0

	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
        end  
        (now ge tg6to5_1 and now lt tg5to6_1): begin
          gain=5
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.3,    0.55,    0.62,    1.01,    1.65, $
                       0., 0.]

          if dec_y gt 1994.d0 then begin
	     threshold_e(0)=2.62387549123591d-01*dec_y^3-1.57060882671885d+03*dec_y^2+3.13380215006322d+06*dec_y-2.08426935875397d+09
             threshold_e(1)=3.46858770351432d-01*dec_y^3-2.07624625437871d+03*dec_y^2+4.14270265030206d+06*dec_y-2.75529041015565d+09
	     threshold_e(2)=0.0408*dec_y-80.794
	     threshold_e(3)=0.4482*dec_y-892.87
	     threshold_e(4)=0.
	     threshold_e(5)=0.
	     threshold_e(6)=0.
	  endif
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 7.3807520243d-01*dec_y^3 - 4.4156673266d+03*dec_y^2 + 8.8058376645d+06*dec_y - 5.8536075066d+09
	  if dec_y le 1994.d0 then e_bg(1) = -0.2941*dec_y + 588.74 else e_bg(1) = 2.042d0
	  e_bg(2) = 0.5942*dec_y - 1182.7
	  e_bg(3) = -2.6917732d-01*dec_y^2 + 1.0741496d+03*dec_y - 1.0715926d+06
	  e_bg(4) = 1.6071798564d-02*dec_y^3 - 9.6179961255d+01*dec_y^2 + 1.9185952906d+05*dec_y - 1.2757359932d+08
	  e_bg(5) = -0.2083*dec_y + 421.83
	  e_bg(6) = 0.4897*dec_y - 974.45
	  
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
         end  
        (now ge tg5to6_1 and now lt tg6to5_2): begin
          gain=6
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.5,    0.56,    0.85,    1.45, $
                       0., 0.]
          if dec_y gt 1994.d0 then begin
             threshold_e(0)=float(1.70309206090069d-03*(dec_y)^3 - 1.02176688470920d+01*(dec_y)^2 + 2.04335557960076d+04*dec_y - 1.36211721705640d+07)
             threshold_e(1)=float(2.06647073783550d-03*(dec_y)^3 - 1.23801880634617d+01*(dec_y)^2 + 2.47231817408602d+04*dec_y - 1.64573763840246d+07)
             threshold_e(2)=float(2.67637434021761d-03*(dec_y)^3 - 1.60068679879345d+01*(dec_y)^2 + 3.19112922273761d+04*dec_y - 2.12061060576962d+07)
             threshold_e(3)=float(0.4683497d0*dec_y - 933.9221d0)
             threshold_e(4)=float(0.d0)
             threshold_e(5)=float(0.d0)
             threshold_e(6)=float(0.d0)
	  endif
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  if dec_y le 1994.d0 then e_bg(0) = -5.5772d0*dec_y + 11123.d0 else e_bg(0) = -1.8174d0*dec_y + 3642.5d0
	  e_bg(1) =  -0.1506d0*dec_y + 302.94d0
	  if dec_y le 1994.d0 then e_bg(2) = 0.3925d0*dec_y - 780.78d0 else e_bg(2) = -9.12648139398d-02*dec_y^3 + 5.46924902641d+02*dec_y^2 - 1.09252312916d+06*dec_y + 7.27465161775d+08
	  if dec_y le 1994.d0 then e_bg(3) = 0.6217d0*dec_y - 1237.7d0 else e_bg(3) = -0.9269d0*dec_y + 1854.7d0
	  if dec_y le 1994.d0 then e_bg(4) = 0.0837d0*dec_y - 166.73d0 else e_bg(4) = -0.0854d0*dec_y + 170.79d0
	  if dec_y le 1994.d0 then e_bg(5) = 1.1381d0*dec_y - 2260.7d0 else e_bg(5) = -0.9186d0*dec_y + 1841.1d0
	  if dec_y le 1994.d0 then e_bg(6) = 0.3772d0*dec_y - 750.64d0 else e_bg(6) = -0.667d0*dec_y + 1335.7d0

	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
	end
	
        (now ge tg6to5_2 and now lt tg5to6_2): begin
          gain=5
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.3,    0.55,    0.62,    1.01,    1.65, $
                       0., 0.]

          if dec_y gt 1994.d0 then begin
	     threshold_e(0)=2.62387549123591d-01*dec_y^3-1.57060882671885d+03*dec_y^2+3.13380215006322d+06*dec_y-2.08426935875397d+09
             threshold_e(1)=3.46858770351432d-01*dec_y^3-2.07624625437871d+03*dec_y^2+4.14270265030206d+06*dec_y-2.75529041015565d+09
	     threshold_e(2)=0.0408*dec_y-80.794
	     threshold_e(3)=0.4482*dec_y-892.87
	     threshold_e(4)=0.
	     threshold_e(5)=0.
	     threshold_e(6)=0.
	  endif
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 7.3807520243d-01*dec_y^3 - 4.4156673266d+03*dec_y^2 + 8.8058376645d+06*dec_y - 5.8536075066d+09
	  if dec_y le 1994.d0 then e_bg(1) = -0.2941*dec_y + 588.74 else e_bg(1) = 2.042d0
	  e_bg(2) = 0.5942*dec_y - 1182.7
	  e_bg(3) = -2.6917732d-01*dec_y^2 + 1.0741496d+03*dec_y - 1.0715926d+06
	  e_bg(4) = 1.6071798564d-02*dec_y^3 - 9.6179961255d+01*dec_y^2 + 1.9185952906d+05*dec_y - 1.2757359932d+08
	  e_bg(5) = -0.2083*dec_y + 421.83
	  e_bg(6) = 0.4897*dec_y - 974.45
	  
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
         end 
	  
        (now ge tg5to6_2): begin
          gain=6
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.5,    0.56,    0.85,    1.45, $
                       0., 0.]
          if dec_y gt 1994.d0 then begin
             threshold_e(0)=float(1.70309206090069d-03*(dec_y)^3 - 1.02176688470920d+01*(dec_y)^2 + 2.04335557960076d+04*dec_y - 1.36211721705640d+07)
             threshold_e(1)=float(2.06647073783550d-03*(dec_y)^3 - 1.23801880634617d+01*(dec_y)^2 + 2.47231817408602d+04*dec_y - 1.64573763840246d+07)
             threshold_e(2)=float(2.67637434021761d-03*(dec_y)^3 - 1.60068679879345d+01*(dec_y)^2 + 3.19112922273761d+04*dec_y - 2.12061060576962d+07)
             threshold_e(3)=float(0.4683497d0*dec_y - 933.9221d0)
             threshold_e(4)=float(0.d0)
             threshold_e(5)=float(0.d0)
             threshold_e(6)=float(0.d0)
	  endif
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  if dec_y le 1994.d0 then e_bg(0) = -5.5772d0*dec_y + 11123.d0 else e_bg(0) = -1.8174d0*dec_y + 3642.5d0
	  e_bg(1) =  -0.1506d0*dec_y + 302.94d0
	  if dec_y le 1994.d0 then e_bg(2) = 0.3925d0*dec_y - 780.78d0 else e_bg(2) = -9.12648139398d-02*dec_y^3 + 5.46924902641d+02*dec_y^2 - 1.09252312916d+06*dec_y + 7.27465161775d+08
	  if dec_y le 1994.d0 then e_bg(3) = 0.6217d0*dec_y - 1237.7d0 else e_bg(3) = -0.9269d0*dec_y + 1854.7d0
	  if dec_y le 1994.d0 then e_bg(4) = 0.0837d0*dec_y - 166.73d0 else e_bg(4) = -0.0854d0*dec_y + 170.79d0
	  if dec_y le 1994.d0 then e_bg(5) = 1.1381d0*dec_y - 2260.7d0 else e_bg(5) = -0.9186d0*dec_y + 1841.1d0
	  if dec_y le 1994.d0 then e_bg(6) = 0.3772d0*dec_y - 750.64d0 else e_bg(6) = -0.667d0*dec_y + 1335.7d0

	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
	end
      endcase

    end
    'ns28': begin
          result=convert_date_to_t90(doy=305, year=1992, $
                                 hour=0, minutes=0, seconds=0, /MJDT)
          tg2to3_1=double(result.mjd)+result.t / 86400.0d

          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.25,    0.53,    0.62,    0.9,    1.3, $
                       0., 0.]
          if dec_y gt 1994.d0 then begin
             threshold_e(0)=0.048d0*dec_y-95.545d0
             threshold_e(1)=0.0069d0*dec_y-13.305d0
             threshold_e(2)=0.0025d0*dec_y-4.3416d0
             threshold_e(3)=0.3219d0*dec_y-640.93d0
             threshold_e(4)=0.
             threshold_e(5)=0.
             threshold_e(6)=0.
          endif

          if now lt tg2to3_1 then begin
             threshold_e(5)=0.
             threshold_e(6)=0.
          endif
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

          e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
          e_bg(0) = 1.3501d0*dec_y - 2682.7d0
          e_bg(1) = 2.958d0
          e_bg(2) = 0.6445d0*dec_y - 1283.4d0
          e_bg(3) = 0.5827d0*dec_y - 1160.6d0
          if dec_y lt 1994.14d0 then e_bg(4) = 0.055d0*dec_y - 109.42d0 else e_bg(4) = -8.3526d-03*dec_y + 1.6705d+01
          e_bg(5) = 0.4631d0*dec_y - 918.39d0
          e_bg(6) = 0.3005d0*dec_y - 597.25d0
      
          p_bg = [0.,0.,0.,0.,0.,0.,0.]

    end
    'ns33': begin
      result=convert_date_to_t90(doy=343, year=1998, $
                                 hour=1, minutes=55, seconds=12, /MJDT)
      tg5to4_1=double(result.mjd)+result.t / 86400.0d
      
      result=convert_date_to_t90(doy=123, year=1999, $
                                 hour=23, minutes=33, seconds=49, /MJDT)
      tg4to5=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=125, year=1999, $
                                 hour=15, minutes=12, seconds=27, /MJDT)
      tg5to4_2=double(result.mjd)+result.t / 86400.0d
      
      
      case 1 of
        (now lt tg5to4_1): begin
          gain=5
          e_geom_factor=[1.62e-3, 1.26e-3, 4.788e-3, 9.36e-3, 4.4e-3, $
                       8.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.43,    0.82,    1.37,    2.27, $
                       0.0, 0.0]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0)= -0.2626d0*dec_y + 532.03d0
	  e_bg(1)= 6.708d0
	  e_bg(2)= 1.479d0
	  e_bg(3)= 0.0369d0*dec_y - 72.364d0
	  e_bg(4)= 0.0427d0*dec_y - 84.77d0
	  e_bg(5)= -0.0637d0*dec_y + 133.34d0
	  e_bg(6)= 0.1015d0*dec_y - 201.54d0

        end  
        (now ge tg5to4_1 and now lt tg4to5): begin
          gain=4
          e_geom_factor=[1.508e-3, 4.5e-3, 7.975e-3, 9.75e-3, 2.9e-3, $
                       2.e-3,2.e-2]
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.340,    0.80,    1.32,    2.38,    3.66, $
                       0., 0.]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 1.0727802871d-01*dec_y*dec_y*dec_y - 6.4345769727d+02*dec_y*dec_y + 1.2864933798d+06*dec_y - 8.5738019192d+08
	  e_bg(1) = -0.3095d0*dec_y + 621.54d0
	  e_bg(2) = 9.7926958461d-02*dec_y*dec_y*dec_y - 5.8745367087d+02*dec_y*dec_y + 1.1746905700d+06*dec_y - 7.8298212262d+08
	  e_bg(3) = 1.1930278379d-01*dec_y*dec_y*dec_y - 7.1565598952d+02*dec_y*dec_y + 1.4309896784d+06*dec_y - 9.5377766694d+08
	  e_bg(4) = 2.3636337518d-03*dec_y*dec_y*dec_y - 1.4153941646d+01*dec_y*dec_y + 2.8252096801d+04*dec_y - 1.8797496910d+07
	  e_bg(5) = 1.5189538817d-01*dec_y*dec_y*dec_y - 9.1116447124d+02*dec_y*dec_y + 1.8219121523d+06*dec_y - 1.2143295213d+09
	  e_bg(6) = 1.1609876894d-01*dec_y*dec_y*dec_y - 6.9648590276d+02*dec_y*dec_y + 1.3927577021d+06*dec_y - 9.2836194298d+08

         end  
        (now ge tg4to5 and now lt tg5to4_2): begin
          gain=5
          e_geom_factor=[1.62e-3, 1.26e-3, 4.788e-3, 9.36e-3, 4.4e-3, $
                       8.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.43,    0.82,    1.37,    2.27, $
                       0.0, 0.0]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0)= -0.2626d0*dec_y + 532.03d0
	  e_bg(1)= 6.708d0
	  e_bg(2)= 1.479d0
	  e_bg(3)= 0.0369d0*dec_y - 72.364d0
	  e_bg(4)= 0.0427d0*dec_y - 84.77d0
	  e_bg(5)= -0.0637d0*dec_y + 133.34d0
	  e_bg(6)= 0.1015d0*dec_y - 201.54d0

        end  
        (now ge tg5to4_2): begin
          gain=4
          e_geom_factor=[1.508e-3, 4.5e-3, 7.975e-3, 9.75e-3, 2.9e-3, $
                       2.e-3,2.e-2]
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.340,    0.80,    1.32,    2.38,    3.66, $
                       0., 0.]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 1.0727802871d-01*dec_y*dec_y*dec_y - 6.4345769727d+02*dec_y*dec_y + 1.2864933798d+06*dec_y - 8.5738019192d+08
	  e_bg(1) = -0.3095d0*dec_y + 621.54d0
	  e_bg(2) = 9.7926958461d-02*dec_y*dec_y*dec_y - 5.8745367087d+02*dec_y*dec_y + 1.1746905700d+06*dec_y - 7.8298212262d+08
	  e_bg(3) = 1.1930278379d-01*dec_y*dec_y*dec_y - 7.1565598952d+02*dec_y*dec_y + 1.4309896784d+06*dec_y - 9.5377766694d+08
	  e_bg(4) = 2.3636337518d-03*dec_y*dec_y*dec_y - 1.4153941646d+01*dec_y*dec_y + 2.8252096801d+04*dec_y - 1.8797496910d+07
	  e_bg(5) = 1.5189538817d-01*dec_y*dec_y*dec_y - 9.1116447124d+02*dec_y*dec_y + 1.8219121523d+06*dec_y - 1.2143295213d+09
	  e_bg(6) = 1.1609876894d-01*dec_y*dec_y*dec_y - 6.9648590276d+02*dec_y*dec_y + 1.3927577021d+06*dec_y - 9.2836194298d+08

         end  
      endcase
      
    end
    'ns39': begin
      e_geom_factor=[1.0, 1.0, 1.0, 1.0, $
                   1.0, 1.0, 1.0]
      p_geom_factor=[1.0, 1.0, 1.0, 1.0]

    end

    else : begin
      e_geom_factor=fltarr(7) & e_geom_factor(*)=1.0
      p_geom_factor=fltarr(4) & p_geom_factor(*)=1.0
    end  
ENDCASE 
 
     geom_factor = e_geom_factor
     for i=0,n_elements(geom_factor)-1 do begin
        data(i)=(data(i)-3.*e_bg(i))/geom_factor(i)
     endfor
  
    if threshold_e(0) ne '' then begin
      energy_ch=fltarr(n_elements(threshold_e),2)
      for i=0,n_elements(geom_factor)-1 do begin
        energy_ch(i,0)=threshold_e(i)
        energy_ch(i,1)=-1.0
      endfor  
    endif  

END

