;******************************************************************************
;* PROCEDURE:     
;*      PRO eval_specal, A,  Alpha,  Eo, flux, PSD   
;*
;* DESCRIPTION:  
;*      Evaluates the spectral fits for CXD done by M. Kippen
;*
;*      Spectral Model used in specal0.4b:
;*      ==================================
;*      
;*      In specal, an empirical model of the electron flux as a function of
;*      energy is fit to the 11 LEP+HXP electron energy deposition
;*      channels. This model consists of three variable fit parameters: A,
;*      Alpha, and Eo.  The model is defined as:
;*      
;*            PSD = A * (E/0.2)^Alpha * exp(-E/Eo)      
;*            
;*            FLUX = PSD * E*(E + 2*Emass)
;*      
;*      where E is the electron energy in MeV, Emass is the electron rest mass
;*      in MeV/c^2 (i.e., 0.511), PSD is the phase space density (units??),
;*      and FLUX is the differential electron flux in electrons/cm^2/s/MeV/sr. 
;*      
;******************************************************************************
PRO eval_specal, A,  Alpha,  Eo, E, flux_arr, PSD_arr   

;A,  Alpha,  Eo, E can all be arrays

Emass = 0.511

ndat = n_elements(A)
ech = n_elements(E)
flux_arr = fltarr(ndat, ech) & flux_arr(*) = -99
PSD_arr = fltarr(ndat, ech) &  PSD_arr(*) = -99

FOR i = 0, ndat-1 DO BEGIN 
    IF A(i) EQ 0 THEN CONTINUE
        
    ;note from Mark: Function is per 240
    ;sec, accumaltion periods for  counts!
    PSD = A(i) * (E/0.2)^Alpha(i) * exp(-E/Eo(i)) 
    PSD = PSD/240.0
    FLUX = PSD * E*(E + 2*Emass)

    PSD_arr(i, *) = PSD
    flux_arr(i, *) = FLUX

ENDFOR     

END 
