;* Do the required calibrations 
PRO lanl_gps_calib

COMMON lanl_gps
COMMON slice_lanl_gps

sat_name = sat_id(control.sc_id)   ;GPS satellite name, string

CASE control.cal OF ; calibration choice 
    0: uytitle='[cts] '+uytitle ;straight counts /channel

    1: BEGIN                    ;integral bowtie, Seb's cal
        uytitle='cm!e-2!nsr!e-1!n'+uytitle
        lanl_gps_counts2flux, data, sat_name, /ELECTRON, $
            BCKG = control.bckg
    END 
    2: BEGIN                    ;differential bowtie, Seb's cal
        uytitle='cm!e-2!nsr!e-1!nMeV!e-1!n'+uytitle
        lanl_gps_counts2flux, data, sat_name, /ELECTRON, /DIFF, $
            BCKG = control.bckg
    END 
    3: begin                    ;FIT parameters, Tom's fit
        if nplot eq 1 then begin  ;only change name for Fit params
            if strtrim(energy_names(pl_idx(0)),2) eq 'FIT Temp' then $
              uytitle='T (MeV)'
            if strtrim(energy_names(pl_idx(0)),2) eq 'FIT Density' then $
              uytitle='n (cm!u-3!n)'
            if strtrim(energy_names(pl_idx(0)),2) eq 'FIT Quality' then $
              uytitle='Q'
        endif else uytitle='[cts] '+uytitle
        energy_names=fit_energy_names_1
    END     
    4: BEGIN                    ;evaluate FIT, Tom's fit
        CASE 1 OF 
            (sat_name eq 'ns54'): BEGIN
                message, "calculating spectrum (M. Kippen's specal)", /cont
                A     = data.counts(60)
                Alpha = data.counts(61)
                Eo    = data.counts(62)
                E=float(energy_names) 
                eval_specal, A,  Alpha,  Eo, E, flux, PSD 
                IF n_ch EQ 1 THEN data.counts(0:n_ch-1) = flux ELSE $
                  data.counts(0:n_ch-1) = transpose(flux)
                uytitle='cm!e-2!nsr!e-1!nMeV!e-1!n'+uytitle
                utitle = utitle+'!CFIT, specal' 
            END
            ELSE : BEGIN 
                T=data.counts(12)  &  n=data.counts(13)  &  ndat=n_elements(T)
                E=float(energy_names) 
                yray=fltarr(n_elements(E),ndat)
                message,'calculating spectrum (rel. maxwellian)',/cont
                for i=0, ndat-1 do begin
                    spec=eval_rel_maxw(n(i), T(i), ENERGIES=E)
                    data(i).counts(0:n_ch-1)=spec.J
                ENDFOR 
                uytitle='cm!e-2!nsr!e-1!nMeV!e-1!n'+uytitle
                energy_names=strtrim(control.fit_ch,2)
                energy_names=(str_sep(strcompress(energy_names),' '))
            END 
        ENDCASE 
    END 

    5: BEGIN
    END   

    6: BEGIN ;coherent channels (all bdd's interpolated to same ech)
        lanl_gps_make_coherent, control, data, sat_name, /ELECTRON, $
            BCKG = control.bckg
        uytitle='cm!e-2!nsr!e-1!n'+uytitle
    END   

    7: BEGIN ;coherent channels (all bdd's interpolated to same ech), DIFF
        lanl_gps_make_coherent, control, data, sat_name, /ELECTRON, /DIFF, $
            BCKG = control.bckg
        uytitle='cm!e-2!nsr!e-1!nMeV!e-1!n'+uytitle
    END   

    ELSE : uytitle=uytitle

ENDCASE   

END
