;------------------------------------------------------------------------------
; routine to multiply channels by applicable gemetric factors.
; If DIFF set, find differential channels (LE1 to 5 only)

PRO lanl_gps_counts2flux, data, sat_name, BCKG = BCKG, $
                          DIFF=DIFF, ELECTRON=ELECTRON, PROTON=PROTON
 
COMMON mjdt, mjdt_start, mjdt_end ;common time limit in mjdt
COMMON lanl_gps
  
now=double(mjdt_start.mjd)+double(mjdt_start.t) / 86400.0d
convert_t90_to_date, mjdt_start, year, day_oy, hour, minute, second,$
                          month, cmonth, day_om, /mjdt 
Ndays = 365.
if (year eq 4*(year/4) or year eq 400*(year/400)) then Ndays=366.
now_dec = double(year) + (double(day_oy) + $
          double(hour*3600+minute*60+second)/86400.d0)/double(Ndays)
threshold_e=''
  
CASE sat_name OF

    'ns08': BEGIN
        geom_factor=[0.00330, 0.01065, 0.00434, 0.03630, $
                     1.0,  1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
        threshold_e=[0.400,  0.800,  1.600,  3.2,  3.75,   5.]
        energy_ch=fltarr(n_elements(threshold_e)-1,2)
        FOR i=0,n_elements(threshold_e)-2 DO BEGIN 
            energy_ch(i,0)=threshold_e(i)
            energy_ch(i,1)=threshold_e(i+1)
        ENDFOR 
        return 
    END     
    'ns10': BEGIN 
        geom_factor=[0.00330, 0.01065, 0.00434, 0.03630, $
                     1.0,  1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
        threshold_e=[ 0.400,  0.800,  1.600,  3.2,  3.75,  5.]
        energy_ch=fltarr(n_elements(threshold_e)-1,2)
        FOR i=0,n_elements(threshold_e)-2 DO BEGIN 
            energy_ch(i,0)=threshold_e(i)
            energy_ch(i,1)=threshold_e(i+1)
        ENDFOR 
        return
    END    
    'ns18': begin
      result=convert_date_to_t90(doy=124, year=1990, $
                                 hour=0, minutes=50, seconds=24, /MJDT)
      tg4to5_1=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=164, year=1990, $
                                 hour=18, minutes=44, seconds=0, /MJDT)
      tg5to3=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=166, year=1990, $
                                 hour=9, minutes=14, seconds=23, /MJDT)
      tg3to4=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=187, year=1990, $
                                 hour=21, minutes=17, seconds=55, /MJDT)
      tg4to5_2=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=256, year=1990, $
                                 hour=3, minutes=25, seconds=37, /MJDT)
      tg5to4=double(result.mjd)+result.t / 86400.0d
      
      result=convert_date_to_t90(doy=276, year=1990, $
                                 hour=5, minutes=33, seconds=35, /MJDT)
      tg4to5_3=double(result.mjd)+result.t / 86400.0d
      
;      print,now,tg4to5_1,tg5to3,tg3to4,tg4to5_2,tg5to4,tg4to5_3
      case 1 of
        (now lt tg4to5_1): begin
          gain=4
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 15.e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.340,    0.600,    1.2,    2.4,    0., $
                       1.15, 0.]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]
	  
	  e_bg = [2.5,1.292,1.174,0.417,0.065,2.84,0.915]
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
        end  
        (now lt tg5to3 and now ge tg4to5_1): begin
          gain=5
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 15.e-3, $
                       2.e-3,2.e-3]
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.41,    0.75,    1.3,    4., $
                       0.95, 1.7]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 0.4685*now_dec-930.17
	  if now_dec le 1992.386277 then e_bg(1) = 2.042 else e_bg(1) = 2.958
	  e_bg(2) = 0.3713*now_dec-738.07
	  e_bg(3) = 0.5415*now_dec-1076.9
	  e_bg(4) = 0.0793*now_dec-157.69
	  e_bg(5) = 0.7307*now_dec-1452.4
	  e_bg(6) = 0.8168*now_dec-1624.8
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
         end  
        (now lt tg3to4 and now ge tg5to3): begin   
          gain=3
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 15.e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.80,    1.6,    0.00,    0.00,    0.00, $
                       0.0, 0.0]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.795,0.292,0.238,0.096,0.012,0.,0.]
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
        end  
        (now lt tg4to5_2 and now ge tg3to4): begin
          gain=4
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 15.e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.340,    0.600,    1.2,    2.4,    0., $
                       1.15, 0.]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]
	  
	  e_bg = [2.5,1.292,1.174,0.417,0.065,2.84,0.915]
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
        end  
        (now lt tg5to4 and now ge tg4to5_2): begin
          gain=5
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 15.e-3, $
                       2.e-3,2.e-3]
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.41,    0.75,    1.3,    4., $
                       0.95, 1.7]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 0.4685*now_dec-930.17
	  if now_dec le 1992.386277 then e_bg(1) = 2.042 else e_bg(1) = 2.958
	  e_bg(2) = 0.3713*now_dec-738.07
	  e_bg(3) = 0.5415*now_dec-1076.9
	  e_bg(4) = 0.0793*now_dec-157.69
	  e_bg(5) = 0.7307*now_dec-1452.4
	  e_bg(6) = 0.8168*now_dec-1624.8
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
         end  
        (now lt tg4to5_3 and now gt tg5to4): begin
          gain=4
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 15.e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.340,    0.600,    1.2,    2.4,    0., $
                       1.15, 0.]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]
	  
	  e_bg = [2.5,1.292,1.174,0.417,0.065,2.84,0.915]
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
        end  
        (now ge tg4to5_3): begin
          gain=5
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 15.e-3, $
                       2.e-3,2.e-3]
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.41,    0.75,    1.3,    4., $
                       0.95, 1.7]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 0.4685*now_dec-930.17
	  if now_dec le 1992.386277 then e_bg(1) = 2.042 else e_bg(1) = 2.958
	  e_bg(2) = 0.3713*now_dec-738.07
	  e_bg(3) = 0.5415*now_dec-1076.9
	  e_bg(4) = 0.0793*now_dec-157.69
	  e_bg(5) = 0.7307*now_dec-1452.4
	  e_bg(6) = 0.8168*now_dec-1624.8
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
         end  
      endcase

    end
    'ns24': begin
      result=convert_date_to_t90(doy=119, year=1992, $
                                 hour=8, minutes=45, seconds=35, /MJDT)
      tg6to5_1=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=109, year=1996, $
                                 hour=5, minutes=57, seconds=36, /MJDT)
      tg5to6_1=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=120, year=1996, $
                                 hour=23, minutes=48, seconds=00, /MJDT)
      tg6to5_2=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=123, year=1996, $
                                 hour=6, minutes=16, seconds=47, /MJDT)
      tg5to6_2=double(result.mjd)+result.t / 86400.0d

      case 1 of
        (now lt tg6to5_1): begin
          gain=6
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.5,    0.56,    0.85,    1.45, $
                       0.81, 1.6]
          if now_dec gt 1994.d0 then begin
             threshold_e(0)=float(1.70309206090069d-03*(now_dec)^3 - 1.02176688470920d+01*(now_dec)^2 + 2.04335557960076d+04*now_dec - 1.36211721705640d+07)
             threshold_e(1)=float(2.06647073783550d-03*(now_dec)^3 - 1.23801880634617d+01*(now_dec)^2 + 2.47231817408602d+04*now_dec - 1.64573763840246d+07)
             threshold_e(2)=float(2.67637434021761d-03*(now_dec)^3 - 1.60068679879345d+01*(now_dec)^2 + 3.19112922273761d+04*now_dec - 2.12061060576962d+07)
             threshold_e(3)=float(0.4923d0*now_dec - 981.67d0)
             threshold_e(4)=float(0.d0)
             threshold_e(5)=float(0.2192d0*now_dec - 436.84d0)
             threshold_e(6)=float(0.d0)
	  endif
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  if now_dec le 1994.d0 then e_bg(0) = -5.5772d0*now_dec + 11123.d0 else e_bg(0) = -1.8174d0*now_dec + 3642.5d0
	  e_bg(1) =  -0.1506d0*now_dec + 302.94d0
	  if now_dec le 1994.d0 then e_bg(2) = 0.3925d0*now_dec - 780.78d0 else e_bg(2) = -9.12648139398d-02*now_dec^3 + 5.46924902641d+02*now_dec^2 - 1.09252312916d+06*now_dec + 7.27465161775d+08
	  if now_dec le 1994.d0 then e_bg(3) = 0.6217d0*now_dec - 1237.7d0 else e_bg(3) = -0.9269d0*now_dec + 1854.7d0
	  if now_dec le 1994.d0 then e_bg(4) = 0.0837d0*now_dec - 166.73d0 else e_bg(4) = -0.0854d0*now_dec + 170.79d0
	  if now_dec le 1994.d0 then e_bg(5) = 1.1381d0*now_dec - 2260.7d0 else e_bg(5) = -0.9186d0*now_dec + 1841.1d0
	  if now_dec le 1994.d0 then e_bg(6) = 0.3772d0*now_dec - 750.64d0 else e_bg(6) = -0.667d0*now_dec + 1335.7d0

	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
        end  
        (now ge tg6to5_1 and now lt tg5to6_1): begin
          gain=5
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.3,    0.55,    0.62,    1.01,    1.65, $
                       0.9, 1.7]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

          if now_dec gt 1994.d0 then begin
	     threshold_e(0)=2.62387549123591d-01*now_dec^3-1.57060882671885d+03*now_dec^2+3.13380215006322d+06*now_dec-2.08426935875397d+09
             threshold_e(1)=3.46858770351432d-01*now_dec^3-2.07624625437871d+03*now_dec^2+4.14270265030206d+06*now_dec-2.75529041015565d+09
	     threshold_e(2)=0.0408*now_dec-80.794
	     threshold_e(3)=0.4482*now_dec-892.87
	     threshold_e(4)=0.
	     threshold_e(5)=3.59936838315960d-01*now_dec^3-2.15512686639421d+03*now_dec^2+4.30128393758191d+06*now_dec-2.86155508974640d+09
	     threshold_e(6)=0.
	  endif

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 7.3807520243d-01*now_dec^3 - 4.4156673266d+03*now_dec^2 + 8.8058376645d+06*now_dec - 5.8536075066d+09
	  if now_dec le 1994.d0 then e_bg(1) = -0.2941*now_dec + 588.74 else e_bg(1) = 2.042d0
	  e_bg(2) = 0.5942*now_dec - 1182.7
	  e_bg(3) = -2.6917732d-01*now_dec^2 + 1.0741496d+03*now_dec - 1.0715926d+06
	  e_bg(4) = 1.6071798564d-02*now_dec^3 - 9.6179961255d+01*now_dec^2 + 1.9185952906d+05*now_dec - 1.2757359932d+08
	  e_bg(5) = -0.2083*now_dec + 421.83
	  e_bg(6) = 0.4897*now_dec - 974.45
	  
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
         end  
        (now ge tg5to6_1 and now lt tg6to5_2): begin
          gain=6
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.5,    0.56,    0.85,    1.45, $
                       0.81, 1.6]
          if now_dec gt 1994.d0 then begin
             threshold_e(0)=float(1.70309206090069d-03*(now_dec)^3 - 1.02176688470920d+01*(now_dec)^2 + 2.04335557960076d+04*now_dec - 1.36211721705640d+07)
             threshold_e(1)=float(2.06647073783550d-03*(now_dec)^3 - 1.23801880634617d+01*(now_dec)^2 + 2.47231817408602d+04*now_dec - 1.64573763840246d+07)
             threshold_e(2)=float(2.67637434021761d-03*(now_dec)^3 - 1.60068679879345d+01*(now_dec)^2 + 3.19112922273761d+04*now_dec - 2.12061060576962d+07)
             threshold_e(3)=float(0.4923d0*now_dec - 981.67d0)
             threshold_e(4)=float(0.d0)
             threshold_e(5)=float(0.2192d0*now_dec - 436.84d0)
             threshold_e(6)=float(0.d0)
	  endif
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  if now_dec le 1994.d0 then e_bg(0) = -5.5772d0*now_dec + 11123.d0 else e_bg(0) = -1.8174d0*now_dec + 3642.5d0
	  e_bg(1) =  -0.1506d0*now_dec + 302.94d0
	  if now_dec le 1994.d0 then e_bg(2) = 0.3925d0*now_dec - 780.78d0 else e_bg(2) = -9.12648139398d-02*now_dec^3 + 5.46924902641d+02*now_dec^2 - 1.09252312916d+06*now_dec + 7.27465161775d+08
	  if now_dec le 1994.d0 then e_bg(3) = 0.6217d0*now_dec - 1237.7d0 else e_bg(3) = -0.9269d0*now_dec + 1854.7d0
	  if now_dec le 1994.d0 then e_bg(4) = 0.0837d0*now_dec - 166.73d0 else e_bg(4) = -0.0854d0*now_dec + 170.79d0
	  if now_dec le 1994.d0 then e_bg(5) = 1.1381d0*now_dec - 2260.7d0 else e_bg(5) = -0.9186d0*now_dec + 1841.1d0
	  if now_dec le 1994.d0 then e_bg(6) = 0.3772d0*now_dec - 750.64d0 else e_bg(6) = -0.667d0*now_dec + 1335.7d0

	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
	end
        (now ge tg6to5_2 and now lt tg5to6_2): begin
          gain=5
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.3,    0.55,    0.62,    1.01,    1.65, $
                       0.9, 1.7]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

          if now_dec gt 1994.d0 then begin
	     threshold_e(0)=2.62387549123591d-01*now_dec^3-1.57060882671885d+03*now_dec^2+3.13380215006322d+06*now_dec-2.08426935875397d+09
             threshold_e(1)=3.46858770351432d-01*now_dec^3-2.07624625437871d+03*now_dec^2+4.14270265030206d+06*now_dec-2.75529041015565d+09
	     threshold_e(2)=0.0408*now_dec-80.794
	     threshold_e(3)=0.4482*now_dec-892.87
	     threshold_e(4)=0.
	     threshold_e(5)=3.59936838315960d-01*now_dec^3-2.15512686639421d+03*now_dec^2+4.30128393758191d+06*now_dec-2.86155508974640d+09
	     threshold_e(6)=0.
	  endif

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 7.3807520243d-01*now_dec^3 - 4.4156673266d+03*now_dec^2 + 8.8058376645d+06*now_dec - 5.8536075066d+09
	  if now_dec le 1994.d0 then e_bg(1) = -0.2941*now_dec + 588.74 else e_bg(1) = 2.042d0
	  e_bg(2) = 0.5942*now_dec - 1182.7
	  e_bg(3) = -2.6917732d-01*now_dec^2 + 1.0741496d+03*now_dec - 1.0715926d+06
	  e_bg(4) = 1.6071798564d-02*now_dec^3 - 9.6179961255d+01*now_dec^2 + 1.9185952906d+05*now_dec - 1.2757359932d+08
	  e_bg(5) = -0.2083*now_dec + 421.83
	  e_bg(6) = 0.4897*now_dec - 974.45
	  
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
         end  
        (now ge tg5to6_2): begin
          gain=6
          e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.5,    0.56,    0.85,    1.45, $
                       0.81, 1.6]
          if now_dec gt 1994.d0 then begin
             threshold_e(0)=float(1.70309206090069d-03*(now_dec)^3 - 1.02176688470920d+01*(now_dec)^2 + 2.04335557960076d+04*now_dec - 1.36211721705640d+07)
             threshold_e(1)=float(2.06647073783550d-03*(now_dec)^3 - 1.23801880634617d+01*(now_dec)^2 + 2.47231817408602d+04*now_dec - 1.64573763840246d+07)
             threshold_e(2)=float(2.67637434021761d-03*(now_dec)^3 - 1.60068679879345d+01*(now_dec)^2 + 3.19112922273761d+04*now_dec - 2.12061060576962d+07)
             threshold_e(3)=float(0.4923d0*now_dec - 981.67d0)
             threshold_e(4)=float(0.d0)
             threshold_e(5)=float(0.2192d0*now_dec - 436.84d0)
             threshold_e(6)=float(0.d0)
	  endif
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  if now_dec le 1994.d0 then e_bg(0) = -5.5772d0*now_dec + 11123.d0 else e_bg(0) = -1.8174d0*now_dec + 3642.5d0
	  e_bg(1) =  -0.1506d0*now_dec + 302.94d0
	  if now_dec le 1994.d0 then e_bg(2) = 0.3925d0*now_dec - 780.78d0 else e_bg(2) = -9.12648139398d-02*now_dec^3 + 5.46924902641d+02*now_dec^2 - 1.09252312916d+06*now_dec + 7.27465161775d+08
	  if now_dec le 1994.d0 then e_bg(3) = 0.6217d0*now_dec - 1237.7d0 else e_bg(3) = -0.9269d0*now_dec + 1854.7d0
	  if now_dec le 1994.d0 then e_bg(4) = 0.0837d0*now_dec - 166.73d0 else e_bg(4) = -0.0854d0*now_dec + 170.79d0
	  if now_dec le 1994.d0 then e_bg(5) = 1.1381d0*now_dec - 2260.7d0 else e_bg(5) = -0.9186d0*now_dec + 1841.1d0
	  if now_dec le 1994.d0 then e_bg(6) = 0.3772d0*now_dec - 750.64d0 else e_bg(6) = -0.667d0*now_dec + 1335.7d0

	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
	end
      endcase
    end
    'ns28': begin
      result=convert_date_to_t90(doy=305, year=1992, $
                                 hour=0, minutes=0, seconds=0, /MJDT)
      tg2to3_1=double(result.mjd)+result.t / 86400.0d

      e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.60e-3, $
                       2.e-3,2.e-3] 
      p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

      threshold_e=[  0.25,    0.53,    0.62,    0.9,    1.3, $
                       1.2, 2.2]
      threshold_p=[   6.0, 14.0, 20.0, 50.0]

      if now_dec gt 1994.d0 then begin
         threshold_e(0)=0.048d0*now_dec-95.545d0
         threshold_e(1)=0.0069d0*now_dec-13.305d0
         threshold_e(2)=0.0025d0*now_dec-4.3416d0
         threshold_e(3)=0.3219d0*now_dec-640.93d0
         threshold_e(4)=0.
         threshold_e(5)=4.16488312909706d-01*now_dec^4-3.32421865488719d+03*now_dec^2 $
                       +9.94964490039061d+06*now_dec^2-1.32355815988914d+10*now_dec $
                       +6.60251982893802d+12
         threshold_e(6)=0.
      endif

      if now lt tg2to3_1 then begin
         threshold_e(5)=0.
         threshold_e(6)=0.
      endif

      e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
      e_bg(0) = 1.3501d0*now_dec - 2682.7d0
      e_bg(1) = 2.958d0
      e_bg(2) = 0.6445d0*now_dec - 1283.4d0
      e_bg(3) = 0.5827d0*now_dec - 1160.6d0
      if now_dec lt 1994.14d0 then e_bg(4) = 0.055d0*now_dec - 109.42d0 else e_bg(4) = -8.3526d-03*now_dec + 1.6705d+01
      e_bg(5) = 0.4631d0*now_dec - 918.39d0
      e_bg(6) = 0.3005d0*now_dec - 597.25d0
      
      p_bg = [0.,0.,0.,0.,0.,0.,0.]
    end
    'ns33': begin
      result=convert_date_to_t90(doy=343, year=1998, $
                                 hour=1, minutes=55, seconds=12, /MJDT)
      tg5to4_1=double(result.mjd)+result.t / 86400.0d
      
      result=convert_date_to_t90(doy=123, year=1999, $
                                 hour=23, minutes=33, seconds=49, /MJDT)
      tg4to5=double(result.mjd)+result.t / 86400.0d

      result=convert_date_to_t90(doy=125, year=1999, $
                                 hour=15, minutes=12, seconds=27, /MJDT)
      tg5to4_2=double(result.mjd)+result.t / 86400.0d
      
      
      case 1 of
        (now lt tg5to4_1): begin
          gain=5
          e_geom_factor=[1.62e-3, 1.26e-3, 4.788e-3, 9.36e-3, 4.4e-3, $
                       8.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.43,    0.82,    1.37,    2.27, $
                       1.13, 2.4]
          if now_dec le 1996.6d0 then begin
	      threshold_e(5)=0.7
	      threshold_e(6)=1.9
	  endif
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0)= -0.2626d0*now_dec + 532.03d0
	  e_bg(1)= 6.708d0
	  e_bg(2)= 1.479d0
	  e_bg(3)= 0.0369d0*now_dec - 72.364d0
	  e_bg(4)= 0.0427d0*now_dec - 84.77d0
	  e_bg(5)= -0.0637d0*now_dec + 133.34d0
	  e_bg(6)= 0.1015d0*now_dec - 201.54d0
	  
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
        end  
        (now ge tg5to4_1 and now lt tg4to5): begin
          gain=4
          e_geom_factor=[1.508e-3, 4.5e-3, 7.975e-3, 9.75e-3, 2.9e-3, $
                       2.e-3,2.e-2]
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.340,    0.80,    1.32,    2.38,    3.66, $
                       1.9, 3.1]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 1.0727802871d-01*now_dec*now_dec*now_dec - 6.4345769727d+02*now_dec*now_dec + 1.2864933798d+06*now_dec - 8.5738019192d+08
	  e_bg(1) = -0.3095d0*now_dec + 621.54d0
	  e_bg(2) = 9.7926958461d-02*now_dec*now_dec*now_dec - 5.8745367087d+02*now_dec*now_dec + 1.1746905700d+06*now_dec - 7.8298212262d+08
	  e_bg(3) = 1.1930278379d-01*now_dec*now_dec*now_dec - 7.1565598952d+02*now_dec*now_dec + 1.4309896784d+06*now_dec - 9.5377766694d+08
	  e_bg(4) = 2.3636337518d-03*now_dec*now_dec*now_dec - 1.4153941646d+01*now_dec*now_dec + 2.8252096801d+04*now_dec - 1.8797496910d+07
	  e_bg(5) = 1.5189538817d-01*now_dec*now_dec*now_dec - 9.1116447124d+02*now_dec*now_dec + 1.8219121523d+06*now_dec - 1.2143295213d+09
	  e_bg(6) = 1.1609876894d-01*now_dec*now_dec*now_dec - 6.9648590276d+02*now_dec*now_dec + 1.3927577021d+06*now_dec - 9.2836194298d+08
	  
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
         end  
        (now ge tg4to5 and now lt tg5to4_2): begin
          gain=5
          e_geom_factor=[1.62e-3, 1.26e-3, 4.788e-3, 9.36e-3, 4.4e-3, $
                       8.e-3,2.e-3] 
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.275,    0.43,    0.82,    1.37,    2.27, $
                       1.13, 2.4]
          if now_dec le 1996.6d0 then begin
	      threshold_e(5)=0.7
	      threshold_e(6)=1.13
	  endif
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0)= -0.2626d0*now_dec + 532.03d0
	  e_bg(1)= 6.708d0
	  e_bg(2)= 1.479d0
	  e_bg(3)= 0.0369d0*now_dec - 72.364d0
	  e_bg(4)= 0.0427d0*now_dec - 84.77d0
	  e_bg(5)= -0.0637d0*now_dec + 133.34d0
	  e_bg(6)= 0.1015d0*now_dec - 201.54d0
	  
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
        end  
        (now ge tg5to4_2): begin
          gain=4
          e_geom_factor=[1.508e-3, 4.5e-3, 7.975e-3, 9.75e-3, 2.9e-3, $
                       2.e-3,2.e-2]
          p_geom_factor=[1.6E-3, 1.6E-3, 1.6E-3,!pi]

          threshold_e=[  0.340,    0.80,    1.32,    2.38,    3.66, $
                       1.9, 3.1]
          threshold_p=[   6.0, 14.0, 20.0, 50.0]

	  e_bg = [0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0]
	  e_bg(0) = 1.0727802871d-01*now_dec*now_dec*now_dec - 6.4345769727d+02*now_dec*now_dec + 1.2864933798d+06*now_dec - 8.5738019192d+08
	  e_bg(1) = -0.3095d0*now_dec + 621.54d0
	  e_bg(2) = 9.7926958461d-02*now_dec*now_dec*now_dec - 5.8745367087d+02*now_dec*now_dec + 1.1746905700d+06*now_dec - 7.8298212262d+08
	  e_bg(3) = 1.1930278379d-01*now_dec*now_dec*now_dec - 7.1565598952d+02*now_dec*now_dec + 1.4309896784d+06*now_dec - 9.5377766694d+08
	  e_bg(4) = 2.3636337518d-03*now_dec*now_dec*now_dec - 1.4153941646d+01*now_dec*now_dec + 2.8252096801d+04*now_dec - 1.8797496910d+07
	  e_bg(5) = 1.5189538817d-01*now_dec*now_dec*now_dec - 9.1116447124d+02*now_dec*now_dec + 1.8219121523d+06*now_dec - 1.2143295213d+09
	  e_bg(6) = 1.1609876894d-01*now_dec*now_dec*now_dec - 6.9648590276d+02*now_dec*now_dec + 1.3927577021d+06*now_dec - 9.2836194298d+08
	  
	  p_bg = [0.,0.,0.,0.,0.,0.,0.]
         end  
        endcase
      
    END 

    'ns39': BEGIN
        e_geom_factor=[1.6e-3, 1.6e-3, 1.6e-3, 1.6e-3, 0.30e-3, 1.6e-3,1.6e-3] 
        p_geom_factor=[1.0, 1.0, 1.0, 1.0]
  
        threshold_e=[0.0,  0.0,  0.0,  0.0, 0.0, 1.4, 0.0]
        threshold_p=[6.0, 14.0, 20.0, 50.0]

	e_bg = [0.,0.,0.,0.,0.,0.,0.]
	p_bg = [0.,0.,0.,0.,0.,0.,0.]
    END 

    ELSE: BEGIN
        message, 'No cal available for '+sat_name, /info
        e_geom_factor=fltarr(7) & e_geom_factor(*)=1.0
        p_geom_factor=fltarr(4) & p_geom_factor(*)=1.0
    END 
 
ENDCASE 

if keyword_set(ELECTRON) then begin
    geom_factor = e_geom_factor
    n=n_elements(geom_factor)
    FOR i=0, n-1 DO BEGIN 
        index_bad_data=where(data.counts(i) eq -99.0,c)
        IF keyword_set(BCKG) THEN $
          data.counts(i)=( data.counts(i)-e_bg(i) ) / geom_factor(i) $
        ELSE $
          data.counts(i)=data.counts(i) / geom_factor(i)
        IF c NE 0 THEN data(index_bad_data).counts(i)=-99.0
    ENDFOR 
ENDIF 

if keyword_set(PROTON) then begin
    geom_factor = p_geom_factor
    threshold_e = threshold_p
    res=size(data.ymat)  
    for i=0,n_elements(geom_factor)-1 do begin
        for j=0,res(1)-1 do data.ymat(j,i)=(data.ymat(j,i)-p_bg(i))/geom_factor(i)
    endfor
ENDIF 
  
IF keyword_set(DIFF) THEN BEGIN 
    for i=0,3 do begin
        energy_ch(i,0)=threshold_e(i)
        energy_ch(i,1)=threshold_e(i+1)
        delta = energy_ch(i,1)-energy_ch(i,0)
        ch_c= sqrt(energy_ch(i,1)*energy_ch(i,0))

        x = where((data.counts(i) EQ -99.0) OR (data.counts(i+1) EQ -99.0), c)
        diff_data = data.counts(i) - data.counts(i+1)
        IF c NE 0 THEN diff_data(x) = -99.0
        IF ch_c EQ 0 THEN data.counts(i) = -99.0 ELSE $
          data.counts(i) = diff_data / delta
        idx_bad=where (data.counts(i) LT 0,cc)
        if cc ne 0 then data(idx_bad).counts(i)=-99.0

        new_str='['+string(energy_ch(i,*) ,format="(f5.3,'-',f5.3)")+']'
        energy_names(i)=new_str
    ENDFOR 
ENDIF ELSE BEGIN    
    IF threshold_e(0) NE '' THEN BEGIN 
        FOR i=0,4 DO BEGIN 
            new_str='LE'+string(i+1,format="(i1)")+'[>'+$
                         string(threshold_e(i),format="(f5.3)")+']'
            energy_names(i)=new_str
            energy_ch(i,0)=threshold_e(i)
            energy_ch(i,1)=-1.0
        ENDFOR    
    ENDIF   
ENDELSE 

message, 'appllied', /cont

END 

