;------------------------------------------------------------------------------
; routine to multiply channels by applicable gemetric factors.
; If DIFF set, find differential channels (LE1 to 5 only)

PRO lanl_gps_flux_geom_fact, data, sat, DIFF=DIFF
  
COMMON mjdt, mjdt_start, mjdt_end ;common time limit in mjdt
COMMON lanl_gps

now=double(mjdt_start.mjd)+mjdt_start.t / 86400.0d
threshold_e=''
  
case sat of
    'ns08': begin
      geom_factor=[0.00330, 0.01065, 0.00434, 0.03630, $
                   1.0,  1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
    end   
    'ns10': begin
      geom_factor=[0.00330, 0.01065, 0.00434, 0.03630, $
                   1.0,  1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
    end    
    'ns18': begin
      geom_factor=[1.35e-3, 0.9e-3, 1.33e-3, 1.56e-3, $
                   0.6e-3, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
    end
    'ns24': begin
      geom_factor=[1.35e-3, 0.9e-3, 1.33e-3, 1.56e-3, $
                   0.6e-3, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
    end
    'ns28': begin
      geom_factor=[1.35e-3, 0.9e-3, 1.33e-3, 1.56e-3, $
                   0.6e-3, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
    end
    'ns33': begin
      result=convert_date_to_t90(doy=343, year=1998, $
                                 hour=1, minutes=55, seconds=12, /MJDT)
      tg5to4=double(result.mjd)+result.t / 86400.0d
      
      case 1 of
        (now lt tg5to4): begin
          gain=5
          geom_factor=[1.35e-3, 0.90e-3, 1.33e-3, 1.56e-3, 0.60e-3, $
                       1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
          threshold_e=[  0.275,    0.43,    0.82,    1.37,    2.27, $
                       1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
        end  
        (now ge tg5to4): begin
          gain=4
          geom_factor=[1.16e-3, 1.25e-3, 1.45e-3, 1.30e-3, 0.29e-3, $
                       1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
          threshold_e=[  0.340,    0.80,    1.32,    2.38,    3.66, $
                       1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
         end  
      endcase
      
    end
    'ns39': begin
      geom_factor=[1.0, 1.0, 1.0, 1.0, $
                   1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
    end

    else : begin
      geom_factor=fltarr(11) & geom_factor(*)=1.0
    end  
ENDCASE 

n=n_elements(data(0).counts)

  for i=0,n-1 do begin
      index_bad_data=where(data.counts(i) eq -99.0,c)
    data.counts(i)=data.counts(i)/geom_factor(i)
    if c ne 0 then data(index_bad_data).counts(i)=-99.0
  endfor

if keyword_set(DIFF) then BEGIN
test=data.counts
    for i=0,3 do begin
        energy_ch(i,0)=threshold_e(i)
        energy_ch(i,1)=threshold_e(i+1)
        ch_c= 10^((alog10(energy_ch(i,1))+alog10(energy_ch(i,0)))/2.0)
        x = where((data.counts(i) EQ -99.0) OR (data.counts(i+1) EQ -99.0), c)
        diff_data = data.counts(i) - data.counts(i+1)
        IF c NE 0 THEN diff_data(x) = -99.0
        data.counts(i) = diff_data/ch_c
         idx_bad=where (data.counts(i) lt 0,cc)
        if cc ne 0 then data(idx_bad).counts(i)=-99.0

        new_str='['+string(energy_ch(i,*) ,format="(f5.3,'-',f5.3)")+']'
        energy_names(i)=new_str
    ENDFOR 

endif else begin    
    if threshold_e(0) ne '' then begin
      for i=0,4 do begin
        new_str='LE'+string(i+1,format="(i1)")+'[>'+string(threshold_e(i),$
                                             format="(f5.3)")+']'
        energy_names(i)=new_str
        energy_ch(i,0)=threshold_e(i)
        energy_ch(i,1)=-1.0
      endfor  
    endif  
endelse
  
message,'appllied',/cont

END 
