PRO  lanl_gps_make_coherent, control, data, sat_name, $
                            ELECTRON = ELECTRON, BCKG = BCKG, DIFF = DIFF
COMMON lanl_gps 

ek_arr = float(strsplit(control.coh_ch, ',', /EXTRACT))
e_ch = n_elements(ek_arr)

;loop thorugh individual times and get conversion factors, as they may
;change during a given time period.

FOR i = 0, n_elements(data)-1 DO BEGIN

    t = tai2utc(data(i).time)
    time_mjdt = {mjd:t.mjd, t:t.time/1000.0}

    in_data = data(i).counts
    desp_gps_count2flux, time_mjdt, in_data, sat_name, energy_ch
    data_buf = in_data

    ;interpolate to set energy range
    FOR j = 0, n_elements(ek_arr)-1 DO BEGIN 
        idx=where(energy_ch(*,0) LE ek_arr(j) AND energy_ch(*,0) GT 0.,c)
	IF c EQ 0 THEN BEGIN 
	    in_data(j)=-99. & goto, endint
        ENDIF 
	idx=where(energy_ch(*,0) gt ek_arr(j),c)
	IF c EQ 0 THEN in_data(j)=-99. ELSE BEGIN ;interpolate
            IF (data_buf(idx(0)) LE 0. OR data_buf(idx(0)-1) LE 0.) THEN BEGIN 
                in_data(j)=-99. 
            ENDIF ELSE BEGIN 
	        alph = (ALOG(data_buf(idx(0))/data_buf(idx(0)-1))/$
		         ALOG(energy_ch(idx(0),0)/energy_ch(idx(0)-1,0)))-1.
	        dens = data_buf(idx(0))*(alph+1)/(energy_ch(idx(0),0)^(1+alph))
                in_data(j)=dens*(ek_arr(j)^(1+alph))/(1+alph)  ;flux int
            ENDELSE  
        ENDELSE 
	endint:
    ENDFOR 

    data(i).counts = in_data

ENDFOR

IF keyword_set(DIFF) THEN BEGIN 
    energy_ch = fltarr(e_ch-1, 2)
    energy_names = strarr(e_ch-1)
    FOR i = 0, e_ch-2 DO BEGIN 
        energy_ch(i,0)=ek_arr(i)
        energy_ch(i,1)=ek_arr(i+1)
        ch_c= sqrt(energy_ch(i,1)*energy_ch(i,0))

        x = where((data.counts(i) EQ -99.0) OR (data.counts(i+1) EQ -99.0), c)
        diff_data = data.counts(i) - data.counts(i+1)
        IF c NE 0 THEN diff_data(x) = -99.0
        IF ch_c EQ 0 THEN data.counts(i) = -99.0 ELSE $
          data.counts(i) = diff_data/(energy_ch(i,1)-energy_ch(i,0))
        idx_bad=where (data.counts(i) LT 0,cc)
        if cc ne 0 then data(idx_bad).counts(i)=-99.0

        new_str='['+string(energy_ch(i,*) ,format="(f5.3,'-',f5.3)")+']'
        energy_names(i)=new_str
    ENDFOR 
ENDIF ELSE BEGIN    
    energy_ch = fltarr(e_ch, 2)
    energy_names = strarr(e_ch)
    FOR i = 0, e_ch-1 DO BEGIN 
       new_str='[>'+string(ek_arr(i),format="(f5.3)")+']'
       energy_names(i)=new_str
       energy_ch(i,0)=ek_arr(i)
       energy_ch(i,1)=-1.0
    ENDFOR    
ENDELSE 

message, 'applied', /cont

END  
