;------------------------------------------------------------------------------
;program to attempt the identification of the relativistic electron
;trapping boundary.
;
;-99 marks when a channel reaches background counts. This CANNOT be used
;to delineate the trapping boundary. We need more strict
;conditions. We require at least two channels to show a steep gradient
;at the same time, for a change in counts of at least .5
;decade, i.e. no "soft" landings into background. Also, We require
;that we start sufficiently far away from background, i.e. with count
;rates greater than 50. 
;
;------------------------------------------------------------------------------
PRO lanl_gps_trapping_boundary, plotinfo, data, to_plot, trap_b, thresholds, $
                                concur, DIAG=DIAG
  
COMMON papco_color_names
COMMON plot_composer, widgetdata
COMMON lsort, lsort
COMMON lanl_gps_otions, type, options, ioptions, soptions
  
pl_idx=where(to_plot EQ 1, nplot)

col=[red, green, blue, magenta, red, cyan]
message,'Using '+varprt(nplot)+' channels' ,/cont

nodata = -99.0
lbin = 0.05
model = ''
yst = 4 & yen = 12
time = data.time

exe_str = "lanl_gps_make_Lvt, plotinfo, time, y, yst, yen, " + $
          "L_arr, T_cut, Zarr, LBIN = LBIN, N_CUTS = N_CUTS, MODEL = model"

FOR i = 0, nplot-1 DO BEGIN     ;make all the L_arrays needed

    y    = data.counts(pl_idx(i))
    IF i NE 0 THEN exe_str2 =exe_str+', /HAVE_EPH' ELSE exe_str2 =exe_str
    result=execute(exe_str2)

    IF i EQ 0 THEN BEGIN
        lsort = {L_arr:L_arr, T_cut:T_cut}
        lsort = create_struct(lsort, 'zarr_'+varprt(i), zarr)
    ENDIF ELSE BEGIN
        lsort = create_struct(lsort, 'zarr_'+varprt(i), zarr)
    ENDELSE

ENDFOR

;find steepest slope of L-profile for each channel - in log space
ndat=n_elements(t_cut)/2  
nl= n_elements(L_arr)/2
profile=fltarr(nl)
dummy={time:0.0d, L_STEP:fltarr(nplot), STEP:fltarr(nplot), COUNT:0}
trap_b=replicate(dummy,ndat)
  
;set log step size for drop per L range,
;i.e. how many decades drop per L. "Steep" = -0.5 decades in 0.1 L
;thus require a slope of -0.5 / 0.1 = -5

sl_l = -2

;set required starting count rate. This needs to be channel dependent! 
;here use the background level detected (cts/sec) and set 
;starting count rate to be above that. 
thresholds = [10, 5, 3, 3]
start_counts=thresholds*2
message,'Finding slopes of '+varprt(sl_l)+' decades/L... ',/cont

FOR i = 0, ndat-1 DO BEGIN
    count=0
    trap_b(i).time = (t_cut(i, 0) +  t_cut(i, 1) ) /2

    FOR k = 0, nplot-1 DO BEGIN 

        profile = transpose(lsort.(k+2)(i,*))
        idx=where(profile NE nodata, c)
        IF c GT 10 THEN BEGIN 
            n_prof=profile(idx)  &  L_prof=L_arr(idx)
        ENDIF ELSE CONTINUE

        ;work on logarythmic profile, search for slope > sl_l dec/L
        log_prof=alog10(n_prof)
        n=n_elements(log_prof)
        log_prof_diff=log_prof(1:n-1)-log_prof(0:n-2)
        L_prof_diff = L_prof(1:n-1)-L_prof(0:n-2)

        ;now have diff's in profile counts AND in L.
        ;require a certain slope, diff counts / diff L

        slope = log_prof_diff / L_prof_diff
        min_sl = min(slope, min_idx)

        IF (min_sl LE sl_l) AND n_prof(min_idx) GE start_counts(k) THEN BEGIN

            l_step=L_prof((min_idx+1) < (n_elements(L_prof)-1))
            l_diff = L_prof_diff(min_idx)

            trap_b(i).l_step(k)=l_step  &  trap_b(i).step(k)=min_sl
            ; get the time for this L-profile
            time_tai = trap_b(i).time
            result=TAI2UTC(time_tai, /ECS)
            title=string(i, format = "(i4.4)")+' - '+result+'  '        
            print, title, varprt(k), min_sl, n_prof(min_idx), l_step
            count=count+1
        ENDIF

    ENDFOR  
    trap_b(i).count=count
    count=0
ENDFOR 


IF NOT keyword_set(DIAG) THEN return


;plot out the l profiles selected
old_panel=!P.position  &  !P.position=[0.1,0.15,0.9,0.9]

IF diag EQ 2 THEN BEGIN
    set_plot, 'PS'
    fln = '/u/friedel/gps_rad_cut.ps'
    xoffset=0.2 &  yoffset=0.2
    xsize=7.8   &  ysize=xsize*0.8/0.6
    device,/inches, /color, bits=8, filename=fln, $
       xoffset=xoffset, yoffset=yoffset+ysize, xsize=ysize, $
       ysize=xsize, landscape=1
ENDIF ELSE BEGIN
     set_plot, 'x'
     window,5, title='L-profiles' , xpos=200, ypos=300   
ENDELSE

yrange=[1,5000]

    index=where(trap_b.count ge concur, c); require at least 2 steps
    if c ne 0 then begin
      for i=0, n_elements(index)-1 do begin
        idx=index(i)
        ; get the time for this L-profile
        title=varprt(idx)+' - ' + TAI2UTC(trap_b(idx).time, /ECS)

        erase
        plot_io, findgen(12), xrange=[4,12], yrange=yrange, color=1, $
          xtitle='L-value', ytitle='counts', title=title, /nodata, $
          charsize = 2

        FOR k = 0, nplot-1 DO BEGIN 
            profile = transpose(lsort.(k+2)(idx,*)) 
            index2=where(profile GT 0,c)
            IF c NE 0 THEN BEGIN 
                n_prof=profile(index2)
                L_prof=L_arr(index2)
            ENDIF   
            l_step=trap_b(idx).l_step(k)  &  step=trap_b(idx).step(k)
            IF l_step NE 0 THEN BEGIN 
                linestyle=0
                oplot,[l_step,l_step], yrange, linestyle=2, color=1
            ENDIF ELSE linestyle=1
            oplot, L_prof, n_prof, color=col(k), linestyle=linestyle  
        ENDFOR 
        wait, 0.5
    ENDFOR 
ENDIF 
  
!P.position=old_panel 
  
IF diag EQ 2 THEN BEGIN
    device, /close
    set_plot, 'X'
ENDIF ELSE BEGIN
    wdelete,5  &  wset, widgetData.draw_window
ENDELSE 

END 
