pro make_gps_coherent

;.run gps_dead_time.pro
;.run desp_gps_counts2flux.pro

   day_month = [31,27,31,30,31,30,31,31,30,31,30,31]
   day_month_bi = [31,28,31,30,31,30,31,31,30,31,30,31]

; check for env. variable pointing to data directory to save L_bin data
   data_dir='GPS_FLUX_COH'
   path_coh=papco_getenv(data_dir)
   if strlen(path_coh) eq 0 then begin
     get_err_no=1
     get_err_msg='Environmental variable '+data_dir+' not set'
     print,get_err_msg
     return
   endif

; check for existence of data directory
   cc=papco_finddir(path_coh)
   if cc eq 0 then begin
     get_err_no=2
     get_err_msg='Data directory '+path_coh+' not found'
     print,get_err_msg
     return
   endif
   
; check for env. variable pointing to data directory
   data_dir='GPS_FLUX_DATA'
   path=papco_getenv(data_dir)
   if strlen(path) eq 0 then begin
     get_err_no=1
     get_err_msg='Environmental variable '+data_dir+' not set'
     print,get_err_msg
     return
   endif

; check for existence of data directory
   cc=papco_finddir(path)
   if cc eq 0 then begin
     get_err_no=2
     get_err_msg='Data directory '+path+' not found'
     print,get_err_msg
     return
   endif


;reading file month after month

sat = 'GPS'
;sat_id = 'ns18'
sat_id = 'ns24'
;sat_id = 'ns28'
;sat_id = 'ns33'

  energy=[  0.280, 0.400, 0.560, 0.800, 1.120, 1.600, 2.240, 3.200]
r=''
   typeNames=['0.280 MeV', $
              '0.400 MeV', $
              '0.560 MeV', $
              '0.800 MeV', $
              '1.120 MeV', $
              '1.600 MeV', $
              '2.240 MeV', $
              '3.200 MeV']

   time={MJDT, MJD:0l, T:0.0d}
   input_header={ tag1: typeNames,$
                                  satname:''}
    input_header.satname = 'GPS ' + sat_id

   dummy={electron : fltarr(n_elements(typeNames)), $
          mjdt_time: time     , $
          time     : 0.0d0    }
r=''

;   for yer=1990,1994 do begin                     ; ns18
;   for yer=1991,2000 do begin                     ; ns24
   for yer=1993,1993 do begin                     ; ns24
;   for yer=1992,1996 do begin                     ; ns28
;   for yer=1996,2001 do begin                     ; ns33

       openr,1,path+'GPS_'+sat_id+'/bdd2/'+string(yer,format="(i4.4)")+'/data/liste.dat'
       while not eof(1) do begin
           fln = ''
           readf,1,fln
	   print,fln
	   res=str_sep(fln,'.')
           input_header=0  &  input_data=0   
           restore,path+'GPS_'+sat_id+'/bdd2/'+string(yer,format="(i4.4)")+'/data/' $
	   +res(0)+'.idl'
           dealloc_lun,/quiet    ;frees logical units used by save/restore
	   input_data_buf = input_data
	   input_data=replicate(dummy,n_elements(input_data_buf))
	   input_data.mjdt_time = input_data_buf.mjdt_time
	   input_data.time = input_data_buf.time
	   
	   input_header.tag1=typeNames
           input_header.satname = 'GPS ' + sat_id
	   
	   lanl_gps_deadtime_correction, input_data_buf, sat_id
	   for i=0,n_elements(input_data_buf)-1 do begin
	       aux = input_data_buf(i).time
               doy = floor(aux)
               aux = (aux-double(doy))*24.D0
               hour = floor(aux)
               aux = (aux-double(hour))*60.D0
               min = floor(aux)
               aux = (aux-double(min))*60.D0
               s = floor(aux)
               time_mjdt=convert_date_to_t90(year=yer, doy=doy ,$
                        hour=hour , minute = min , second = s,  /MJDT)
	       now = double(time_mjdt.mjd)+time_mjdt.t / 86400.0d
	       
	       data=input_data_buf(i).electron
	       desp_gps_count2flux,time_mjdt,data, sat_id,energy_ch
	       input_data_buf(i).electron=data
;	       print,energy_ch
;	       stop
 ;interpolate
	       for j=0,n_elements(energy)-1 do begin
		       index=where(energy_ch(*,0) le energy(j) and energy_ch(*,0) gt 0.,count)
		       if count eq 0 then begin
		          input_data(i).electron(j)=-1.
			  goto,endint
		       endif
		       index=where(energy_ch(*,0) gt energy(j),count)
		       if count eq 0 then input_data(i).electron(j)=-1. else begin ;interpolate
		          if (input_data_buf(i).electron(index(0)) le 0. or input_data_buf(i).electron(index(0)-1) le 0.) then begin
			    input_data(i).electron(j)=-1. 
			  endif else begin
		          alpha = (ALOG(input_data_buf(i).electron(index(0))/input_data_buf(i).electron(index(0)-1))/$
			          ALOG(energy_ch(index(0),0)/energy_ch(index(0)-1,0)))-1.
		          dens = input_data_buf(i).electron(index(0))*(alpha+1)/(energy_ch(index(0),0)^(1+alpha))
			  input_data(i).electron(j)=dens*(energy(j)^(1+alpha))/(1+alpha)  ;flux int
;			  input_data(i).electron(j)=-dens*(energy(j)^(alpha))  ; flux diff
;print,input_data_buf(i).electron(index(0)),input_data_buf(i).electron(index(0)-1)
;print,energy_ch(index(0),0),energy_ch(index(0)-1,0)
;print,energy(j),input_data(i).electron(j),dens*(energy(j)^(1+alpha))/(1+alpha) 
;r=get_kbrd(1)
			  endelse
		       endelse
		       endint:
	       endfor
;		    print,input_data(i).electron(3)
;		    r=get_kbrd(1)
;		    if input_data_buf(i).electron(0) ge 0. then r=get_kbrd(1)
	    endfor   

            input_header.tag1 = typeNames
            ; save the results into idl binary file
            fln = path_coh+'GPS_'+sat_id+'/bdd2/'+string(yer,format="(i4.4)")+'/data/'+res(0)
            print,fln+'.idl'
            ; save read data with correct time. Rename data to *.idl
            save,filename=fln+'.idl',input_header,input_data,/verbose  
            dealloc_lun,/quiet              ;frees logical units used by save/restore
       endwhile
       close,1
       free_lun,1
    endfor

    end
