;******************************************************************************
;* PROCEDURE:     
;*      p_lanl_gps_lspec, panel, type, OUTPUT=OUTPUT, $
;*           OVERPLOT=OVERPLOT,$
;*           PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           SUBTABLE=SUBTABLE, $
;*           _EXTRA=extra_par
;* 
;* MODIFICATION HISTORY:       
;*     written November 2001, Reiner Friedel, at LANL
;******************************************************************************
pro p_lanl_gps_lspec, panel, plotinfo, OUTPUT=OUTPUT, $
                     OVERPLOT=OVERPLOT, $
                     PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION, $
                     SUBTABLE=SUBTABLE, _EXTRA=extra_par

COMMON mjdt, mjdt_start, mjdt_end       ;common time limit in mjdt
COMMON yscale, yscl		        ;man/auto yscaling
COMMON zscale, zscl			;man/auto zscaling
COMMON shift_label, down                ;common for x-axis label shifting
COMMON coordinateSystems, plotted_x, plotted_y  
                                        ;info on coords used by mouse

COMMON lanl_gps_data, input_header, input_data
COMMON lanl_gps_singles_data, singles_header, singles_input_data
COMMON lanl_gps
COMMON slice_lanl_gps, control, time, data, yray, yarr, extra_plotPar, $
                       utitle, uytitle, uztit, tai_1
COMMON lanl_gps_otions, type, options, ioptions, soptions
COMMON papco_color_names  

IF keyword_set(OUTPUT) THEN output=OUTPUT ELSE output=0

;get control variables for this module
control = *plotinfo.USR_PTR1
sat_name = sat_id(control.sc_id)   ;GPS satellite name, string
nodata = -99.0 

; if singles are chosen, write the singles data into the input_data array  
if control.singles eq 1 then begin
    n=n_elements(singles_input_data)
    ;copy time, data
    input_data(0:n-1).TIME=  singles_input_data.time
    input_data(0:n-1).COUNTS(0)=singles_input_data.COUNTS(0)
    input_data(0:n-1).COUNTS(1)=singles_input_data.COUNTS(1)
    input_data=input_data(0:n-1)
endif  
  
utitle='LANL-GPS '+sat_name
uytitle='s!e-1'

; select correct channel names into energy_names
CASE 1 OF 
    ;earlier birds names handled by calibration routine. 
    (sat_name eq 'ns41'): energy_names=energy_names_41
    (sat_name eq 'ns54'): BEGIN
        CASE control.cal OF 
            3: BEGIN            ;fit channels
            END
            4: BEGIN            ;evaluate spectrum, M. Kippen's Fit 
                energy_names=strtrim(control.fit_ch,2)
                energy_names=(str_sep(strcompress(energy_names),' '))
            END 
            ELSE : energy_names=energy_names_54
        ENDCASE 
    END     
    ELSE: BEGIN &  END 
ENDCASE
  
if control.singles eq 1 then energy_names=singles_names_1
n_ch=n_elements(energy_names)
  
; restrict data to actual time range requested - this makes for faster zooming
; rememember input data is in TAI. For plotting, always start at zero
; to get maximum resolution (plot works in float only, large values
; get rounded! 
tai_1=utc2tai({mjd:mjdt_start.mjd, time:mjdt_start.t*1000})
tai_2=utc2tai({mjd:mjdt_end.mjd, time:mjdt_end.t*1000})
index=where((input_data.time ge tai_1) AND (input_data.time le tai_2),c)
if c ne 0 then data=input_data(index)
xut1=0  &  xut2=tai_2-tai_1  &  data.time=data.time-tai_1 & time=data.time
ndat = n_elements(data)  

;--- limit data by filter ranges if needed ------------------------------------
lanl_gps_select, control, data, nodata, utitle
      
;--- deadtime correction on counts --------------------------------------------
IF control.dead_time EQ 1 THEN BEGIN
    lanl_gps_deadtime_correction, data, sat_name & uytitle=uytitle+' (*)'
ENDIF

;--- do required calibrations -------------------------------------------------
lanl_gps_calib    ;seperate routine, also used by p_lanl_gps_lspec

;--- make index of channels to plot - from binary number in control.product ---
n_ch=n_elements(energy_names) & to_plot=bytarr(n_ch)
CASE 1 OF
    (control.cal EQ 4): BEGIN   ;calculate fit @ set MeV's required
        FOR i=0, n_ch-1 DO to_plot(i)=1
        pl_idx=where(to_plot EQ 1, nplot)
    END      
    (control.cal EQ 6) OR (control.cal EQ 7): BEGIN ;coherent channels
        FOR i=0, n_ch-1 DO to_plot(i)=1
        pl_idx=where(to_plot EQ 1, nplot)
    END 
    ELSE: BEGIN 
        FOR i=0,n_ch-1 DO IF (control.product and 2^i) EQ 2^i THEN to_plot(i)=1
        pl_idx=where(to_plot eq 1, nplot)
    END
ENDCASE

IF nplot eq 0 THEN GOTO, no_plot
   
pl_idx = pl_idx(0)

stack=0
   
;select the data required
yray=data.counts
case 1 OF
    (control.plot_style EQ 1):BEGIN
          yst=4 & yen=10
    END
    (control.plot_style EQ 2):BEGIN
          yst=4 & yen=10
    END
    (control.plot_style eq 4): begin ; psd/t  find psd at constant mu
        yray=data.counts
        lanl_gps_get_mu, data, yray, mu_psd, mu_values_str
        yray=mu_psd
        energy_names=mu_values_str
        n_ch=n_elements(energy_names)
        type(1)=0
        for i=0,n_ch-1 do type(1)=type(1)+2^i
        lanl_gps_scale, pl_idx, yray, yst, yen
        if control.plot_style eq 5 then begin
          yst=3.5  & yen=8
          data.counts(0)=transpose(yray(0,*))
        endif  
    end
    ELSE:
ENDCASE    

;now make the L-arrays to plot
time = data.time
y    = data.counts(pl_idx)
lbin = 0.05
model = 'none'
lanl_gps_make_Lvt, plotinfo, time, y, yst, yen, Y_arr, T_cut, Zarr, $
                   LBIN = LBIN, N_CUTS = N_CUTS, MODEL = model


; check if we need to do plot or just return data!.
if output EQ 4 then begin
    message,'data constructed',/cont  &  return
endif      

panelset,panel

;set z-scaling
if (zscl(panel(0),0) eq 1) then begin
    zst=zscl(panel(0),1)  &  zen=zscl(panel(0),2)
endif else BEGIN
    papco_autorange, Zarr, zst, zen, $
      log=zscl(panel(0),3), exclude=0, nodata = nodata
    zscl(panel(0),1)=zst  &  zscl(panel(0),2)=zen
endelse   

;set y-scaling - preset L range as 4 to 12
if (yscl(panel(0),0) eq 1) then begin
    yst=yscl(panel(0),1)  &   yen=yscl(panel(0),2)
endif else begin
    yst=4.0 & yen=10.0 
    yscl(panel(0),1)=yst  &  yscl(panel(0),2)=yen
endelse         

;set the required extra_plotPar keywords per type of plot.
case control.plot_style of
    1: BEGIN                    ;ch./L,t stk
        uztit=uytitle
        extra_plotPar={xrange:[xut1,xut2], yrange:[yst,yen], zrange:[zst,zen],$
                       ylog:0, zlog:zscl(panel(0),3), $
                       xtickformat:'noticks', $
                       ztickformat:'papco_color_bar_log_ticks', ztitle:uztit}
        utitle=utitle+'!C'+energy_names(pl_idx(0))+ ' MeV'    
    END 
    2: begin ;ch./L,t 3D
      xut1=0
      xut2=long(mjdt_end.mjd-mjdt_start.mjd)*86400l+mjdt_end.t-mjdt_start.t
      extra_axislabel=''
    end
    4: begin ;psd/L,t stk
        uztit='PSD'
        extra_plotPar={xrange:[xut1,xut2], yrange:[yst,yen], $
          ylog:0, zlog:1, zrange:[zst,zen], ztitle:uztit, $
          xtickformat:'noticks', ztickformat:'papco_color_bar_log_ticks'}
        utitle='LANL-GPS '+sat_name+'!C'+energy_names(0)+ ' MeV/nT, G:'+varprt(gain)
    end     
endcase   

; add keyword structure set here with the one passed in
extra_plotPar=create_struct(extra_plotPar, extra_par)
   
; check if we need to do plot or just return arrays to slice.
if output EQ 2 then begin
    message,'plot info constructed',/cont  &  return
endif       

papco_y_label, yst, yen, log=yscl(panel(0),3)  

; use papco rotuine to draw time axis. This checks for bottom plot
; and uses the user's  xtickformat if it is something other than 'noticks'.
down=0
papco_draw_time_axis, panel, OVERPLOT=OVERPLOT, _extra=extra_plotPar
   
; store the coordinate information into common block for slices
plotted_x = !x  &  plotted_y = !y

; now do the actual data plot, data only, no axis
CASE control.plot_style OF
    1: BEGIN                    ; L stack plot
        IF control.eqcor THEN utitle=utitle+'!CCorr. Equ.'
        
        ; do color plot and color bar plot. nodata specifies the "nodata" flag
        ; in your data. Here we do not plot axis and data seperate, as
        ; papco_plot_colorspec cannot be used as an overplot!
        resx = 1800 & resy = lbin
        n_ch = n_elements(Y_arr)/2
 
        IF yscl(panel(0),3) THEN resy=(alog10(yen)-alog10(yst))/n_ch ELSE $
            resy=((yen)-(yst))/n_ch

        papco_plot_colorspec, zarr, t_cut, y_arr, nodata=nodata, $
              resx=resx, resy=resy, $
              xstyle=5, ystyle=5, _extra=extra_plotPar
  
        ; store the coordinate information into common block
        plotted_x = !x  &  plotted_y = !y
 
        down=0
        papco_draw_time_axis, panel, OVERPLOT=OVERPLOT, _extra=extra_plotPar 
   
        papco_color_bar, _extra=extra_plotPar
 
        uytitle = 'L-val '+model
    END  
    2: begin
      i=2
      plots,time(0),(input_data(0).Lt89*(-1)),yray(i,0), /T3D
      for j=1, n_elements(input_data)-1 do begin
        plots,time(j),(input_data(j).Lt89*(-1)),yray(i,j), $
          color=extra_plotPar.color, /T3D, /continue 
      endfor  
     end  
    4: begin; psd/t psd at constant mu, L stack plot
      lanl_gps_l_stack_plot, 0, data, L_arr, t_cut, zarr, $
             COLSPEC=ioptions(4), _extra=extra_plotPar
      uytitle='L-value'
      utitle=utitle+'!CPAD s = '+string(options(12),format="(f3.1)")
    end

ENDCASE  
   
; plot y-axis label at left of plot. Use scalable routine!  
left_side_label,panel,uytitle,/rot90 
  
; plot info right of the panel. If you want overplots to have their own labels
; you need to add position-control for this label using the keyword
; PLOTS_ATTHISPOSITION

;3d plots can't be overplots,....
right_side_label,panel,utitle,/ROT90,_extra=extra_Par
      
; check if data needs to be output to file. Use the optional keywords
; to add more information to the data file
;      DESCRIPTION   a string or string array describing the data
;      TIME_LABEL    a string decribing the x-axis format
;      CHANNELS      an (ch,2) array giving the channel start/end
;      Y_LABEL       a string with the y-axis label
;      Z_LABEL       a string with the z-axis label
;      RS_LABEL      a string with the righ-side label of the plot
  
IF KEYWORD_SET(OUTPUT) then BEGIN
    time = t_cut+tai_1
    message,'Writing plot data out to file',/cont
    description='lanl_gps data'
    time_label='TAI'
    channels=y_arr 
    y_label=uytitle
    z_label=uztit
    rs_label=utitle
    nodata=-99
    papco_write_data, time, zarr, $
                      DESCRIPTION=description, TIME_LABEL=time_label, $
                      Y_LABEL=y_label, z_label=z_label, nodata=nodata, $
                      RS_LABEL=RS_LABEL,channels= channels
ENDIF   
      
return

no_plot:
message, 'nothing to plot!', /cont
plotted_x = !x  &  plotted_y = !y

END  

;------------------------------------------------------------------------------
; Make Time versus L array for data, splitting up per pass through rad
; belt. Have capability to choose the Model for L required!

PRO lanl_gps_make_Lvt, plotinfo, time, y, yst, yen, Y_arr, T_cut, Zarr, $
                       LBIN = LBIN, N_CUTS = N_CUTS, MODEL = MODEL, $
                       HAVE_EPH = HAVE_EPH
                       

COMMON mjdt, mjdt_start, mjdt_end       ;common time limit in mjdt
COMMON lanl_gps
COMMON gps_eph, gps_eph_sat_id, gps_eph_eph_names, gps_eph_select_names, $
                gps_eph_control
COMMON gps_eph_data, gps_eph_header, gps_eph_data

;based on request, get the L values needed!

IF keyword_set(HAVE_EPH) THEN have_eph = HAVE_EPH ELSE have_eph = 0

;get control variables for this module
control = *plotinfo.USR_PTR1
sat_name = sat_id(control.sc_id)   ;GPS satellite name, string

;set up control structure for lanl gps ephemeris module!
idx = where(sat_name EQ gps_eph_sat_id)
new_plotinfo = papco_getplotinfostruct()
new_plotinfo.USR_PTR1 = ptr_new(gps_eph_control)
new_control = *new_plotinfo.USR_PTR1
new_plotinfo.USR_PTR1 = ptr_new(gps_eph_control)
  new_control = *plotinfo.USR_PTR1
  new_control.sc_id = idx(0)
  new_control.product = 0 ;choose L, arbitrary here
  new_control.orig = 1 ;model coords
  new_control.internal_model = control.internal_model
  new_control.external_model = control.external_model
new_plotinfo.USR_PTR1 = ptr_new(new_control)

IF have_eph THEN GOTO, have_eph

r_gps_eph, new_plotinfo, VERBOSE=VERBOSE

;restrict eph data in time
tai_1=utc2tai({mjd:mjdt_start.mjd, time:mjdt_start.t*1000})
tai_2=utc2tai({mjd:mjdt_end.mjd, time:mjdt_end.t*1000})
index=where((gps_eph_data.time GE tai_1)AND(gps_eph_data.time LE tai_2),c)
IF c NE  0 THEN gps_eph_data=gps_eph_data(index) ELSE BEGIN
    message, 'No GPS EPH  data'
END

have_eph:

;make model struct name
IF new_control.mag_dyn THEN dyn_str = 'DYNA' ELSE dyn_str = 'STAT'
model_name = 'MODEL_'+varprt(control.INTERNAL_MODEL)+'_'+ $
                      varprt(control.EXTERNAL_MODEL)+'_'+dyn_str

tags=tag_names(gps_eph_data(0))
idx = where(model_name EQ tags, c)

CASE control.orig OF
    0: BEGIN                    ;original eph coords
        l = gps_eph_data.LT89
        model = 'LT89 orig'        
    END
    1:BEGIN                     ;model eph coords
        CASE control.filter OF 
            1: BEGIN   
                l = gps_eph_data.(idx(0)).lstar(0)
                model = model_name+' *'
                nodata =  -1.0e+31
            END    
            ELSE: BEGIN
                l = gps_eph_data.(idx(0)).l 
                model = model_name
                nodata = -1.0e+31
            END     
        ENDCASE 
    END
ENDCASE

idx=where(l EQ !VALUES.F_INFINITY,c) 
IF c NE 0 THEN l(idx) = nodata
idx=where(l LE 0,c) 
IF c NE 0 THEN l(idx) = nodata

;estimate number of L cuts
ndat = n_elements(time)
n_cuts=long((time(ndat-1)-time(0)) / 4000) ; one cut in 1/4 orb

papco_make_Lvt, time, y, l, yst, yen, Y_arr, T_cut, Zarr, $
                LBIN = LBIN, N_CUTS = N_CUTS, NODATA = nodata
  
;  if ioptions(11) then begin
    ;do correction for high latitude, using Michel Tuszewski's formula
;    message,'Correcting to equator',/cont
;    s=0.5
;    cor_fac= (L_arr/4.2)^(3.7*s)
;    for i=0, n_cut-1 do BEGIN
;      profile=zarr(i,*)
;      index=where(profile gt 0,c)
;      if c ne 0 then profile(index)=profile(index)*cor_fac(index)
;      zarr(i,*)=profile
;    endfor
;  endif
  
END 
