;******************************************************************************
;* PROCEDURE:     
;*      p_lanl_gps_line, panel, type, OUTPUT=OUTPUT, $
;*           OVERPLOT=OVERPLOT,$
;*           PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           SUBTABLE=SUBTABLE, $
;*           _EXTRA=extra_par
;* 
;* MODIFICATION HISTORY:       
;*     written December 1995, Reiner Friedel, at Goddard
;*     added OUTPUT support, July 1998, , Reiner Friedel
;******************************************************************************
pro p_lanl_gps_line, panel, plotinfo, OUTPUT=OUTPUT, $
                     OVERPLOT=OVERPLOT, $
                     PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION, $
                     SUBTABLE=SUBTABLE, _EXTRA=extra_par

  common mjdt, mjdt_start, mjdt_end     ;common time limit in mjdt
  common yscale, yscl		        ;man/auto yscaling
  common zscale, zscl			;man/auto zscaling
  common shift_label, down              ;common for x-axis label shifting
  common coordinateSystems, plotted_x, plotted_y  
                                        ;info on coords used by mouse

  common lanl_gps_data, input_header, input_data
  common lanl_gps_singles_data, singles_header, singles_input_data
  common lanl_gps
  common slice_lanl_gps_2, time, yray, extra_plotPar, utitle, uytitle, tai_1
  common lanl_gps_otions, type, options, ioptions, soptions
  common papco_color_names  
  
  type=plotinfo.typevector    &  options=plotinfo.options
  ioptions=plotinfo.ioptions  &  soptions=plotinfo.soptions
  if keyword_set(OUTPUT) then output=OUTPUT else output=0
  
; make some user friendly variables for the variables set in plotinfo.
  sat=input_header.sat_id       ;GPS satellite name, string
  style=plotinfo.typevector(2)  ;style of plot, line, spec, etc
  diag=plotinfo.ioptions(12)    ;diagnostics toggle
  
  panelset,panel
  
; if singles are chosen, write the singles data into the input_data array  
  ; need to fold ephemeris info into singles resolution
  if ioptions(6) eq 1 then begin
    n=n_elements(singles_input_data)
    for j=1,11 do begin ;fold eph data
      temp=interpol(input_data.(j),input_data.time,singles_input_data.time)
      input_data(0:n-1).(j)=temp
    endfor  
    ;copy time, data
    input_data(0:n-1).TIME=  singles_input_data.time
    input_data(0:n-1).COUNTS(0)=singles_input_data.COUNTS(0)
    input_data(0:n-1).COUNTS(1)=singles_input_data.COUNTS(1)
    input_data=input_data(0:n-1)
  endif  
  
; select correct channel names
  case 1 of 
    (sat eq 'ns08') or (sat eq 'ns10'): begin 
      case ioptions(8) of
        3: begin                ;fit channels
          energy_names=fit_energy_names_1 
        end
        4: begin                ;evaluate spectrum for n,T
          energy_names=strtrim(plotinfo.soptions(1),2)
          energy_names=(str_sep(strcompress(energy_names),' '))
        end
        else: begin
          energy_names=energy_names_1
        end
      endcase
    end
    (sat eq 'ns33'): begin
      if ioptions(8) eq 3 then energy_names=fit_energy_names_2 $
        else energy_names=energy_names_2
    end  
    (sat eq 'ns18') or (sat eq 'ns24') or (sat eq 'ns28') or (sat eq 'ns39'): $
      begin
      case ioptions(8) of
        0:energy_names=energy_names_2
        1:energy_names=energy_names_3
        2:energy_names=energy_names_3
        3:energy_names=energy_names_2
      endcase  
    end
    (sat eq 'ns41'): energy_names=energy_names_41
    (sat eq 'ns54'): energy_names=energy_names_54
  endcase  
  if ioptions(6) eq 1 then energy_names=singles_names_1
  n_ch=n_elements(energy_names)
  
; make index of channels to be plotted - from binary number in type(1) 
  to_plot=bytarr(n_ch)
  if ioptions(8) eq 4 then begin ;calculate fit
    for i=0,n_ch-1 do to_plot(i)=1
  endif else begin
    for i=0,n_ch-1 do if (type(1) and 2^i) eq 2^i then to_plot(i)=1
    plot_index=where(to_plot eq 1 ,nplot)
    if nplot eq 0 then begin
      message, 'nothing to plot!', /cont  &  return
    endif
  endelse

; restrict data to actual time range requested - this makes for faster zooming
; rememember input data is in TAI. For plotting, always start at zero
; to get maximum resolution (plot works in float only, large values
; get rounded! 
  convert_t90_to_Date, mjdt_start, year,doy,hr,min,sec,mon,cmon,doym, /mjdt 
  tai_1=UTC2TAI({YEAR:year, MONTH:mon, DAY:doym, HOUR:hr, MINUTE:min, $
                     SECOND:sec, MILLISECOND:0})
  convert_t90_to_Date, mjdt_end, year,doy,hr,min,sec,mon,cmon,doym, /mjdt 
  tai_2=UTC2TAI({YEAR:year, MONTH:mon, DAY:doym, HOUR:hr, MINUTE:min, $
                   SECOND:sec, MILLISECOND:0})
  
  utitle='LANL-GPS '+sat+'!CMeV, G:'+varprt(gain)
  uytitle='s!e-1'

; restrict data in time  
  index=where((input_data.time ge tai_1) AND (input_data.time le tai_2),c)
  if c ne 0 then data=input_data(index)
  xut1=0  &  xut2=tai_2-tai_1  &  data.time=data.time-tai_1 & time=data.time
  
; attempt to identify noise theshold on channels selected and mark with   
; "bad" data flag -99
if style ne 3 then begin       ;don't do if ephemeris plot is chosen
    if ioptions(8) lt 3 then begin ;don't do for FIT data
      if ioptions(5) then lanl_gps_intercal,type(1), data, n_ch
      lanl_gps_bad, to_plot, data, thresholds
      eph=0
    endif  
endif else eph=1   
  
; select L-range if that is selected
  if type(3) then begin
    lanl_gps_l_select, type(1), data, options(2), options(3), n_ch, EPH=eph
    l_label=string(options(2),options(3),format="(f4.1,' < L < ',f4.1)")
  endif
       
; select LT-range if is selected 
  if options(7) then begin
    lanl_gps_lt_select, type(1), data, options(5), options(6), n_ch, EPH=eph
    mlt_label=string(options(5),options(6),format="('LT ',f4.1,' to ',f4.1)")
  endif  
      
;see if we need to perform deadtime correction on counts   
  if ioptions(9) eq 1 then begin
    lanl_gps_deadtime_correction, data, sat
    uytitle=uytitle+' (*)'
  endif     
   
;see if we need to apply flux conversion 
  case ioptions(8) of ; calibration choice 
    0: uytitle='[cts] '+uytitle ;straight counts /channel
    1: begin                    ;integral bowtie
      uytitle='cm!e-2!nsr!e-1!n'+uytitle
      if style ne 3 then lanl_gps_flux_geom_fact, data, sat
    end
    2: begin                    ; differential bowtie
      uytitle='cm!e-2!nsr!e-1!nMeV!e-1!n'+uytitle
      if style ne 3 then lanl_gps_flux_geom_fact, data, sat, /DIFF
    end
    3: begin                    ;FIT parameters
      if nplot eq 1 then begin  ;only change name for Fit params
        if strtrim(energy_names(plot_index(0)),2) eq 'FIT Temp' then $
          uytitle='T (MeV)'
        if strtrim(energy_names(plot_index(0)),2) eq 'FIT Density' then $
          uytitle='n (cm!u-3!n)'
        if strtrim(energy_names(plot_index(0)),2) eq 'FIT Quality' then $
          uytitle='Q'
      endif else uytitle='[cts] '+uytitle
    end  
    4: begin                    ;evaluate FIT        
      T=data.counts(12)  &  n=data.counts(13)  &  ndat=n_elements(T)
      E=float(energy_names) 
      yray=fltarr(n_elements(E),ndat)
      message,'calculating spectrum (rel. maxwellian)',/cont
      for i=0, ndat-1 do begin
        spec=eval_rel_maxw(n(i), T(i), ENERGIES=E)
        data(i).counts(0:n_ch-1)=spec.J
      endfor
      uytitle='cm!e-2!nsr!e-1!nMeV!e-1!n'+uytitle
    end 
    else: uytitle=uytitle
  endcase  
   
  stack=0
   
  ;select the data required
  yray=data.counts
  case 1 of 
    (style eq 0) or (style eq 1) or (style eq 2): begin ;ch./t
      
    end
    (style eq 3): begin ;eph./t
      if strtrim(eph_names(ioptions(1)),2) eq 'MLAT' then begin
        yray=data.(3+1)  &  index=where(yray ne -99,c)
        if c ne 0 then yray(index)=atan(data(index).(4+1)/yray(index)) * !RADEG
      endif else yray=data.(ioptions(1)+1)
    end
    (style eq 4) or (style eq 5): begin ; psd/t  find psd at constant mu
      yray=data.counts
      lanl_gps_get_mu, data, yray, mu_psd, mu_values_str
      yray=mu_psd
      energy_names=mu_values_str
      n_ch=n_elements(energy_names)
      type(1)=0
      for i=0,n_ch-1 do type(1)=type(1)+2^i
      lanl_gps_scale, plot_index, yray, yst, yen
      if style eq 5 then begin
        yst=3.5  & yen=8
        data.counts(0)=transpose(yray(0,*))
      endif  
    end
    (style eq 6): begin         ;trapping boundary/t
      ;we have thresholds marked by -99: attempt to find trapping boundary
      lanl_gps_trapping_boundary, data, to_plot, nplot, trap_b, DIAG=diag
      index=where(trap_b.count lt 3, c)
      yray(index)=-99 ; not a valid boundary
      index=where(trap_b.count ge 3, c1);valid boundaries
      yray=trap_b.L_STEP(0)
      IF c1 NE 0 THEN BEGIN
          yray(index)=-99 ; not a valid boundary
          FOR i = 0, c1-1 DO BEGIN
              idx = index(i)
              index2 = where(trap_b(idx).L_STEP NE 0, c2)
              yray(idx) = total(trap_b(idx).L_STEP(index2))/c2
          ENDFOR
      ENDIF
      index3=where(yray eq 0,c3)
      if c3 ne 0 then yray(index3)=-99
      time=trap_b.time
    end  
  endcase   
  
  ;do y, z scaling
  if (zscl(panel(0),0) eq 1) then begin
    zst=zscl(panel(0),1)  &  zen=zscl(panel(0),2)
  endif else begin
    if (style eq 0) then begin ;ch./t
      lanl_gps_scale, plot_index, yray, yst, yen
      zst=yst  &   zen=yen
    endif
    if (style eq 1) or (style eq 2) then $
      lanl_gps_scale, plot_index, yray, zst, zen
    if (style eq 5) then $
      papco_autorange, yray, zst, zen, $
      log=zscl(panel(0),3), exclude=2, nodata=-99 
    if (style eq 6) then begin
      zst=0  &  zen=0
    endif
    zscl(panel(0),1)=zst  &  zscl(panel(0),2)=zen
  endelse   

  if (yscl(panel(0),0) eq 1) then begin
    yst=yscl(panel(0),1)  &   yen=yscl(panel(0),2)
  endif else begin
    if (style eq 1) or (style eq 2) or (style eq 5) or (style eq 6) then begin 
      yst=4 & yen=12 
    end
    yscl(panel(0),1)=yst  &  yscl(panel(0),2)=yen
  endelse         

  ;set the required extra_plotPar keywords per type of plot.
  case style of
    0: begin                    ;ch./t
      extra_plotPar={xrange:[xut1,xut2], yrange:[yst,yen], $
        ylog:yscl(panel(0),3), xtickformat:'noticks'} 
    end
    1: begin                    ;ch./L,t stk
       index=where(to_plot eq 1 ,n)
       lanl_gps_make_l_array, index(0), data, L_arr, t_cut, zarr, _EXTRA=E  
        time = t_cut & yray = zarr
      if not ioptions(4) then begin
        extra_plotPar={xrange:[xut1,xut2], yrange:[yst,yen], $
          ylog:0, xstyle:5, ystyle:5, zrange:[zst,zen], xtickformat:'noticks'}
        panelset,panel,AXIS=1
        stack=1
      endif else begin
        extra_plotPar={xrange:[xut1,xut2], yrange:[yst,yen], $
          ylog:0, zlog:1, zrange:[zst,zen], xtickformat:'noticks'}
      endelse 
    end
    2: begin ;ch./L,t 3D
      xut1=0
      xut2=long(mjdt_end.mjd-mjdt_start.mjd)*86400l+mjdt_end.t-mjdt_start.t
      extra_axislabel=''
      extra_tickf=['TAI_date_1','lanl_gps_lat_ticks', $
                   'lanl_gps_Lt89_ticks','lanl_gps_loct_ticks']  
    end
    3: begin ;eph./t
      eph_ytitle=['deg.','deg.','Re','','','deg.',$
                  'L-value','nT','hours','nT','nT','deg']
      utitle='LANL-GPS '+sat+'!C'+strtrim(eph_names(ioptions(1)),2)
      uytitle=eph_ytitle(ioptions(1))
      ylim4,time,yray,yst,yen, BAD_DATA=-99
      extra_plotPar={xrange:[xut1,xut2], yrange:[yst,yen], $
        ylog:yscl(panel(0),3), xtickformat:'noticks'}    
    end
    4: begin ;psd/t psd at constant mu
      extra_plotPar={xrange:[xut1,xut2], yrange:[yst,yen], $
        ylog:yscl(panel(0),3), xtickformat:'noticks'}     
      uytitle='PSD'
      s_str=string(options(12),format="(f3.1)")
      utitle='LANL-GPS '+sat+'!CMeV/nT, G:'+varprt(gain)
      utitle=utitle+'!CPAD s = '+s_str
    end
    5: begin ;psd/L,t stk
      extra_plotPar={xrange:[xut1,xut2], yrange:[yst,yen], $
        ylog:0, zlog:1, zrange:[zst,zen], ztitle:'PSD', $
        xtickformat:'noticks', ztickformat:'papco_color_bar_log_ticks'}
    end    
    6: begin                    ;trapping boundary
      extra_plotPar={xrange:[xut1,xut2], yrange:[yst,yen], $
                     ylog:0, xtickformat:'noticks'}
    end
  endcase   

; add keyword structure set here with the one passed in
  extra_plotPar=create_struct(extra_plotPar, extra_par)
     
; set extra x-axis labels if required   
   ;if ioptions(0) ne 0 then begin
   ;  x_axis_count=0
   ;  for i=1,11 do begin
   ;    if (ioptions(0) and 2^i) eq 2^i then begin
   ;      if x_axis_count eq 0 then begin
   ;        eph_axislabel=strtrim(eph_names(i),2)
   ;        eph_tickf='lanl_gps_'+strtrim(eph_names(i),2)+'_ticks' 
   ;        x_axis_count=x_axis_count+1
   ;      endif else begin  
   ;        eph_axislabel=eph_axislabel+'!C'+strtrim(eph_names(i),2)
   ;        eph_tickf=[eph_tickf,'lanl_gps_'+strtrim(eph_names(i),2)+'_ticks']
   ;        x_axis_count=x_axis_count+1
   ;      endelse  
   ;      print,'lanl_gps_'+strtrim(eph_names(i),2)+'_ticks'
   ;    endif
   ;  endfor  
  ;endif     
   
; add extra axis to preset axis if at bottom
  ;if (style eq 1) and not ioptions(4) then $
  ;   axislabel='counts exp' else axislabel=''
  ;if panel(0) eq 0 then begin
  ;   if n_elements(eph_axislabel) ne 0 then begin
  ;     extra_tickf=[normal_tickf,eph_tickf]
  ;     for i=0,n_elements(normal_axislabel)-1 do $
  ;       eph_axislabel='!C'+eph_axislabel
  ;     axislabel=[axislabel,normal_axislabel,eph_axislabel]
  ;   endif else begin
  ;     extra_tickf=normal_tickf
  ;     axislabel=normal_axislabel
  ;   endelse  
  ;   panelset,panel,AXIS=n_elements(extra_tickf)-$
  ;     n_elements(normal_axislabel) + stack
  ;endif else begin
  ;   if n_elements(eph_axislabel) ne 0 then begin
  ;     axislabel=[axislabel,eph_axislabel]
  ;     extra_tickf=eph_tickf
  ;   endif  
  ;   panelset,panel,AXIS=n_elements(extra_tickf)+stack
  ;endelse  

  color_indx=[red, green, blue, magenta, cyan, $
              burgundy, olive, dark_green, teal, royal_blue, violet]

; the variables used above have the following meaning:
; 	uytitle : the y-axis label
;	utitle  : the right-of plot label defining the data
;    
;    !P.CHARSIZE  = widgetData.default_charsize    
;    !P.CHARTHICK = widgetData.default_charthick
;    !P.FONT      = -1
;    !P.NOERASE   = 1
;    !P.TICKLEN   = widgetData.default_TICKLEN
;    !X.TICKS     = widgetData.default_XTICKS
;    !X.STYLE     = widgetData.default_XSTYLE
;    !Y.STYLE     = 1
;    !X.MINOR     = widgetData.default_XMINOR
   
; check if we need to do plot or just return arrays to slice.
  if output ge 2 then begin
    message,'plot data constructed',/cont  &  return
  endif       

; use papco rotuine to draw time axis. This checks for bottom plot
; and uses the user's  xtickformat if it is something other than 'noticks'.
  down=0
  papco_draw_time_axis, panel, OVERPLOT=OVERPLOT, _extra=extra_plotPar
   
; store the coordinate information into common block for slices
   plotted_x = !x  &  plotted_y = !y   
   
   uztit=''
; now do the actual data plot, data only, no axis
   case style of
    0: begin                   ;plot energy channel, multiples
      papco_y_label, yst, yen, log=yscl(panel(0),3)  
      ; check how many chanels to plot first
      n=0 & count=0
      index=where(to_plot eq 1 ,n)       
      if ioptions(4) eq 0 then begin
        if n eq 1 then $
          utitle='LANL-GPS '+sat+'!C'+energy_names(index(0))+' MeV'    
        for i=0,n_ch-1 do begin
          if (type(1) and 2^i) eq 2^i then begin
            if (n ne 1) then begin
              extra_plotPar.color=color_indx(i mod n_elements(color_indx))
              c=count/5 & mult=count mod 5 & name=energy_names(i)
              if count eq 0 then channels=[energy_names(i)] else $
                channels=[channels,energy_names(i)]
              if ioptions(10) then begin
                for j=1,c do name='!C'+name
                xyouts,!P.position(0)+0.01+0.135*mult,!P.position(3)-0.015,$
                  name, /normal,charsize=!p.charsize,color=extra_plotPar.color
              endif  
              count=count+1
            endif  
            index=where(yray(i,*) lt 0,c)
            if c ne 0 then yray(i,index)=-99
            
            lanl_gps_gap_plot, time,yray(i,*), AVERAGE=ioptions(2), $
              _extra=extra_plotPar
            
          endif
        endfor    
      endif else begin
        zmat=fltarr(n_elements(time),n)
        yarr=fltarr(n,2)
        ch=[0.2,0.4,0.8,1.6,3.2,4.5,5.9,9.0,15.0,25.0,50,100]
        for i=0,n-1 do begin
          zmat(*,i)=yray(index(i),*) 
          yarr(i,0)=ch(index(i)) & yarr(i,1)=ch(index(i)+1)
        endfor
        extra_plotPar=create_struct(extra_plotPar,'zrange',[zst,zen], $
                                    'zlog',1,'ztitle',uytitle, $
                                    'ztickformat','papco_color_bar_log_ticks')
        extra_plotPar.yrange=[yarr(0,0),yarr(n-1,1)]
        uytitle='Energy (MeV)'
        ; do spec plot
        resx=20  & resy=0.05    
        papco_plot_colorspec,zmat,time,yarr, nodata=-99, $
          resx=resx, resy=resy, _extra=extra_plotPar
        papco_color_bar, _extra=extra_plotPar    
      endelse  
      if n ne 1 then extra_Par.color=1
    end  
    1: begin ; L stack plot
       n=0 & count=0
       index=where(to_plot eq 1 ,n)
       if n eq 1 then  utitle='LANL-GPS '+sat+'!C'+energy_names(index(0))+ $
         ' MeV'    
       if ioptions(11) then utitle=utitle+'!CCorr. Equ.'
       for i=0,n-1 do begin
         if n ne 1 then begin
           extra_Par.color=color_indx(i mod n_elements(color_indx))
           c=count/5 & mult=count mod 5 & name=energy_names(i)
           for j=1,c do name='!C'+name
           xyouts,!P.position(0)+0.01+0.135*mult,!P.position(3)-0.015,name, $
                  /normal,charsize=!p.charsize,color=extra_Par.color
           count=count+1
         endif  
         uztit=uytitle
         extra_plotPar.color=extra_Par.color
         lanl_gps_l_stack_plot, index(i), data, L_arr, t_cut, zarr, $
           COLSPEC=ioptions(4), _extra=extra_plotPar
         uytitle='L-value' 
       endfor
       time=t_cut  &  yray=zarr  &  yarr=L_arr
       if n ne 1 then extra_Par.color=1       
    end  
    2: begin
      i=2
      plots,time(0),(input_data(0).Lt89*(-1)),yray(i,0), /T3D
      for j=1, n_elements(input_data)-1 do begin
        plots,time(j),(input_data(j).Lt89*(-1)),yray(i,j), $
          color=extra_plotPar.color, /T3D, /continue 
      endfor  
     end  
    3: begin                   ;plot ephemeris, single channel
      lanl_gps_gap_plot, time, yray, AVERAGE=ioptions(2), _extra=extra_Par
    end   
    4:  begin ; psd/t psd at constant mu, multiples
      papco_y_label, yst, yen, log=yscl(panel(0),3)  
      count=0
      if n_ch eq 1 then $
        utitle='LANL-GPS '+sat+'!C'+energy_names(index(0))+' MeV/nT'    
      for i=0,n_ch-1 do begin
        if (n_ch ne 1) then begin
          extra_Par.color=color_indx(i mod n_elements(color_indx))
          c=count/5 & mult=count mod 5 & name='mu='+energy_names(i)
          if count eq 0 then channels=['mu='+energy_names(i)] else $
            channels=[channels,'mu='+energy_names(i)]
          if ioptions(10) then begin ; label channels
            for j=1,c do name='!C'+name
            xyouts,!P.position(0)+0.01+0.135*mult,!P.position(3)-0.015,$
              name, /normal,charsize=!p.charsize,color=extra_Par.color
          endif  
          count=count+1
        endif  
        lanl_gps_gap_plot,time,yray(i,*),AVERAGE=ioptions(2),_extra=extra_Par
      endfor           
      if n_ch ne 1 then extra_Par.color=1
    end
    5: begin; psd/t psd at constant mu, L spectra
      lanl_gps_l_stack_plot, 0, data, L_arr, t_cut, zarr, $
             COLSPEC=ioptions(4), _extra=extra_plotPar
      uytitle='L-value'
      utitle='LANL-GPS '+sat+'!C'+energy_names(0)+ $
        ' MeV/nT, G:'+varprt(gain)
      utitle=utitle+'!CPAD s = '+string(options(12),format="(f3.1)")
    end
    6: begin                    ;trapping boundary
      uytitle='L-value'
      utitle='LANL-GPS '+sat+'!CTrapping Boundary'
      lanl_gps_gap_plot, time, yray, _extra=extra_plotPar      
    end
  endcase 
   
; plot y-axis label at left of plot. Use scalable routine!  
  left_side_label,panel,uytitle,/rot90       

; draw x-axis as needed   
  if not keyword_set(OVERPLOT) then begin
    for i=0, n_elements(extra_tickf)-1 do begin
      extra_plotPar.xtickformat=extra_tickf(i)
      extra_plotPar.color=1     
      plot,time,time, _extra=extra_plotPar, /NODATA
      down=i+1
    endfor  
  endif 
  if n_elements(axislabel) ne 0 then x_side_label,panel, axislabel
  
; plot info right of the panel. If you want overplots to have their own labels
; you need to add position-control for this label using the keyword
; PLOTS_ATTHISPOSITION
  if not ioptions(4) then begin ;if not a spec plot chosen
    if not keyword_set(overplot) then begin
      right_side_label,panel,utitle,_extra=extra_Par
    endif else begin
      for i=0, PLOTS_ATTHISPOSITION-1 do utitle='!C!C'+utitle
      right_side_label,panel,utitle,_extra=extra_Par
    endelse
  endif else begin
    right_side_label,panel,utitle,/ROT90,_extra=extra_Par
  endelse  
    
; here add right side labels at bottom of panel for L, MLT etc ranges
; if chosen.
  rst=''
  if (type(3) ne 0) and (not options(7)) then rst=l_label    ;L range chosen
  if options(7) and (not (type(3) ne 0)) then rst=mlt_label  ;mlt range chosen
  if (type(3) ne 0) and (options(7)) then rst=mlt_label+'!C'+l_label ;both chosen
  if keyword_set(overplot) then $
    for i=0,PLOTS_ATTHISPOSITION-1 do rst='!C!C'+rst
  right_side_label,panel, rst, POS=1,_extra=extra_Par
  
; check if data needs to be output to file. Use the optional keywords
; to add more information to the data file
;      DESCRIPTION   a string or string array describing the data
;      TIME_LABEL    a string decribing the x-axis format
;      CHANNELS      an (ch,2) array giving the channel start/end
;      Y_LABEL       a string with the y-axis label
;      Z_LABEL       a string with the z-axis label
;      RS_LABEL      a string with the righ-side label of the plot
  
  if KEYWORD_SET(OUTPUT) then BEGIN
    time = time+tai_1
    message,'Writing plot data out to file',/cont
    description='lanl_gps data'
    time_label='TAI'
    channels=channels  & n_ch=n_elements(channels)
    y_label=uytitle
    z_label=uztit
    rs_label=utitle
    nodata=-99
    case style of
      6:  yray = yray 
      ELSE:   yray = transpose(yray(0:n_ch-1,*))
    endcase
    papco_write_data, time, yray, $
                      DESCRIPTION=description, TIME_LABEL=time_label, $
                      Y_LABEL=y_label, z_label=z_label, nodata=nodata, $
                      RS_LABEL=RS_LABEL,channels= channels
  endif  
      
end 

