;******************************************************************************
;* PROCEDURE:     
;*      PRO lanl_mpa_set_commons
;* 
;* DESCRIPTION:  
;*      simply sets up a couple of often used arrays in common blocks.
;*
;* INPUTS:       
;*      none
;*                  
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      lanl_geo_set_commons
;******************************************************************************
PRO lanl_mpa_commons
  
COMMON lanl_mpa, sat_names, sat_codes,  select_names, select_frmts,dat_names, lanl_mpa_control
  
sat_names = ['1989-046','1990-095','1991-080','1994-084', $
             'lanl-97a','lanl-01a','lanl-02a']

;enter variables for filtering the data
select_names = ['L', 'L_STAR', 'MLT', 'MLAT']
select_frmts = ['(f4.1)', '(f4.1)', '(f4.1)', '(f5.1)']

sat_codes = ['l9', 'l0', 'l1', 'l4', 'l7', 'a1', 'a2']

dat_names = ['Av. Electron Flux', $
                 'Av. Ion Flux', $
                 'Background', $
                 'S/C Potential', $
                 'S/C X Coord.', $
                 'S/C Y Coord.', $
                 'S/C Z Coord.', $
;                 'DIMAGLAT', $
                 'S/C Mag. Lat.', $
                 'S/C Mag. LT', $
;                 'SPIN_RATE', $
;                 'BARR', $
;                 'ECE4', $
;                 'ECP4', $
;                 'E4SAV', $
;                 'G4SAV', $               
                 'Density LP', $
                 'Velocity LP', $
;                 'TLP', $
;                 'TTHETALP', $
;                 'TPHILP', $
                 'Density HP', $
;                 'VELHP', $
;                 'THP', $
;                 'TTHETAHP', $
;                 'TPHIHP', $
                 'T-Par. HP', $
                 'T-Perp. HP', $
                 'Theta HP', $
                 'Phi HP', $
                 'Density HE', $
;                 'VELHE', $
;                 'THE', $
;                 'TTHETAHE', $
;                 'TPHIHE', $
                 'T-Par. HE', $
                 'T-Perp. HE', $
                 'Theta HE', $
                 'Phi HE', $
                 'Pressure HP']
lanl_mpa_control = { $
  sc_id:0,  sc_id_info:'Index into sat_names, Geo Satellite ID', $
;; line plot options
  data_ch:0,  data_ch_info:'0: Av.Electron Flux, 1: Av. Ion Flux, 2: Background,'+ $
  '3: S/C Potential, 4: S/C X Coord., 5: S/C Y Coord., 6: S/C Z Coord., 7: S/C Mag. Lat.,'+ $
  '8: S/C Mag. LT, 9: Density, 10: Velocity LP, 11: Density HP, 12: T-Par. HP,'+$
  '13: T-Perp. HP, Theta HP, 14: Phi HP, 15: Density HE, 16: T-Par. HE, 17: T-Perp. HE,'+ $
  '18: Theta HE, 19: Theta HE, Phi HE, 20: Pressure HP', $
  channel:0.0,  channel_info:'Channel Number', $
;; spectral plot options
  species:0, species_info:'0: Electrons, 1: Protons', $
  plot_pot:0, plot_pot_info:'0: No, 1: Yes', $
  data_type:0, data_type_info:'0: Energy Flux, 1: Differential Flux, 2: Phase Space Density', $
;; lt plot options
  sc_id_2:0,  sc_id_2_info:'0: 1989-046, 1: 1990-095, 2: 1991-080, 3: 1994-084, 4: LANL-97a', $
  dir:'papco_products/mpa_event_times/', dir_info:'Directory:', $
  fnam:'', fnam_info:'Filename:', $
  Stat:'No File entered', stat_info:'', $
  
;; pitch angle plot options
  pl_type:0,   pl_type_info:' 0: All PA @ 1 E, 1: All E @ 1 PA,'+ $ 
                          '2: All PA for E range, 3: All E for PA range,'+ $
                          '4: Anisotropy spec.., 5: PA range @ E range,'+ $
                          '6: Anisotropy LP, 7: Magnetic Field', $
  pa_res:'5',  pa_res_info:'PA bin size (deg)', $  ;pitch angle resolution
  mf_comp:0,   mf_comp_info:' 0: Elevation angle, 1: Phi', $ ;magnetic field component
  pa_bin1:0.0, pa1_info:'PITCH ANGLE BIN start',$
  pa_bin2:0.0, pa2_info:'PITCH ANGLE BIN stop',$
  ek1:1ll,     ek1_info:'Energy channel 1', $
  ek2:1ll,     ek2_info:'Energy channel 2', $ 
  rem_ph:0.,   rem_ph_info:'0: No, 1: Yes, whether you want to filter out photo electrons', $
  mag_corr:0., mag_corr_info:'Interpolation between obviously wrong mag dir values', $
  filter:0.,   filter_info:'Index into select_names filter variable to use' $
} 

;now get the papco_panel tags for the papco_panel_Add_MagMod_Widgets
;tags, add them to lanl_gps_control
lanl_mpa_control = CREATE_STRUCT(lanl_mpa_control, $
                       papco_panel_Add_MagMod_Widgets(/STRUCT_ONLY))

;now get the papco panel tags for the various select variables.
FOR i = 0, n_elements(select_names)-1 DO $
  lanl_mpa_control = CREATE_STRUCT(lanl_mpa_control, $
                 papco_panel_AddVar_Sel_Widgets(aBase, select_names(i), $
                                                select, st, en, v1, v2, vr, $
                                                select_frmts(i), /STRUCT_ONLY))
;finally name the control structure. This is required for load/save operations!
lanl_mpa_control = CREATE_STRUCT(name = 'lanl_mpa_control', lanl_mpa_control)

END
