;******************************************************************************
;* FUNCTION:     
;*      FUNCTION  MPA_errcalc, yarr, type
;* 
;* DESCRIPTION:  
;*	Calculate the statistical error of the data point for fit operations.
;*
;* INPUTS:       
;*      yarr            Array of the data values.
;*      type            Type of data category: Electron=0, Ions=1
;*
;* KEYWORDS:
;*      NONE
;*
;* OUTPUT:	 
;*      The statistical sigmas for the differential flux is returned by
;*      this function.
;*
;* CALLING SEQUENCE:
;*      error=MPA_errcalc(yarr,type)
;*
;* MODIFICATION HISTORY:       
;*     September 1998, written by Haje Korth
;******************************************************************************
FUNCTION MPA_errcalc, yarr, type

   corarr_1989046_e=[-1.00000000000000000000,       14.63052738625110471560,       18.05857350044575326820,$
       22.35874331857056418471,       27.75999183391991920189,       34.55249353494504305218,$
       43.27573790751320359504,       54.22693339565682890679,       67.70356890261346904936,$
       84.90673070549351564296,      106.19733506471550299466,      133.13010928027387080874,$
      167.54930929554095087042,      211.23486943337820775923,      267.86064082604639224883,$
      352.57248150174109468935,      465.78749841626603256373,      615.63701245462880251580,$
      818.78484543554532137932,     1097.98372320589351147646,     1481.87618953006222000113,$
     2011.72235015469800600840,     2712.17279515861991967540,     3623.06027161544534465065,$
     4671.84850652354634803487,     6026.12559509384664124809,     8089.14802009294180606958,$
    10901.49565711960349290166,    14193.97951757757255109027,    18251.64697803994567948394,$
    24168.19827074724889826030,    32536.11143722770066233352,    44810.65887516077054897323,$
    62762.48034644738072529435,    89991.01258647447684779763,   130106.73679978513973765075,$
   185850.15547489249729551375,   266537.57507588202133774757,   380549.42310120072215795517,$
   540920.60097235534340143204]

   corarr_1989046_i=[-1.00000000000000000000,        8.79583641949400174553,       11.77459703509848765179,$
       15.71333182132129202557,       20.90986690565151562282,       27.75057995816176870107,$
       36.73832735650897518553,       48.31447391287334625076,       63.60902796316076290850,$
       83.88988512791659957202,      110.40224557721872145066,      144.91332619044928264884,$
      190.16189777895505130800,      249.92804862895513906551,      328.15411015492639990043,$
      426.96703931015031230345,      549.75462941849048092990,      715.67199562744804097747,$
      938.40796768510801939556,     1226.88919399755127415119,     1604.25536966330855648266,$
     2093.40146180181181989610,     2715.19703985796741108061,     3505.24664346555300653563,$
     4520.09798461949230841128,     5821.81672348652591608698,     7487.96472745541268523084,$
     9573.52612650281298556365,    12173.54942124265653546900,    15416.17104505299721495248,$
    19435.17914368736455799080,    24271.16278966567915631458,    30043.24943224819435272366,$
    37339.01841378656536107883,    46294.64385049311385955662,    56608.30329081343370489776,$
    68698.19283898452704306692,    82192.01250010357762221247,    97368.03255557165539357811,$
   116190.40009411257051397115]

   corarr_1990095_e=[10.64636076653571983286,       13.14564769141149547238,       16.29246675133423138959,$
       20.26004471029797926462,       25.26924855767667565942,       31.60042722204372722672,$
       39.61324379294045883171,       49.76768573762128511362,       62.86153228069400000777,$
       79.66619785713686496820,      100.68546843363873222188,      127.19414282321490361483,$
      160.35830739282161516712,      202.03419045310445767427,      255.69601969482420145141,$
      339.04264763871583454602,      449.25644010112296200532,      597.67822762097455324692,$
      804.11664375501038648508,     1086.58221384123976349656,     1473.10728995738554658601,$
     2007.36260372795027251414,     2722.56711834878524314263,     3648.81169549005926455720,$
     4899.21399401988219324267,     6563.22450763997585454490,     8748.63721304027421865612,$
    11736.68208608301392814610,    15751.91496559454571979586,    21541.49301116372225806117,$
    29718.87742996677116025239,    39612.32266256993170827627,    52390.01446140348707558587,$
    68879.89252307437709532678,    86626.75985681862221099436,   106748.18205735282390378416,$
   125270.96994537302816752344,   144906.61698956385953351855,   170787.28979393010376952589,$
   197142.05762936882092617452]

   corarr_1990095_i=[6.16013730108644086414,        8.28885951972305790036,       11.11557000795010274885,$
       14.85973359080023925571,       19.80787202889901976732,       26.33198362624517230302,$
       34.91771896582454814961,       46.19860952210347448954,       60.99710158918068714229,$
       80.38459448034345200540,      105.75372430925945366198,      138.91592941940348282515,$
      182.22732513168568857509,      237.66048844267024264809,      310.19551448361977463719,$
      406.15099902410241838879,      532.72427362142241236143,      700.23110185104133051937,$
      914.99004535024403139687,     1193.36133200477365789993,     1561.80177130777587990451,$
     2041.66248267603737076570,     2652.33014969563873819425,     3430.61859972553156694630,$
     4405.94870031263599230442,     5642.74977045492141769500,     7227.29271890751260798424,$
     9212.55147007472623954527,    11721.90693199179077055305,    14798.48215731680284079630,$
    18369.39999563080709776841,    22437.88037223072751658037,    27298.42958312064001802355,$
    32959.04992681736621307209,    39310.85482614598004147410,    46049.19561645481735467911,$
    53036.01056596189300762489,    62950.78846621511183911934,    74150.65394234821724239737,$
    85634.79592831988702528179]

   corarr_1991080_e=[-1.00000000000000000000,       -1.00000000000000000000,       15.69573002841302056254,$
       19.45565239675057611635,       24.18495333630903587618,       30.14201034297147785423,$
       37.65458501812928204799,       47.13928841187887286424,       59.12772632231975933337,$
       74.35506249142386536732,       93.53192920027289858353,      117.73944574101663818055,$
      148.51000984800288051702,      187.33472055135547407190,      236.93622041833785374365,$
      312.95462061006082876702,      416.01520922357639165057,      549.57174003831801201159,$
      731.86873267572752865817,      981.77659829840422389680,     1318.55023856393654568819,$
     1778.53743949723502737470,     2393.36900669923898021807,     3187.53385908466589171439,$
     4230.04952059859715518542,     5589.08274392893054027809,     7627.45241815373174176784,$
    10465.43077642951175221242,    13807.94981840317996102385,    17164.31028680653980700299,$
    20307.28596586252751876600,    25700.34214335144861252047,    34394.68635422225634101778,$
    45961.96791204770124750212,    63330.55405034564319066703,    88978.60774765684618614614,$
   126166.41782537939434405416,   205277.39433701481902971864,   408810.32475472171790897846,$
   834513.99948562565259635448]

   corarr_1991080_i=[5.11840214604009258181,        6.91686132269737807832,        9.31461975034779143812,$
       12.50224521299264957008,       16.72964190501281578349,       22.32279408439380929963,$
       29.70764628202557844361,       39.44161953672753639921,       52.83299302339245429039,$
       70.43619032545478830798,       92.58575390090734913429,      121.69900617264379150129,$
      160.30175729175482501887,      205.40910827574091968017,      263.74634088357049677143,$
      349.04162005077591857116,      459.33922495659373907984,      604.71086996252768130944,$
      793.35864189113215161342,     1042.83905135343889014621,     1371.72903844906386439106,$
     1793.12070872806452825898,     2362.81591003598077804781,     3099.20916499744134853245,$
     4061.54386221845697946264,     5400.21387730947117233882,     7194.70501676360618148465,$
     9644.50824949786510842387,    13173.04818700088799232617,    18523.66257814962227712385,$
    26560.74712287158399703912,    38628.28734502945007989183,    57234.77473396302229957655,$
    93214.01754095866635907441,   188751.08557174354791641235,   398759.13123151136096566916,$
   790411.79823950631543993950,  1600437.98278464423492550850,  3275068.54253977863118052483,$
  6632439.03126131650060415268]

   corarr_1994084_e=[9.55829363287806188509,       11.80178176263563116777,       14.62624144013005889065,$
       18.18667817803990871539,       22.68093424499113197612,       28.36087377814957122268,$
       35.54771533440845843188,       44.65393521714281632740,       56.28611189263319403153,$
       71.00224714386177993219,       77.97594611362684702272,       98.41768834801892751329,$
      142.99727788104090109300,      180.92414243896160996883,      230.42466132578792326058,$
      307.30853753324646504552,      408.38453643580555763037,      543.49414792055642919877,$
      727.91820102162193961703,      986.97135455469049247768,     1330.87913779706559580518,$
     1786.53674080591122219630,     2382.73736427848825769615,     3170.15290434875441860640,$
     4244.21750469399194116704,     5664.80386527505106641911,     7541.00245629890923737548,$
    10009.03545208282957901247,    13085.38950269441738782916,    17199.71073972413432784379,$
    21711.98258339702806551941,    26773.66517049451431375928,    34462.80488916688773315400,$
    44512.47607094934937776998,    55425.73133619777217973024,    65524.20616689168673474342,$
    83749.07678839059371966869,   110185.35980640174238942564,   135033.30575368320569396019,$
   165277.77802180885919369757]

   corarr_1994084_i=[4.85223307602070086375,        6.59553896865196698229,        8.93252208357016108664,$
       12.05627834844285217741,       16.22139679157421099376,       21.76193208651358190764,$
       29.11640063257802779617,       38.86054866134495711094,       51.84960898572104781579,$
       69.03638114724923013910,       91.34188960801797918521,      120.54867741422400229112,$
      159.53842440869331653630,      210.25692298764866450256,      277.25470734259766913965,$
      367.39696436562729786601,      483.25569069435698565940,      634.53932711214281425782,$
      838.58879421651840857521,     1104.76725258974693133496,     1448.31304458299200632609,$
     1891.10551205698538979050,     2482.13641441833624412538,     3254.80979018858170093154,$
     4224.91676249861757241888,     5495.69912298613235179801,     7124.60995579588143300498,$
     9097.22130614596244413406,    11589.73240829882706748322,    14935.66211203998136625160,$
    19252.28713530745517346077,    23614.29067992882846738212,    29077.28868665496338508092,$
    38070.51378059248236240819,    49612.27910924610478105024,    61912.71981868515285896137,$
    74663.76763943968398962170,    97600.29110801505157724023,   156854.53231016558129340410,$
   284058.51762155164033174515]

   corarr_lanl97a_e=[9.58175279898606291340,       11.81476073574997975868,       14.62214475895854981502,$
       18.15582382271334793700,       22.60996489789469876541,       28.23144568546051047520,$
       35.33457069393482896658,       44.32090654681636721079,       55.70308529799751084965,$
       70.40331970821394236282,       88.52102960692742783522,      110.99339260521820449412,$
      140.51370434042260626484,      178.85099714630246126035,      228.13420314290132751012,$
      302.31827598153012104376,      397.94854093668971017905,      526.77101820997461345542,$
      706.33799469087045963533,      945.12464178021878069558,     1265.34010122833751665894,$
     1697.81790216727517872641,     2253.35291194006777004688,     2971.02318635459641882335,$
     3977.92371911767986603081,     5211.23293770008513092762,     6728.66343276505631365580,$
     8705.53185855718038510531,    11415.06799626685642579105,    15486.05536843642221356276,$
    19665.01443150897830491886,    23300.98504281605346477591,    29969.11519991641398519278,$
    43566.92402857791603310034,    61203.81731605318782385439,    83519.00955571778467856348,$
   116185.79216818451823201030,   142647.30028782421140931547,   202396.32593037182232365012,$
   276406.89393900649156421423]

   corarr_lanl97a_i=[5.16448322398096859587,        6.99763370256595518271,        9.44781133456815602756,$
       12.71348833392876542803,       17.05588421632006301820,       22.81696420550284543083,$
       30.44352369794457047192,       40.52247058346458885580,       53.90764227449735557229,$
       71.48936492212494897558,       94.69285841682128079810,      124.57138057946717424329,$
      163.59792199475592155977,      215.85094390127829910853,      285.03792882330208158237,$
      376.29908544817789106673,      493.28708473989894400802,      646.71890654246317353682,$
      850.17696330308308461099,     1112.74244558862665144261,     1448.41996003071039922361,$
     1884.35232595950492395787,     2439.23749857077382330317,     3142.51413161168011356494,$
     4040.19560551994391062181,     5190.33752144083791790763,     6661.32248846272523223888,$
     8339.06582281051669269800,    10465.63326070061521022581,    13190.36013612992428534199,$
    16367.71293485871683515143,    20468.20608365050793508999,    26113.58096485687565291300,$
    34401.63749644936615368351,    46412.62764162850362481549,    62088.93282028147223172709,$
    81528.81490892285364679992,   107151.90615918822004459798,   136009.20098188781412318349,$
   173607.70041027176193892956]

   CASE type(0) OF
     0:IF type(1) EQ 0 THEN corarr=corarr_1989046_e ELSE corarr=corarr_1989046_i
     1:IF type(1) EQ 0 THEN corarr=corarr_1990095_e ELSE corarr=corarr_1990095_i
     2:IF type(1) EQ 0 THEN corarr=corarr_1991080_e ELSE corarr=corarr_1991080_i
     3:IF type(1) EQ 0 THEN corarr=corarr_1994084_e ELSE corarr=corarr_1994084_i
     4:IF type(1) EQ 0 THEN corarr=corarr_lanl97a_e ELSE corarr=corarr_lanl97a_i
     5:IF type(1) EQ 0 THEN corarr=corarr_lanl97a_e ELSE corarr=corarr_lanl97a_i
     6:IF type(1) EQ 0 THEN corarr=corarr_lanl97a_e ELSE corarr=corarr_lanl97a_i
   ENDCASE

   corarr=REVERSE(corarr)

   sigmaj=SQRT(yarr*corarr)

   RETURN,sigmaj

END
