;******************************************************************************
;* PROCEDURE:     
;*      PRO  mpa_fit
;* 
;* DESCRIPTION:  
;*	This procedure performs a fit on the phase space density values
;*      displayed by the mpa_userslice routines.
;*
;* INPUTS:       
;*      Taken from various common blocks.
;*
;* KEYWORDS:
;*      NONE
;*
;* OUTPUT:	 
;*      Plots the fit function and stores the fit data for further use.
;*
;* CALLING SEQUENCE:
;*      mpa_fit
;*
;* MODIFICATION HISTORY:       
;*     September 1998, written by Haje Korth
;*
;******************************************************************************
PRO mpa_fit

   COMMON MPA_USERSLICEDATA, slicePlotData, extra_plotPar, extra_axisPar, fitPlotPar
   COMMON PLOT_COMPOSER, widgetData
   COMMON MPA_DRAWSLICE, sliceWidgetData
   COMMON papco_color_names, black, red, green, yellow, blue, magenta, cyan, $
                             white, burgundy, olive, dark_green, teal, $
                             royal_blue, violet, dark_grey, grey, $
                             foreground, background

   numslice=slicePlotData.numslice-1
   fitx=slicePlotData.slicearr(5*numslice-5,*)
   fity=slicePlotData.slicearr(5*numslice-4,*)
   sigmaf=slicePlotData.slicearr(5*numslice-3,*)

   index=WHERE((fitx GE slicePlotData.fitstart) AND $
               (fitx LE slicePlotData.fitstop),count)
   IF (count NE 0) THEN BEGIN
     fitx=fitx(index)
     fity=fity(index)
     sigmaf=sigmaf(index)
   ENDIF ELSE RETURN

   index=WHERE(fitx NE -1,count)
   IF (count NE 0) THEN BEGIN
     fitx=fitx(index)
     fity=fity(index)
     sigmaf=sigmaf(index)
   ENDIF ELSE RETURN

   CASE slicePlotData.fitType OF
     'maxwell': BEGIN
        retval = FitTempMaxw(fitx, fity, 0., chi2=chi2, den=den, $
                             weight=(1d0/sigmaf^2), temp=temp, $
                             line=yfit, xline=xfit, sigma=sig, prob=prob, $
                             error=0)
     END

     'kappa': BEGIN
        retval = FitTempMaxw(fitx, fity, 0., chi2=chi2, den=den, $
                             weight=(1d0/sigmaf^2), temp=temp, $
                             line=yfit, xline=xfit, sigma=sig, prob=prob, $
                             error=0)
        IF (retval EQ 1) THEN BEGIN
          iguess=[den,temp,2.5]
          retval = FitTempKappa(fitx, fity, 0., $
                                weight=1d0/sigmaf^2,iguess=iguess, $
                                kappa=kappa, den=den, temp=temp, sig=sig, $
                                line=fit2, xline=xfit, chi2=chi2, /maxw_guess, $
                                prob=prob, errors=0)
        ENDIF
     END
   ENDCASE

   slicePlotData.fitsuccess=retval
   IF (retval EQ 1) THEN BEGIN
     index=WHERE((yfit GE slicePlotData.ystart) AND (yfit LE slicePlotData.ystop),num)
     xfit=xfit(index)
     yfit=yfit(index)

     count=N_ELEMENTS(xfit)
     slicePlotData.slicearr(5*numslice-2,0:count-1)=xfit
     slicePlotData.slicearr(5*numslice-1,0:count-1)=yfit
     slicePlotData.fitx=xfit
     slicePlotData.fity=yfit

     slicePlotData.fitden(0)=den
     slicePlotData.fitden(1)=sig(0)
     slicePlotData.fittemp(0)=temp
     slicePlotData.fittemp(1)=sig(1)
     slicePlotData.fitchi2=chi2
     slicePlotData.fitprob=prob
     IF (slicePlotData.fitType EQ 'kappa') THEN BEGIN
       slicePlotData.fitkappa(0)=kappa
       slicePlotData.fitkappa(1)=sig(2)
     ENDIF ELSE BEGIN
       slicePlotData.fitkappa(0)=!values.f_infinity
       slicePlotData.fitkappa(1)=-1
     ENDELSE

     colorarr=[black,red,blue,dark_green,yellow]
     labcol=colorarr(slicePlotData.labcol-1)
     WIDGET_CONTROL, sliceWidgetData.dw_slice, GET_VALUE=drawIndex
     WSET, drawIndex
     OPLOT,xfit,yfit,color=labcol
   ENDIF

END
