;******************************************************************************
;* PROCEDURE:     
;*      PRO  mpa_strike
;* 
;* DESCRIPTION:  
;*	After use of the 'previous' and 'next' buttons of the mpa_userslice
;*      routine the cursor position in the main draw window is updated by
;*      this routine.
;*
;* INPUTS:       
;*      seconds         The new seconds value where the cursor need to be
;*                      moved to.
;*
;* KEYWORDS:
;*      NONE
;*
;* OUTPUT:	 
;*      NONE
;*
;* CALLING SEQUENCE:
;*      mpa_strike, seconds
;*
;* MODIFICATION HISTORY:       
;*     September 1998, written by Haje Korth
;*
;******************************************************************************
pro mpa_strike, seconds

   COMMON MPA_USERSLICEDATA, slicePlotData, extra_plotPar, extra_axisPar, fitPlotPar
   common plot_composer, widgetData
   common mjdt, mjdt_start, mjdt_end
 
   xut1=mjdt_start.t                       
   xut2=long(mjdt_end.mjd-mjdt_start.mjd)*86400l+mjdt_end.t

   panelNr=slicePlotData.panelNr
   thisPlot=widgetData.plotsDrawn(panelNr)
   xrange= [ xut1, xut2 ] ; assumes xut1, xut2 have not been reset    
   xnormal= thisplot.NORMAL_XRANGE
   
   xnorm=( seconds    - xrange(0) ) / $
         ( xrange(1)  - xrange(0) ) * $
         ( xnormal(1) - xnormal(0) ) + $
         xnormal(0)
   papco_Cursor_ShowSelection, panelNr, 0, 0, xnorm, 0

   return
end
