PRO flux,infile,outfile

COMMON lanl_mpa_data,  inpput_header,  input_data,  input_sat

!quiet=1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; GET DATA from the CDF file ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


print,infile
data = readcdf(infile)

   ie = 40    ; total energy channels
   ip = 6     ; total polar channels
   is = 24    ; total spin channels

; number of array
   ileng = n_elements(data.Epoch.data)

;******************************************************************
;  To calculate the ion flux from the count rate
;******************************************************************
; C/t = e1 * e2 * G * E *j
; where E is energy (eV), j is number flux (cm^-2 s^-1 sr^-1 eV^-1)
;    and t = 9ms
; j ~ C/(t*e1*e2*G*E)
; j = C/(9e-3s*e1*e2*G*E)
;******************************************************************
   close,3
; please change the output directory and the output file name
   diro = '~aasnes/'
   openw,3,diro+'mpa_pitch.test'
   printf,3,'UT (hour)     ion flux (4x24)     alpha(4x24)'
   printf,3,'              40 keV, 20 keV, 1 keV, 100 eV'
   printf,3,'              Channel 1, Channel 3, Channel 5, Channel 9'

   r2d = !pi/180.
   n = 2 ; polar channel 3
   iep = [0, 2, 4, 8] ; 40keV, 20keV, 1keV, 100eV
   theta3 = 0.5*(data.theta_l.data(n)+data.theta_u.data(n))*r2d
   fa = fltarr(4, is)
   alpha = fltarr(4, is)
   for i = 0 , ileng -1 do begin
     for j = 0, is-1 do begin
       j1 = j+12
       if j1 gt is-1 then j1 = j1-is
       for k = 0, 3 do begin
        if data.ece.data(iep(k)) ne -1.0 then BEGIN ;ece is center energy of channel
         factor = 1./9e-3/data.effece.data(iep(k))/data.ece.data(iep(k))
         fa(k,j) = 0.5*factor*(data.Ecounts.data(i,iep(k),n,j)/$
            data.etimesg.data(n) + data.Ecounts.data(i,iep(k),n+1,j1)/$
            data.etimesg.data(n+1))
         If data.temp_e.data(i,0) eq -1e31 then begin
          alpha(k,j) = -1e31
         ENDIF else begin
           if data.temp_e.data(i,1) eq 0. then begin
             thetaB = data.theta_phi_hip.data(i,0)*r2d
             phiB = data.theta_phi_hip.data(i,1)*r2d
           endif else begin
             if data.temp_e.data(i,0)/data.temp_e.data(i,1) ge $
                data.temp_hip.data(i,0)/data.temp_hip.data(i,1) then begin
               thetaB = data.theta_phi_e.data(i,0)*r2d
               phiB = data.theta_phi_e.data(i,1)*r2d
             endif else begin
               thetaB = data.theta_phi_hip.data(i,0)*r2d
               phiB = data.theta_phi_hip.data(i,1)*r2d
             endelse
           endelse
           phij = data.Azanglp.data(i,iep(k),j)*r2d
           cosalpha = sin(theta3)*cos(phij)*sin(thetaB)*cos(phiB) + $
                      sin(theta3)*sin(phij)*sin(thetaB)*sin(phiB) + $
                      cos(theta3)*cos(thetaB)
           alpha(k,j) = acos(cosalpha)/r2d
         ENDELSE
        endif else begin
         fa(k,j) = -1e31
         alpha(k,j) = -1e31
        endelse
       endfor
     endfor
   printf,3,data.uthours.data(i)
   printf,3,fa,alpha
   endfor
   close,3
stop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;* WHAT"S IN THE DATA STRUCTURE????????????????????????????
;;* 
;;* ece/ecp:         center energy of detector channel
;;* effece/effecp:   energy depend eff.elec/ion values
;;* ecounts/pcounts  actual counts in detecor
;;* etimesg          geometric factor*efficiency
;;* temp_e           temperature electrons
;;* temp_hip         temperature high-E p
;;* 
;;*  
;;*
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
end

