FUNCTION vx_cross_vy,  vx,  vy

;calculate the cross of two vectors

vx = double(vx) & vy = double(vy)
vz = dblarr(3)
vz(0) = vx(1)*vy(2)-vx(2)*vy(1)
vz(1) = vx(2)*vy(0)-vx(0)*vy(2)
vz(2) = vx(0)*vy(1)-vx(1)*vy(0)

return,  vz

end
PRO Card_Sphere,  vect, EXCHAN = exchan

;transfer between sphereic coordinates to cardisian coordinates
;Good for both 2D and 3D transform
;vector in Card. coord. (x,y,z)
;vector in Sphe. coord. (r, polar angle(radian),azimuth angle(radian,
;0 from x and positive in anticlockwise direction))
; exchan=1 --> cartesian to spherical
; exchan=2 --> spherical to cartesian

  IF keyword_set(EXCHAN) THEN BEGIN 
     exchan = EXCHAN 
  ENDIF ELSE BEGIN 
     print,  'Which way to go? 1: C->S; 2: S->C'
     read,  'Input you choice (1/2):  ', exchan
  ENDELSE

;see 2D tranform or 3D
  num = n_elements(vect)
  IF num EQ 3 THEN BEGIN 
     vector = vect 
  ENDIF ELSE BEGIN
     IF exchan EQ 1 THEN vector = [vect(0), vect(1), 0.]
     IF exchan EQ 2 THEN vector = [vect(0), !pi/2., vect(1)]
  ENDELSE 

  vout = dblarr(3)
  IF exchan EQ 1 THEN BEGIN     ;C->S
     vout(0) = sqrt(total(vector^2))
     IF vout(0) EQ 0. THEN BEGIN
        vout = dblarr(3)
        return
     ENDIF
     dr = sqrt(vector(0)^2+vector(1)^2) ;(x^2+y^2)^.5
     theta = asin(dr/vout(0))
     IF (vector(2) LT 0.) THEN theta = !pi-theta ;theta in [0,!pi]
     IF dr GT 0. THEN BEGIN 
        phi = acos(vector(0)/dr)
        IF (vector(1) LT 0.) THEN phi = 2*!pi-phi ;phi in [0,2!pi]
     ENDIF ELSE BEGIN 
        phi = 0.
     ENDELSE
     vout(1) = theta & vout(2) = phi
  ENDIF ELSE BEGIN              ;S->C
     vout = [vector(0)*sin(vector(1))*cos(vector(2)),  $
         vector(0)*sin(vector(1))*sin(vector(2)),  $
         vector(0)*cos(vector(1))]
  ENDELSE 

  IF num EQ 3 THEN BEGIN 
     vect = vout 
  ENDIF ELSE BEGIN
     IF exchan EQ 1 THEN vect = [vout(0), vout(2)] ;S out
     IF exchan EQ 2 THEN vect = [vout(0), vout(1)] ;C out
  ENDELSE 
  
  
END
; convert latitude defined as degrees from z axis to elevation defined
; as elevation over x-y plane. Range is set to be from -180 to 180
function lat2elev, lat
  elev = lat*!radeg
  IF elev LT -90 THEN elev = elev+270
  return, elev
END 


PRO lanl_mpa_pitch_coordtrans, vector, FROM_CS = from_cs,  TO_CS = to_cs, S_C = s_c, SPHEREIN = sphereIN, SPHEREOUT = sphereout, iyr = iyr, idoy = idoy, secs = secs
  
;PHILOSOPHY: tranfering coords to GEO first and then from GEO to other
;coordinate system
;
; only conversion from 'S_C' (LANL geo or GOES) is implemented. Using onera
; routines for other conversions
;
; Input:    vector - input vector in spacecraft coords. If spherical,
;                    use radians and set keyword SPHERE (x,y,z or lon,lat,rad)
; KEYWORDS:
;           FROM_CS - coordinates of input vector (default is spacecraft
;                     coords (LANL geo and GOES s/c)
;           TO_CS   - cordinates of output vector (default is 'GSM')
;           S_C    - holds the input coordinats in spherical GEO coords (lon,lat,rad)
;           SPHEREIN - set if input vector is in spherical coords
;           SPHEREOUT - set if output vector should be in spherical coords
;           IYEAR - year 
;           IDOY  - day of year
;           SECS - UT in seconds
; OUTPUT:   vector - vector in to_cs
;
; Written by Yue Chen, LANL 2003
;
; modified, A. Aa at LANL 2004 

;  IF n_elements(iyr) EQ 0 THEN BEGIN 
;     iyr = 2004 &  idoy = 30 & secs = 100
;  ENDIF
  IF NOT keyword_set(from_cs) THEN from_cs = 'S_C'    ;& to_cs = 'GEO'
  IF NOT keyword_set(to_cs)  THEN to_cs = 'GSM'


  IF to_cs NE 'GSM' AND NOT keyword_set(iyr) THEN BEGIN 
     message, 'Need to set year, day of year and second of day for this conversion!!!', /contin
     return
  ENDIF
  IF NOT keyword_set(idoy) THEN idoy = 0
  IF NOT keyword_set(secs) THEN secs = 0
  forward_FUNCTION  vx_cross_vy, band_pass

  vectorin = vector
;  IF keyword_set(SPHEREIN) THEN Card_Sphere, vector, EXCHAN = 2 ;S->C
  IF keyword_set(SPHEREIN) THEN vector = cv_coord(from_sphere = vectorin, /to_rect)

  IF from_cs NE 'S_C' THEN GOTO, convert

;find the matrix to get into GEO
  IF keyword_set(S_C) THEN scc = S_C ;coord. of S/C (in 'GEO')


  IF from_cs EQ 'S_C' THEN BEGIN 
     sctheta = 90.-scc(1)       ;in degree ; convert to colatitude
     scphi = scc(0)
     IF scc(0) LT 0. THEN scphi = 360.+scc(0) ;in degree
;     possc = [scc(2)*sin(sctheta*!pi/180.)*cos(scphi*!pi/180.),  $
;          scc(2)*sin(sctheta*!pi/180.)*sin(scphi*!pi/180.),  $
;          scc(2)*cos(sctheta*!pi/180.)]        ;coord. of s/c, in Re
     possc = cv_coord(from_sphere = scc, /to_rect, /degrees)
     base_z = -possc            ;z pointing from s/c to Earth center
     base_z = base_z/norm(base_z)

     base_y = vx_cross_vy(base_z, [0, 0, 1.]) ;y=x X north
     base_y = base_y/norm(base_y)

     base_x = vx_cross_vy(base_y,  base_z) ;x=y X z
     base_x = base_x/norm(base_x)

     tmatr1 = [[base_x], [base_y], [base_z]] ;base vectors expressed in GEO
; tmatr1 = invert(tmatr10,  stt, /double)          ;get the M^-1 for the transform

 ;so far we have the T-matrix to get into GEO
  ENDIF


  tmatr2 = [[1, 0, 0], [0, 1, 0], [0, 0, 1]]
  tmatr2 = invert(tmatr2, stt, /double)
  IF stt NE 0 THEN BEGIN 
     print,  stt,  '  problem with the inversion, 1 for singular array, 2 for warning of big error'
     stop,  '=====papco_cxform======'
  ENDIF
;  IF n_elements(secs) gt 1 THEN stop

;stop,  'check the transform'

  tmatr = tmatr2#tmatr1
  vector = tmatr#vector


  convert: 

  IF to_cs EQ 'GEO' THEN return
  iyr = long(iyr) &  idoy = long(idoy) & secs = double(secs) & invec = double(vector) & psi = double(0) & outvec = double([0, 0, 0])
  ;get onera shareable object location
  IF n_elements(lib_name) EQ 0 THEN lib_name = getenv('PAPCO_LIB')+'/onera/onera_desp_lib.so'
  CASE to_cs OF 
     'GSM': BEGIN
        result = call_external(lib_name, 'geo2gsm_', iyr,idoy,secs,psi,invec,outvec, /f_value) 
     END  
     'GSE': BEGIN 
        result = call_external(lib_name, 'geo2gse_', iyr,idoy,secs,invec,outvec, /f_value) 
     END  
     'SM': BEGIN         
        result = call_external(lib_name, 'geo2sm_', iyr,idoy,secs,invec,outvec, /f_value)
     END
     'MAG':BEGIN 
        result = call_external(lib_name, 'geo2mag_', iyr,invec,outvec, /f_value)
     END 
     
  ENDCASE

  vector = outvec
;  IF keyword_set(SPHEREOUT) THEN card_sphere, vector, exchan = 1
  IF keyword_set(sphereout) THEN vector = cv_coord(from_rect = outvec, /to_sphere) ;
END



 

   
