;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Simple routine to fit a curve to the PA data from mpa
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

function lanl_mpa_pitch_curvefit, PA_flux_in,  PA_limits

 COMMON lanl_mpa_pitch_data, mpa_pitch_header, mpa_pitch_data

  dimensions = size(PA_flux_in, /dimensions)
  IF N_elements(dimensions) GT 1 THEN array = 1 ELSE array = 0
  
  sigma = 0.1
  X =(PA_limits(0, *)+PA_limits(1, *))/2
  Y = PA_flux_in
  T = findgen(91)
  
  Z = spline(X, Y, T, sigma)
  
  return, Z
  
end

PRO lanl_mpa_pitch_plot, PA_flux_in,  PA_limits

  Z = lanl_mpa_pitch_curvefit(PA_flux_in,  PA_limits)

  X = findgen(91)
  
  X_org = (PA_limits(0, *)+PA_limits(1, *))/2

  
  plot, x, z,  title = ''
  oplot, x_org, PA_flux_in
  
END 
; routine to plot data from lanl_mpa_pitch common block
; ind gives the time index to plot
; KEYWORDS
;      Emin - lower energy channel to include
;      central - what perpendicular energy to plot
;      NOPLOT - don't plot anything in here
;      SUM - number of time steps to use

function  lanl_mpa_Espace, ind,Emin = Emin,SUM = sum,PSD = PSD, central = central,NOPLOT = NOPLOT, title = title, _extra = _e

  COMMON lanl_mpa_pitch_data, mpa_pitch_header, mpa_pitch_data
  COMMON lanl_mpa

  IF NOT keyword_set(Emin) THEN Emin = 10

  IF keyword_set(SUM) THEN th_data = mpa_pitch_data(ind:ind+sum-1) ELSE  th_data = mpa_pitch_data(ind)
  
  sc_id = where(strupcase(sat_names) EQ strupcase(th_data(0).csat_id))
  IF sc_id EQ 2 THEN offset = 2 ELSE offset = 0
  energies =r_lanl_mpa_channels(sc_id, 0) ; in eV
  e_cent = reverse(papco_mean(energies, 1))
  energies = energies(Emin:39-offset, *)

  IF NOT keyword_set(SUM) THEN sum = 1
  e_cent = rebin(reform(e_cent, 40,1), 40, 6*24*sum)
;  flux = flux/e_cent


  flux = reform(th_data(*).e_unbinned, 40, 6*24*sum)/e_cent*1e3 &  flux = flux(offset:39-emin, *)
  alpha = reform(th_data(*).e_mag, 40, 6*24*sum) &  alpha = alpha(offset:39-Emin, *)
  flux = rotate(flux, 5)
  alpha = rotate(alpha, 5)
  IF keyword_set(PSD) THEN BEGIN 
; convert to phase space density
     psflux = flux
     asz = size(flux, /dimen)
     FOR i = 0, 39-Emin-offset DO BEGIN
        thflux = flux(i, *)
        elow = energies(i, 0) &  ehigh = energies(i, 1)
        elow = rebin([elow], asz(1)) & ehigh = rebin([ehigh], asz(1))
        papco_hilmer_phase_space_density, elow, ehigh, thflux, psd
        psflux(i, *) = psd
     ENDFOR
     flux = psflux
     ytitle = 'Phase space density [s!U3!N*km!U-6!N]'
  ENDIF  ELSE ytitle = 'Differential flux [s*sr*cm!U2!N*keV]!U-1!N'

  utctime = tai2utc(th_data(0).tai, /ecs)
  title = th_data(0).csat_id+' '+utctime
  infind = where(finite(flux) EQ 0, cnt)
  IF cnt GT 0 THEN flux(infind) = -1e31
;  out = trig_angElog(flux, alpha,energies, nodata = -1e31, _extra = _e)
  out = conv_EPAD2Espace(flux, alpha, energies, nodata = -1e31,title = title, _extra = _e)
  siz = size(out.data, /dim)
  IF NOT keyword_set(central) THEN BEGIN 
     IF keyword_set(elog) THEN central = 10 ELSE central = siz(0)/2
  ENDIF ELSE central = central
  IF keyword_set(noplot) THEN return, out

  plot,out.eperp,papco_mean(out.data(*,central-10:central+10),1, nodata = -1e31), /xlog, xtitle = 'E perp [eV]', ytitle = ytitle,title = title,_extra = _e
;  plot,out.epar,papco_mean(out.data(central-10:central+10, *),0, nodata = -1e31), /xlog, xtitle = 'E perp [eV]', ytitle = 'Differential Flux',title = th_data.csat_id+' '+utctime,_extra = _e

;  plot,out.epar(siz(0)+1:siz(1)-1),papco_mean(out.data(central-10:central+10, siz(0)+1:siz(1)-1),0, nodata = -1e31), /xlog, xtitle = 'E perp [eV]', ytitle = 'Differential Flux',title = th_data.csat_id+' '+utctime,_extra = _e
  wait, 0.5
  return, out
END

PRO plot_flat, ind, smooth = smooth,OUT_data = OUT_data, OUT_par = OUT_par,OUT_perp = OUT_perp,NOPLOT = NOPLOT, ENERGY = energy,LOG = LOG,title = title, _extra = _e
  COMMON lanl_mpa_pitch_data, mpa_pitch_header, mpa_pitch_data
  sc_name = mpa_pitch_data(0).csat_id
  utctime = tai2utc(mpa_pitch_data(ind).tai, /ecs)
;  res = lanl_mpa_Espace( ind, /noplot, _extra = _e)  
;  contour, leefilt(res.data, 20), res.eperp, res.epar,xrange = [100, 4e4], yrange = [100, 4e4], /xlog, /ylog, min_value = 0, /xstyle, /ystyle, nlev = 30
  
;  levels =  [1e4, 5e4, 1e5, 5e5, 1e6,2e6, 5e6, 1e7,2e7, 5e7]
  
  res = lanl_mpa_Espace(ind, _extra = _e, /noplot)
  data = res.data
  IF keyword_set(smooth) THEN data = smooth(data, smooth)
  par = res.epar
  perp = res.eperp
  IF keyword_set(energy) THEN BEGIN
     par = vel2kev(par)
     perp = vel2kev(perp)
     xtitle = 'Eperp [keV]
     ytitle = 'Epar [keV]
  endIF ELSE BEGIN 
     xtitle =  'V perp [m/sec]'
     ytitle = 'V par [m/sec]'
  ENDELSE
  IF keyword_set(LOG) THEN BEGIN 
     n_el = n_elements(par)
     data = data(*, n_el/2:n_el-1)
     par = par(n_el/2:n_el-1)
  ENDIF 
     
  
  IF NOT keyword_set(NOPLOT) THEN contour,data,perp,par,/xstyle,/ystyle,nlev=40, xtitle =xtitle, ytitle =ytitle , title = 'Differential flux contours '+utctime+' '+sc_name, _extra = _e
  OUT_data = data 
  OUT_par = par
  OUT_perp = perp
END 


function  lanl_mpa_Eperp, ind,title = title,ytitle = ytitle,xtitle = xtitle, Emin = Emin,Eperp = Eperp,NOPLOT = NOPLOT,PSD = PSD, _extra = _e

  COMMON lanl_mpa_pitch_data, mpa_pitch_header, mpa_pitch_data
  COMMON lanl_mpa

  IF NOT keyword_set(Emin) THEN Emin = 10

 
  th_data = mpa_pitch_data(ind)
  
  sc_id = where(strupcase(sat_names) EQ strupcase(th_data.csat_id))
  energies =r_lanl_mpa_channels(sc_id, 0) ; in eV
  e_cent = reverse(papco_mean(energies, 1))
  energies = energies(Emin:39, *)
  
  e_cent = rebin(reform(e_cent, 40,1), 40, 6*24)
;  flux = flux/e_cent
  flux = reform(th_data.e_unbinned, 40, 6*24)/e_cent*1e3 &  flux = flux(0:39-emin, *)
  alpha = reform(th_data.e_mag, 40, 6*24) &  alpha = alpha(0:39-Emin, *)
  flux = rotate(flux, 5)
  alpha = rotate(alpha, 5)

  IF keyword_set(PSD) THEN BEGIN 
; convert to phase space density
     psflux = flux
     asz = size(flux, /dimen)
     FOR i = 0, 39-Emin DO BEGIN
        thflux = flux(i, *)
        elow = energies(i, 0) &  ehigh = energies(i, 1)
        elow = rebin([elow], asz(1)) & ehigh = rebin([ehigh], asz(1))
        papco_hilmer_phase_space_density, elow, ehigh, thflux, psd
        psflux(i, *) = psd
     ENDFOR
     flux = psflux
     ytitle = 'Phase space density [s!U3!N*km!U-6!N]'
  ENDIF  ELSE ytitle = 'Differential flux [s*sr*cm!U2!N*keV]!U-1!N'
  utctime = tai2utc(th_data.tai, /ecs)
  title = th_data.csat_id+' '+utctime
  xtitle =  'E!D||!N [eV]'

  infind = where(finite(flux) EQ 0, cnt)
  IF cnt GT 0 THEN flux(infind) = -1e31
  
  res = get_Epar(flux, alpha, energies, Eperp, _extra = _e)

  IF NOT keyword_set(NOPLOT) THEN  plot, res.epar, res.flux, psym = 1, /ylog,/xlog, min_value = 0,xtitle =xtitle, ytitle = ytitle ,title = title,_extra = _e

;  out = trig_angElog(flux, alpha,energies, nodata = -1e31, _extra = _e)
  wait, 0.5
  return, res
END

PRO plot_Eperp, ind, eperp_list = eperp_list, _extra = _e

  IF NOT keyword_set(eperp_list) THEN eperp_list = [10, 100, 200, 300, 500, 750, 1000, 1500, 2000, 3000, 5000]


  res = lanl_mpa_Eperp(ind, Eperp = eperp_list(0),title = title,ytitle = ytitle, xtitle = xtitle, _extra = _e)
;  flux = all.flux &  epar = all.epar
  plot, res.epar, res.flux, psym = 2,title = title,ytitle = ytitle, xtitle = xtitle, _extra = _e

  FOR i = 1, n_elements(eperp_list)-1 DO BEGIN 
;     all =lanl_mpa_eperp(ind, eperp = eperp_list(i), _extra = _e)
;     flux = [[flux],[all.flux]]
;     epar = [[epar], [all.epar]]
;  ENDFOR 
; BEGIN 
     res = lanl_mpa_eperp(ind, eperp = eperp_list(i), _extra = _e)
     oplot, res.epar, res.flux, psym = 2, color = 20*i
  ENDFOR 
;  plot, epar(0, *), flux(0, *), _extra = _e
;  FOR i = 1, n_elements(eperp_list)-1 DO oplot, epar(i, *), flux(i, *), psym = 2, color = 20*1


END 
  
