function r_lanl_mpa_flux_conversion, sat_id, yyyymm
;***********************************************************************************
;*  DESCRIPTION
;*     returns calibration factors determined from all the available data for
;*     these satellites (as of July 2003). 
;*  INPUT
;*     sat_id : code for spacecraft
;*
;*  OUTPUT
;*     corr_factors: structure containing all correction, conversion
;*                   and energy factors. 
;*                   gfactor:  geometric factor for each detector
;*                   factors:  new interdetector calibration factors
;*                            (August 2003)
;*                   etimes:  gfactor times old interdetector
;*                            calibration factors (M.Thompson)
;*                   effecp:  efficiency factors for each proton energy
;*                            channel 
;*                   effece:  efficiency factors for each electron
;*                            energy channel
;*                   ecp:     center energy of each proton channel
;*                   ece:     center energy of each electron channel
;*                   
;*  CALIBRATION PROCEDURE: 
;8     select the pitch angles between 85 and 95 degrees where all
;*     detectors contribute. We collected all data points for each
;*     month and found the best fit between detector 1 and the other
;*     detectors. Final efficiency is a fit to all these values,
;*     wighted by the number of data points for each month.
;*   MODIFCATION HISTORY:
;*      written by Arne Aasnes, July 2003
;*      modified Nov. 2003, implemented the monthly efficiency
;*                          factors, AAA at LANL 
;*
;************************************************************************************

  gfactor = [3.26e-4, 4.9e-4, 5.74e-4, 5.74e-4, 4.9e-4, 3.26e-4]  
  lib = '$PAPCO_BASE/papco_modules/lanl_mpa/factors/'

  sat_id = strupcase(sat_id)
  CASE sat_id OF  
     '1989-046':BEGIN 
;        factors = [1.0000000, 1.0655485, 1.1456198, 1.0419013, 1.0028210, 0.96499619]
;        etimesg = [0.000296660, 0.000401800, 0.000424760, 0.000487900, 0.000431200, 0.000309700]

        effecp = [ 0.977570, 0.946452, 0.919367, 0.895825, 0.875400, 0.857721, 0.842464, 0.829534, 0.818316, $
                   0.80863, 0.800455, 0.793606, 0.787870, 0.783080, 0.779158, 0.776063, 0.773639, 0.771593, $
                   0.769920, 0.768613, 0.767587, 0.766791, 0.766183, 0.765716, 0.765352, 0.765069, 0.764849, $
                   0.764680, 0.764551, 0.764450, 0.764372, 0.764312, 0.764265, 0.764227, 0.764197, 0.764174, $
                   0.764155, 0.764141, 0.764130, 0.764120]


        effece = [0.528746, 0.561825, 0.594903, 0.627980, 0.661058, 0.694135, 0.727801, 0.761221, 0.793828, $
                  0.826837, 0.859230, 0.891747, 0.924634, 0.957588, 0.991194, 0.984758, 0.975177, 0.966250, $
                  0.949493, 0.926689, 0.901353, 0.876236, 0.853966, 0.835209, 0.821173, 0.809316, 0.798100, $
                  0.789106, 0.782822, 0.778041, 0.773837, 0.770425, 0.767677, 0.765563, 0.763949, 0.762793, $
                  0.762010, 0.761455, 0.761071, 0.760804]

        
        ece = [-1.0000, -1.0000, -1.0000, -1.00000, 13268.4, 10152.1, 7730.75, 5898.65, 4530.44, 3468.30, 2668.43, $
               2050.98, 1571.69, 1203.74, 917.088, 701.294, 536.052, 409.321, 313.196, 239.303, 182.294, 138.130, $
               105.128, 80.4651, 63.4680, 49.9254, 37.7154, 28.3046, 21.9135, 17.1464, 13.0192, 9.71365, 7.07814, $
               5.06754, 3.54173, 2.45342, 1.71931, 1.19971, 0.840702, 0.591660]

        
        ecp = [-1.0000, -1.0000, -1.0000, -1.0000, -1.0000, -1.00000, -1.00000, 6075.29, 4677.77, 3589.36, 2755.27, $
               2117.22, 1625.18, 1244.11, 952.302, 734.831, 572.495, 440.936, 337.009, 258.205, 197.732, 151.687, $
               117.043, 90.7177, 70.3832, 54.6663, 42.5147, 33.2603, 26.1610, 20.6611, 16.3902, 13.1255, 10.6044, $
               8.53283, 6.88244, 5.62868, 4.63822, 3.87682, 3.27261, 2.74250]
        efilename = 'l9_e_monthly_factors.idl'
        ifilename = 'l9_i_monthly_factors.idl'
        
     END 
     '1990-095': BEGIN
;        factors = [1.0000000, 0.99773217, 1.0650023, 0.99510843, 0.93563324, 0.94027846]
;        etimesg = [0.000309700, 0.000396900, 0.000407540, 0.000522340, 0.000455700, 0.000309700]

        effecp =  [0.978260, 0.946879, 0.919587, 0.895886, 0.875338, 0.857570, 0.842250, $
                 0.829085, 0.817822, 0.808236, 0.800126, 0.793313, 0.787631, 0.783005, $
                 0.779174, 0.776009, 0.773437, 0.771366, 0.769759, 0.768497, 0.767493, $
                 0.766713, 0.766119, 0.765663, 0.765316, 0.765046, 0.764834, 0.764670, $
                 0.764543, 0.764445, 0.764372, 0.764317, 0.764273, 0.764239, 0.764211, $
                 0.764191, 0.764175, 0.764158, 0.764145, 0.764135]
        
        effece = [0.519727, 0.553578, 0.587428, 0.621279, 0.655133, 0.688983, 0.722832, $
                  0.756682, 0.791026, 0.825580, 0.859485, 0.893102, 0.926230, 0.959081, $
                  0.992405, 0.983733, 0.974754, 0.965062, 0.946849, 0.922968, 0.897212, $
                  0.872100, 0.849915, 0.831569, 0.816139, 0.803651, 0.793806, 0.785860, $
                  0.779673, 0.774647, 0.770784, 0.768195, 0.766272, 0.764831, 0.763886, $
                  0.763192, 0.762748, 0.762401, 0.762065, 0.761813]
        
        ece =    [41647.6, 31666.9, 24078.3, 18307.9, 13920.2, 10584.4, 8048.02, 6119.35, $
                  4634.37, 3503.75, 2662.94, 2028.61, 1551.52, 1189.29, 908.141, 690.931, $
                  526.232, 399.525, 302.668, 229.783, 174.356, 131.636, 99.5892, 75.9480, $
                  57.6336, 43.6899, 33.1827, 24.9848, 18.7638, 13.8098, 10.0601, 7.57295, $
                  5.74030, 4.37430, 3.48246, 2.82860, 2.41176, 2.08591, 1.77059, 1.53440]
        
        ecp =    [-1.0000, -1.0000, -1.0000, -1.0000, 13290.8, 10205.0, 7835.73, 6016.43, $
                  4619.54, 3546.95, 2723.40, 2091.08, 1605.57, 1238.35, 953.446, 731.159, $
                  559.292, 426.643, 327.186, 251.277, 192.250, 147.214, 113.408, 87.7316, $
                  68.3418, 53.3812, 41.6892, 32.7124, 25.7138, 20.3706, 16.4122, 13.4373, $
                  11.0454, 9.14877, 7.67080, 6.54851, 5.68595, 4.79051, 4.06701, 3.52165]
        efilename = 'l0_e_monthly_factors.idl'
        ifilename = 'l0_i_monthly_factors.idl'
     END 
     '1991-080':BEGIN 
;        factors = [1.0000000, 0.89300619, 0.97736054, 0.85749671, 0.93084263, 0.83783321]
;        etimesg = [0.000241240, 0.000431200, 0.000470680, 0.000545300, 0.000421400, 0.000309700]

        effecp = [0.993668, 0.960003, 0.930744, 0.905352, 0.883350, 0.864331, 0.847933, 0.833842, $
                  0.821344, 0.810858, 0.802377, 0.795194, 0.789120, 0.784538, 0.780666, 0.777099, $
                  0.774284, 0.772029, 0.770261, 0.768858, 0.767758, 0.766919, 0.766250, 0.765742, $
                  0.765352, 0.765038, 0.764799, 0.764615, 0.764469, 0.764354, 0.764268, 0.764206, $
                  0.764162, 0.764126, 0.764098, 0.764083, 0.764076, 0.764073, 0.764071, 0.764071]

        effece = [0.523104, 0.556428, 0.589753, 0.623079, 0.656401, 0.689726, 0.723052, 0.756376, $
                 0.789700, 0.823138, 0.856379, 0.889508, 0.922725, 0.955768, 0.989016, 0.985597, $
                 0.975304, 0.966532, 0.949842, 0.927072, 0.902159, 0.877499, 0.855214, 0.836460, $
                 0.820773, 0.807975, 0.796487, 0.787389, 0.781191, 0.777280, 0.774742, 0.771786, $
                 0.768923, 0.766762, 0.764979, 0.763607, 0.762601, 0.761668, 0.760924, 0.760540]

        ece = [-1.00000,     -1.00000,     -1.00000,      18043.2,      13778.1,      10520.9,      8033.69,  $
               6134.53,      4684.34,      3573.71,      2730.71,      2088.48,      1596.15,      1221.61,   $
               933.400,      709.123,      539.080,      411.777,      314.643,      240.312,      183.875,   $
               140.150,      106.861,      82.0356,      62.9991,      48.4355,      36.0035,      26.5434,   $
               20.2776,      16.3945,      13.9025,      11.0272,      8.27043,      6.20645,      4.51481,   $
               3.21919,      2.27332,      1.39893,     0.703136,     0.344625]


        ecp = [43005.7,      32939.8,      25229.4,      19324.0,     14800.7,      11336.4,      8683.06,     $
               6650.65,      5040.48,      3829.67,      2944.28,     2260.18,      1729.10,      1357.28,     $
               1062.31,      806.396,      614.991,      468.513,     357.927,      272.797,      207.687,     $
               159.053,      120.810,      92.1656,      70.3639,     52.9430,      39.7505,      29.6606,     $
               21.7198,      15.4483,      10.7750,      7.40945,     5.00100,      3.07083,      1.51658,     $
               0.717879, 0.362170, 0.178866, 0.0874074, 0.0431614]
        efilename = 'l1_e_monthly_factors.idl'
        ifilename = 'l1_i_monthly_factors.idl'
     END 
     '1994-084':BEGIN 
;        factors = [1.0000000, 0.95216526, 1.0072055, 1.0007240, 1.0317137, 0.90924000]
;        etimesg = [ 0.000296660, 0.000465500, 0.000510860, 0.000574000, 0.000382200, 0.000270580]

        effecp = [0.992220, 0.958122, 0.928573, 0.903005, 0.880919, 0.861886, 0.845531, 0.831529, 0.819520, 0.809350, $
     0.800914, 0.793867, 0.787923, 0.783080, 0.779103, 0.775826, 0.773266, 0.771238, 0.769598, 0.768329, $
     0.767357, 0.766610, 0.766019, 0.765564, 0.765226, 0.764961, 0.764759, 0.764611, 0.764495, 0.764400, $
     0.764326, 0.764279, 0.764240, 0.764200, 0.764170, 0.764150, 0.764136, 0.764121, 0.764101, 0.764087]

        effece = [0.521343, 0.555158, 0.588976, 0.622793, 0.656613, 0.690431, 0.724246, 0.758064, 0.792094, 0.825965, $
     0.859885, 0.893502, 0.926686, 0.960134, 0.994341, 0.982610, 0.974234, 0.963945, 0.945515, 0.921152, $
     0.895849, 0.872004, 0.850973, 0.832891, 0.817369, 0.804789, 0.794756, 0.786866, 0.780958, 0.776212, $
     0.773000, 0.770647, 0.768365, 0.766549, 0.765311, 0.764529, 0.763590, 0.762775, 0.762299, 0.761911]

        ece = [ 41106.5, 31264.3, 23778.5, 18084.9, 13754.5, 10461.0, 7956.38, 6051.29, 4594.48, 3492.85, $
      2654.34, 2022.05, 1545.80, 1179.19, 894.025, 678.357, 514.850, 390.991, 297.621, 225.309, $
      171.807, 131.487, 101.023, 77.5792, 59.0470, 44.9311, 34.1784, 26.0088, 20.0447, 15.3431, $
      12.2049, 9.92774, 7.73563, 6.00333, 4.82908, 4.08901, 3.20312, 2.43721, 1.98997, 1.62665]
        ecp = [42546.5, 32414.8, 24695.8, 18815.3, 14334.7, 10921.1, 8320.44, 6339.10, 4820.69, 3666.06, $
      2800.00, 2140.44, 1629.54, 1244.11, 948.288, 718.645, 548.161, 418.569, 317.396, 241.321, $
      184.312, 141.294, 107.733, 82.2066, 63.3587, 48.7249, 37.5948, 29.4486, 23.1188, 17.9419, $
      13.9204, 11.3498, 9.21786, 7.04074, 5.40300, 4.32968, 3.59032, 2.74663, 1.70909, 0.943763]
        efilename = 'l4_e_monthly_factors.idl'
        ifilename = 'l4_i_monthly_factors.idl'
     end 
     'LANL-97A':BEGIN 
;        factors = [1.0000000, 1.1386141, 1.0730781, 1.1085146, 1.0599794, 1.0551771]
;        etimesg = [0.000300898, 0.000407680, 0.000544726, 0.000529802, 0.000465500, 0.000309700]
        effecp = [0.986035, 0.953018, 0.924379, 0.899575, 0.878128, 0.859629, 0.843721, 0.830089, 0.818400, $
                  0.808527, 0.800188, 0.793330, 0.787624, 0.782816, 0.778870, 0.775677, 0.773175, 0.771175, $
                  0.769576, 0.768339, 0.767387, 0.766642, 0.766071, 0.765631, 0.765289, 0.765022, 0.764814, $
                  0.764665, 0.764545, 0.764447, 0.764374, 0.764313, 0.764261, 0.764215, 0.764177, 0.764150, $
                  0.764131, 0.764116, 0.764107, 0.764099]
        effece = [0.520189, 0.553812, 0.587435, 0.621056, 0.654679, 0.688302, 0.721924, 0.755546, 0.789168, 0.823343, $
     0.856519, 0.889081, 0.922822, 0.957142, 0.991581, 0.984135, 0.975047, 0.965912, 0.948392, 0.925579, $
     0.900905, 0.876740, 0.855514, 0.837328, 0.821047, 0.808557, 0.798814, 0.790789, 0.784008, 0.778059, $
     0.774412, 0.772266, 0.769648, 0.766746, 0.764877, 0.763632, 0.762665, 0.762205, 0.761607, 0.761223]

        ece = [41491.9, 31607.0, 24076.8, 18341.0, 13971.5, 10642.8, 8107.34, 6175.90, 4704.58, 3567.76, $
      2727.64, 2095.71, 1594.90, 1208.10, 914.221, 695.106, 532.988, 406.453, 308.723, 236.411, $
      181.419, 138.934, 107.279, 83.1319, 63.3206, 49.0816, 38.4765, 30.0410, 23.1084, 17.1639, $
      13.5801, 11.4929, 8.96610, 6.19101, 4.41774, 3.24265, 2.33390, 1.90210, 1.34164, 0.982899]

        ecp = [40611.6, 31011.1, 23680.4, 18082.9, 13808.2, 10543.9, 8051.49, 6148.21, 4687.64, 3577.95, $
      2729.36, 2092.65, 1604.99, 1223.93, 931.542, 708.526, 542.241, 414.669, 316.089, 241.893, $
      186.063, 143.158, 110.674, 85.9553, 66.8870, 52.0835, 40.5932, 32.4325, 25.8465, 20.5100, $
      16.5301, 13.2196, 10.3624, 7.86638, 5.83095, 4.35890, 3.31964, 2.52587, 1.98997, 1.55902]
        efilename = 'l7_e_monthly_factors.idl'
        ifilename = 'l7_i_monthly_factors.idl'
     END 
     'LANL-01A':BEGIN
;        factors = [1.0000000, 0.91192062, 0.94031617, 1.0149896, 0.89232068, 0.99264455]
;        etimesg = [0.000306766, 0.000490000, 0.000114800, 0.000523488, 0.000433160, 0.000309700]

        effecp = [0.993984, 0.960535, 0.931409, 0.906102, 0.884152, 0.865155, 0.848752, 0.834639, 0.822711, 0.812539, $
     0.803805, 0.796408, 0.790204, 0.785022, 0.780743, 0.777252, 0.774425, 0.772173, 0.770388, 0.768969, $
     0.767860, 0.767001, 0.766340, 0.765828, 0.765434, 0.765134, 0.764898, 0.764714, 0.764572, 0.764462, $
     0.764377, 0.764311, 0.764258, 0.764219, 0.764188, 0.764163, 0.764147, 0.764129, 0.764114, 0.764106]
        effece = [0.530503, 0.562694, 0.595398, 0.628105, 0.660811, 0.693516, 0.726225, 0.758931, 0.789234, 0.819600, $
     0.852396, 0.884662, 0.917782, 0.951758, 0.985492, 0.988157, 0.975987, 0.967871, 0.951766, 0.929534, $
     0.905459, 0.881511, 0.858715, 0.838119, 0.821390, 0.808172, 0.797904, 0.789942, 0.783743, 0.778926, $
     0.774812, 0.771568, 0.769000, 0.766964, 0.765514, 0.764339, 0.763463, 0.762710, 0.762019, 0.761622]

        ece = [38169.0, 29414.5, 22574.1, 17324.0, 13294.9, 10203.0, 7830.01, 6009.00, 4702.04, 3677.50, $
      2820.18, 2172.03, 1661.31, 1261.90, 960.403, 730.184, 555.828, 424.187, 322.879, 246.935, $
      190.479, 146.692, 111.789, 84.1344, 63.7223, 48.6544, 37.5067, 29.1662, 22.8410, 18.0222, $
      13.9714, 10.8166, 8.34406, 6.39894, 5.02104, 3.90991, 3.08344, 2.37558, 1.72745, 1.35554]
        ecp = [43106.2, 33088.8, 25393.8, 19488.0, 14955.8, 11477.8, 8808.31, 6759.60, 5207.78, 4015.17, $
      3087.42, 2371.61, 1820.68, 1395.39, 1068.04, 817.062, 624.375, 477.732, 365.732, 279.428, $
      213.664, 163.742, 125.950, 97.0026, 74.9566, 58.2884, 45.2296, 35.0915, 27.3180, 21.3171, $
      16.7039, 13.1071, 10.2006, 8.06983, 6.42159, 5.04444, 4.17995, 3.21481, 2.41454, 1.96214]
        efilename = 'a1_e_monthly_factors.idl'
        ifilename = 'a1_i_monthly_factors.idl'
     END 
     'LANL-02A':BEGIN 
;        factors = [1.0000000, 1.0625561, 1.0515233, 1.0232954, 1.0410545, 1.1072061]
;        etimesg = [0.000309700, 0.000446292, 0.000523258, 0.000539560, 0.000448644, 0.000239186]
        effecp = [0.986035, 0.953018, 0.924379, 0.899575, 0.878128, 0.859629, 0.843721, 0.830089, 0.818400, 0.808527, $
     0.800188, 0.793330, 0.787624, 0.782816, 0.778870, 0.775677, 0.773175, 0.771175, 0.769576, 0.768339, $
     0.767387, 0.766642, 0.766071, 0.765631, 0.765289, 0.765022, 0.764814, 0.764665, 0.764545, 0.764447, $
     0.764374, 0.764313, 0.764261, 0.764215, 0.764177, 0.764150, 0.764131, 0.764116, 0.764107, 0.764099]
        effece = [ 0.520189, 0.553812, 0.587435, 0.621056, 0.654679, 0.688302, 0.721924, 0.755546, 0.789168, 0.823343, $
     0.856519, 0.889081, 0.922822, 0.957142, 0.991581, 0.984135, 0.975047, 0.965912, 0.948392, 0.925579, $
     0.900905, 0.876740, 0.855514, 0.837328, 0.821047, 0.808557, 0.798814, 0.790789, 0.784008, 0.778059, $
     0.774412, 0.772266, 0.769648, 0.766746, 0.764877, 0.763632, 0.762665, 0.762205, 0.761607, 0.761223]

        ece = [41491.9, 31607.0, 24076.8, 18341.0, 13971.5, 10642.8, 8107.34, 6175.90, 4704.58, 3567.76, $
      2727.64, 2095.71, 1594.90, 1208.10, 914.221, 695.106, 532.988, 406.453, 308.723, 236.411, $
      181.419, 138.934, 107.279, 83.1319, 63.3206, 49.0816, 38.4765, 30.0410, 23.1084, 17.1639, $
      13.5801, 11.4929, 8.96610, 6.19101, 4.41774, 3.24265, 2.33390, 1.90210, 1.34164, 0.982899]

        ecp = [ 40611.6, 31011.1, 23680.4, 18082.9, 13808.2, 10543.9, 8051.49, 6148.21, 4687.64, 3577.95, $
      2729.36, 2092.65, 1604.99, 1223.93, 931.542, 708.526, 542.241, 414.669, 316.089, 241.893, $
      186.063, 143.158, 110.674, 85.9553, 66.8870, 52.0835, 40.5932, 32.4325, 25.8465, 20.5100, $
      16.5301, 13.2196, 10.3624, 7.86638, 5.83095, 4.35890, 3.31964, 2.52587, 1.98997, 1.55902]
        efilename = 'a2_e_monthly_factors.idl'
        ifilename = 'a2_i_monthly_factors.idl'
      
     END 
     ELSE: BEGIN 
;        factors = [1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
     END  
  ENDCASE 

  IF n_elements(yyyymm) NE 0 THEN BEGIN 
           
     restore, lib+efilename, /verbose
     e_eff_factors = eff_factors
     restore, lib+ifilename
     i_eff_factors = eff_factors
     ind = where(yyyymm EQ eff_factors.yyyymm)
     IF ind(0) NE -1 THEN BEGIN 
        efactors = e_eff_factors(ind).mn_eff_factors
        e_etimesg = efactors*gfactor 
        ifactors = i_eff_factors(ind).mn_eff_factors
        i_etimesg = ifactors*gfactor
     endIF ELSE BEGIN 
        efactors = fltarr(6)
        ifactors = fltarr(6)
        FOR i = 0, 5 DO efactors(i) = interpol(e_eff_factors.mn_eff_factors(i), e_eff_factors.yyyymm, yyyymm)
        FOR i = 0, 5 DO ifactors(i) = interpol(i_eff_factors.mn_eff_factors(i), i_eff_factors.yyyymm, yyyymm)
        e_etimesg = efactors*gfactor
        i_etimesg = ifactors*gfactor
     ENDELSE  
     IF yyyymm GT max(e_eff_factors.yyyymm) THEN BEGIN 
        efactors = e_eff_factors(n_elements(e_eff_factors)-1).mn_eff_factors
        ifactors = i_eff_factors(n_elements(i_eff_factors)-1).mn_eff_factors
     endIF 
     IF yyyymm LT min(e_eff_factors.yyyymm) THEN BEGIN 
        efactors = e_eff_factors(0).mn_eff_factors
        ifactors = i_eff_factors(0).mn_eff_factors
     enDIF 
  endIF  
  IF n_elements(efactors) EQ 0 THEN BEGIN 
     efactors = factors 
     ifacors = factors
  ENDIF 
  corr_factors = {correction_factors, gfactor:gfactor, etimesg:e_etimesg, factors:efactors, effecp:effecp, effece:effece, $
                                      ecp:ecp, ece:ece}

  return, corr_factors
  
END 
