;******************************************************************************
;* PROCEDURE:     
;*      PRO DrawSlice_noaa_overview_flux, panelNr, seconds, yValue
;* 
;* DESCRIPTION:  
;*      Draw a slice for noaa_overview_flux
;*      calling a separate window for the plot.
;*      slice_type in draw_noaa_overview_flux must be set to +2 to enable this feature.
;*
;* INPUTS:       
;*      panelNr     an integer, the number of the panel for which the slice 
;*                  is to be drawn
;*      seconds     time of mouse click, a float
;*      yvalue      y-value of mouse click, a float
;*      
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      called by papco_DrawSLice (in $papco_PATH/papco_cursor.pro)
;*
;* MODIFICATION HISTORY:       
;*      June 1998 by S. BOURDARIE
;*      September 1999 by S. BOURDARIE
;******************************************************************************
PRO USER_multiple_Horiz_Slices_noaa_overview, panelNr, seconds,yValue,CLOSE=CLOSE, READDATA=READDATA

   COMMON PAPCO_DRAWSLICE, sliceWidgetData
   COMMON PLOT_COMPOSER, widgetData
   COMMON ADDINS, plot_types
   COMMON ISREAD, IsReadArr

   common noaa_overview_data, input_header, input_data
   common mjdt, mjdt_start, mjdt_end    ;common time limit in mjdt
   common USER_multiple_Horiz_Slices_noaa_overview_info, noaa_overview_panelNr, noaa_overview_seconds, noaa_overview_yValue
   common USER_multiple_Horiz_Slices_noaa_overview, IdColor,oldpanel,xyoutIndex,clear_slice

noaa_overview_panelNr = panelNr
noaa_overview_seconds = seconds
noaa_overview_yValue = yValue



;-- close the window ? --------------------------------------------------------
    IF XREGISTERED('USER_multiple_Vert_Slices_noaa_overview') THEN $
         IF N_ELEMENTS(sliceWidgetData) GT 0 THEN BEGIN
	    IF sliceWidgetData.base NE 0 THEN $
  	       WIDGET_CONTROL, sliceWidgetData.base, /DESTROY
            sliceWidgetData.base=0
         ENDIF
   IF KEYWORD_SET(CLOSE) THEN BEGIN
      IF XREGISTERED('USER_multiple_Horiz_Slices_noaa_overview') THEN $
         IF N_ELEMENTS(sliceWidgetData) GT 0 THEN BEGIN
	    IF sliceWidgetData.base NE 0 THEN $
  	       WIDGET_CONTROL, sliceWidgetData.base, /DESTROY
            sliceWidgetData.base=0
         ENDIF
      RETURN
   ENDIF
;-- if the window exists, bring it in front. Else, create it ------------------
   IF NOT XREGISTERED('USER_multiple_Horiz_Slices_noaa_overview') THEN BEGIN
      Slice_Base=WIDGET_BASE(COLUMN=1, $
		GROUP=widgetData.main_base, $
		title='USER Multiple Slices')
;-- setup draw area -----------------------------------------------------------
      draw_base=WIDGET_BASE(Slice_base, COLUMN=1, /FRAME)
      dw_Slice  =WIDGET_DRAW(draw_base, XSIZE=500, YSIZE=500)

;-- set up label fields for user data -----------------------------------------
      user_label_base=WIDGET_BASE(slice_base, COLUMN=1, /FRAME)
      lbl_slice1=WIDGET_LABEL(user_label_base,VALUE=strcenter('uservalues',80))
      lbl_slice2=WIDGET_LABEL(user_label_base,VALUE=strcenter('uservalues',80))
;-- set up buttons for the Actions --------------------------------------------
      Butt_Base=WIDGET_BASE(Slice_Base, ROW=1, /FRAME)
      pb_help=WIDGET_BUTTON(Butt_Base, $
                              Value=strcenter('Help', 12), $
			      UVALUE='pb_help')
      pb_print=WIDGET_BUTTON(Butt_Base, $
                             Value=strcenter('Print', 12), $
                             UVALUE='pb_print')
      pb_clear=WIDGET_BUTTON(Butt_Base, $
                              Value=strcenter('Clear', 12), $
			      UVALUE='pb_clear')
      pb_done=WIDGET_BUTTON(Butt_Base, $
                              Value=strcenter('Close', 12), $
			      UVALUE='pb_done')
      switch_base = widget_base(butt_base,ROW=1,/exclusive,/frame)
      pb_mulPlot = widget_button(switch_base,value='Multiple Slice', $
                              uvalue='pb_mulPlot')
      pb_onePlot = widget_button(switch_base,value='One Slice', $
                              uvalue='pb_onePlot')
      WIDGET_CONTROL, pb_mulPlot, /SET_BUTTON
      clear_slice = 2
      sliceWidgetData={ $
		base:slice_base, $
	        dw_slice:dw_slice, $
		lbl_slice1:lbl_slice1, $
		lbl_slice2:lbl_slice2, $
                slice_call:'', $
	        panelNr:panelNr, $
		lastPanelDrawn:-1}
      WIDGET_CONTROL, Slice_Base, /REALIZE
      XMANAGER, 'USER_multiple_Horiz_Slices_noaa_overview', Slice_Base
   ENDIF
   thisPlot=widgetData.plotsDrawn(panelNr)

;--- now, we need to get the data --------------------------------------------
;    but we will only read the data, if the panel the user clicked is not the
;    panel that he last clicked into (in this case, the data is already read).
;    also check the ISREAD common, data might not need to be read again
;    anyway!
   IF sliceWidgetData.lastPanelDrawn NE panelNr THEN BEGIN
     result=strpos(plot_types,strchminus(thisPlot.panelKind),0)
     typeindex=where(result eq 0,count)
     IF count ne 0 then BEGIN ; plot_type is add-in, check the ISREAD array
      IF IsReadArr(typeindex(0)) ne 1 then BEGIN
        print, 'I need to read the data:'
	print,widgetData.plotsDrawn(panelNr).get_data_call
        WIDGET_CONTROL,/HOURGLASS
        IF NOT EXECUTE(widgetData.plotsDrawn(panelNr).get_data_call) THEN BEGIN
         dummy=messageBox(['Sorry, there seems to be an error',$
                           'I cannot read the data for the panel.'], ['Ok'])
         RETURN
        ENDIF
      ENDIF
     ENDIF
   ENDIF
   sliceWidgetData.lastPanelDrawn = panelNr

;--- prepare the drawing widget for plotting ----------------------------------
   PAPCO_SET_PLOT, 'X'
   WIDGET_CONTROL, sliceWidgetData.dw_slice,  GET_VALUE=drawIndex
   WSET, drawIndex

;--- store the current coordinate system --------------------------------------
   old_x = !x
   old_y = !y
   old_p = !p

; ---  Call add-in routine for slice  -----------------------------------------

   sliceWidgetData.slice_call='plot_save_noaa_overview_Horiz_slice,' +  string(panelNr)
   plot_noaa_overview_Horiz_slice, panelNr, seconds, yValue


; these two info strings are user-definable output strings to label the slice 
; window. To calculate the time use the start time in mjdt and the seconds 
; passed in. If your plot uses the papco philosophy then the time axis is in 
; running seconds since the start of the start day.
;
; However, you of course can use your own time format, then the information
; in seconds is whatever your time format is. papco provides a function
; to return a verbose time for ANY time format.    
; papco always knows the start end time of a plot from the time common
; block, and the start/end value of the x_axis shouldalways be stored in 
; papco by the user's plot routine:;
;
;   common coordinateSystems, plotted_x, plotted_y  
;
;   plotted_x = !x
;   plotted_y = !y     -   after the user has set up his axis.
;
; If this is done properly then the call
;   
;   time_str=papco_cursor_time(seconds,panelNr)
;   
; should return the correct time.
   
   time_str=papco_cursor_time(seconds,panelNr)
   time_mjdt=papco_cursor_time(seconds,panelNr,/mjdt)
   
   info1=input_header.comment1+' '+input_header.comment2
   info2=string(time_str, yValue, $
        format="('time: ',A20,'   Y-value: ',f9.2)")

; Replace these labels and include your plot! 

; user defined routine for plotting the slice included here. An example is in 
; $papco_MODULES/noaa_MEB/papco_interface/noaa_slices.pro
; You typically need to include the commons from the read routine, a way
; of finding the index of the data you want to plot using the time "seconds"
; plus a simple plot statement to plot the data.
; Two strings, info1 and info2, can be used to annotate the slice window
; by providing additional information, ie ephemeris data, etc.

; these calls put your info strings in the provided labels of the slice widget

   WIDGET_CONTROL, sliceWidgetData.lbl_slice1, SET_VALUE=info1
   WIDGET_CONTROL, sliceWidgetData.lbl_slice2, SET_VALUE=info2

   jumpslice:

; --- restore the coordinate-system -------------------------------------------
   !x = old_x
   !y = old_y
   !p = old_p

END
;******************************************************************************
;* PROCEDURE:
;*      PRO papco_DrawSlice_Event, Event
;*
;* DESCRIPTION:
;*	The slice-window displays a slice through the data,
;*	when the user clicks in the drawing-widget.
;*	This procedure handles events for that window.
;* INPUTS:
;*	Event	 	an XMANAGER-event
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:
;*      June 1998 by S. BOURDARIE
;*      September 1999 by S. BOURDARIE
;******************************************************************************
PRO USER_multiple_Horiz_Slices_noaa_overview_Event, Event

  COMMON papco_DRAWSLICE, sliceWidgetData
  COMMON PLOT_COMPOSER, widgetData
   common USER_multiple_Horiz_Slices_noaa_overview_info, noaa_overview_panelNr, noaa_overview_seconds, noaa_overview_yValue
   common USER_multiple_Horiz_Slices_noaa_overview, IdColor,oldpanel,xyoutIndex,clear_slice
   common USER_multiple_Horiz_Slices_noaa_overview_bis,remindyIndex,save_y_str




  WIDGET_CONTROL,Event.Id,GET_UVALUE=Ev
  CASE Ev OF
     'pb_done' : BEGIN
        WIDGET_CONTROL, sliceWidgetData.base, /DESTROY
        oldpanel = -1
     END

     'pb_help': $
       xdisplayfile, papco_module_helpfile('papco_noaa_overview_slice.help'), $
       title='papco Online-Help', group=event.top
     'pb_clear': BEGIN
       WIDGET_CONTROL, sliceWidgetData.dw_slice,  GET_VALUE=drawIndex
       WSET, drawIndex
       erase,0
       if clear_slice ne 2 then begin
          xyoutIndex = 0.
          aux = remindyIndex(0)
          remindyIndex = aux
          aux = save_y_str
          save_y_str = aux
       endif
     END
    'pb_print': BEGIN
       papco_PrintMenu_Event,sliceWidgetData.slice_call
     END
     'pb_mulPlot': BEGIN
       clear_slice = 0
     END
     'pb_onePlot': BEGIN
        clear_slice =1
     END
     ELSE : BEGIN
     END
   ENDCASE

END

;*********************************************************************
; plot routine
;
;*      June 1998 by S. BOURDARIE
;*      September 1999 by S. BOURDARIE
;*********************************************************************
pro plot_noaa_overview_Horiz_slice, panelNr, seconds, yValue

   COMMON PAPCO_DRAWSLICE, sliceWidgetData
   COMMON PLOT_COMPOSER, widgetData

   common noaa_overview_data, input_header, input_data
   common mjdt, mjdt_start, mjdt_end    ;common time limit in mjdt
   common USER_multiple_Horiz_Slices_noaa_overview, IdColor,oldpanel,xyoutIndex,clear_slice
   common USER_multiple_Horiz_Slices_noaa_overview_bis,remindyIndex,save_y_str
   common shift_label, down             ;common for x-axis label shifting

 COMMON papco_color_names, black, red, green, yellow, blue, magenta, cyan, $
  white, burgundy, olive, dark_green, teal, $
  royal_blue, violet, dark_grey, grey

; make color array
  couleur_arr = [black, red, green, yellow, blue, magenta, cyan, $
  white, burgundy, olive, dark_green, teal, $
  royal_blue, violet, dark_grey, grey]

    if clear_slice then begin
       erase,0
       xyoutIndex = 0.
       aux = remindyIndex(0)
       remindyIndex = aux
       aux = save_y_str
       save_y_str = aux
       IdColor = -1
    endif else clear_slice = 0

    time=input_data.time           ; dummy, remove once your own is here

   WIDGET_CONTROL,/HOURGLASS
   thisPlot=widgetData.plotsDrawn(panelNr)

Isread = strpos(widgetData.plotInfos(panelNr).filename,'done')
if Isread eq -1 then oldpanel = -1


; use the same typevector, switch etc as is used in the call to your plot
; routine. thisPlot contains the full papco structure of plot information for
; the panel in which the mouse was clicked in. 

   thisPlot=widgetData.plotsDrawn(panelNr)
   info = widgetData.PLOTINFOS(panelNr)

   type=thisPlot.typeVector

; set the panel window for the slice to full window

   !p.position=[0.15,0.1,0.72,0.9]

; select the index for the yvalue chosen out of the ymat

   yminarr=input_header.yarr(0:n_elements(input_header.yarr)-2)
   ymaxarr=input_header.yarr(1:n_elements(input_header.yarr)-1)
   result = where(ymaxarr ge yValue)
   yIndex = result(0)

   uytit=input_header.unit

if panelNr ne oldpanel then begin
      erase,0
      oldpanel = panelNr
      IdColor = -1
      remindyIndex = yIndex
      save_y_str=string(yminarr(yIndex+1),ymaxarr(yIndex+1),format="(f7.2,' - ',f7.2)")

      xyoutIndex = 0.

      widgetData.plotInfos(panelNr).filename =widgetData.plotInfos(panelNr).filename+'done'
endif
   IdColor = IdColor +1
   if IdColor gt n_elements(couleur_arr) then IdColor = 0
   if IdColor eq 7 then IdColor = 8

   yray = input_data(*).ymat(yIndex)

   remindyIndex = [remindyIndex,yIndex]
   y_str=string(yminarr(yIndex),ymaxarr(yIndex),format="(f7.2,' - ',f7.2)")
   save_y_str=[save_y_str,y_str]
   xyoutIndex = xyoutIndex+0.03

; plot routine
; HERE z is in fact y and y is x (use the same notation as in p_noaa_overview_lav.pro)
;
   zmin=thisPlot.zscl_min
   zmax=10.*(thisPlot.zscl_max)
   xmin=float(mjdt_start.mjd) + mjdt_start.t / 86400.0 
   xmax=float(mjdt_end.mjd) + mjdt_end.t / 86400.0

;   print,max(yray),zmax

   down = 0
   plot,time,yray,$
          position=!p.position,$
          xrange=[xmin,xmax],yrange=[zmin,zmax],$
          xstyle = 9,ystyle = 9,$
          xtickformat='mjd_dec_2',$
          xticks=4,$
          ytitle = 'Flux '+uytit,/YLOG,/nodata,color=2

   down = 1
   plot,time,yray,$
          position=!p.position,$
          xrange=[xmin,xmax],yrange=[zmin,zmax],$
          xstyle = 9,ystyle = 9,$
          xtickformat='mjd_dec_1',$
          xticks=4,$
          ytitle = 'Flux '+uytit,/YLOG,/nodata,color=2
   xyouts,0.80,0.06,'time (UT)!CDate',color=2,/normal

   plots,time(0),yray(0)
   for i=1,n_elements(time)-1 do begin
       plots,time(i),yray(i),/continue,noclip=0,color=couleur_arr(IdColor)
    endfor 

; write info into plot window
   time_str=papco_cursor_time(seconds,panelNr)
   
   info1=string(y_str, format="(A20)")
   info1 = strtrim(info1,2)
   info2=input_header.comment1+' '+input_header.comment2

   xyouts,0.72,0.9-xyoutIndex,info1,color=couleur_arr(IdColor),/normal
   xyouts,0.2,0.95,info2,color=2,/normal
      
end

;*********************************************************************
; plot routine for printing 
; This routine is designed to plot all selected slices since the last 
; clear click
;
; Written Jne 1998 by S. BOURDARIE
; Revised September 1999 by S. BOURDARIE
;*********************************************************************
pro plot_save_noaa_overview_Horiz_slice, panelNr

   COMMON PLOT_COMPOSER, widgetData

   common noaa_overview_data, input_header, input_data
   common USER_multiple_Horiz_Slices_noaa_overview_bis,remindyIndex,save_y_str
   common mjdt, mjdt_start, mjdt_end    ;common time limit in mjdt
   common shift_label, down             ;common for x-axis label shifting

COMMON papco_color_names, black, red, green, yellow, blue, magenta, cyan, $
  white, burgundy, olive, dark_green, teal, $
  royal_blue, violet, dark_grey, grey


; make color array
  couleur_arr = [black, red, green, yellow, blue, magenta, cyan, $
  white, burgundy, olive, dark_green, teal, $
  royal_blue, violet, dark_grey, grey]

    time=input_data.time           ; dummy, remove once your own is here

; use the same typevector, switch etc as is used in the call to your plot
; routine. thisPlot contains the full papco structure of plot information for
; the panel in which the mouse was clicked in. 

   thisPlot=widgetData.plotsDrawn(panelNr)
   info = widgetData.PLOTINFOS(panelNr)

   type=thisPlot.typeVector

  uytit=input_header.unit

; set the panel window for the slice to full window

   !p.position=[0.15,0.1,0.72,0.9]
   IdColor = -1
   xyoutIndex = 0.
   zmin=thisPlot.zscl_min
   zmax=10.*(thisPlot.zscl_max)
   xmin=float(mjdt_start.mjd) + mjdt_start.t / 86400.0 
   xmax=float(mjdt_end.mjd) + mjdt_end.t / 86400.0

    yray = input_data(*).ymat(remindyIndex(0))

   down = 0
   plot,time,yray,$
          position=!p.position,$
          xrange=[xmin,xmax],yrange=[zmin,zmax],$
          xstyle = 9,ystyle = 9,$
          xtickformat='mjd_dec_2',$
          xticks=4,$
          ytitle = 'Flux '+uytit,/YLOG,/nodata,color=2

   down = 1
   plot,time,yray,$
          position=!p.position,$
          xrange=[xmin,xmax],yrange=[zmin,zmax],$
          xstyle = 9,ystyle = 9,$
          xtickformat='mjd_dec_1',$
          xticks = 4,$
          ytitle = 'Flux '+uytit,/YLOG,/nodata,color=2
   xyouts,0.80,0.06,'time (UT)!CDate',color=2,/normal

   for yIndex=1,n_elements(remindyIndex)-1 do begin
      IdColor = IdColor + 1
      xyoutIndex = xyoutIndex+0.03
      if IdColor gt n_elements(couleur_arr) then IdColor = 0
      if IdColor eq 7 then IdColor = 8

      yray = input_data(*).ymat(remindyIndex(yIndex))

      plots,time(0),yray(0)
      for i=1,n_elements(time)-1 do begin
          plots,time(i),yray(i),/continue,noclip=0,color=couleur_arr(IdColor)
      endfor 

   info1=string(save_y_str(yIndex), format="(A20)")
   info1 = strtrim(info1,2)
   info2=input_header.comment1+' '+input_header.comment2
   xyouts,0.72,0.9-xyoutIndex,info1,color=couleur_arr(IdColor),/normal
   xyouts,0.2,0.95,info2,color=2,/normal
   endfor

end
