;******************************************************************************
;* PROCEDURE:     
;*      PRO DrawSlice_noaa_overview_flux, panelNr, seconds, yValue
;* 
;* DESCRIPTION:  
;*      Draw a slice for noaa_overview_flux
;*      calling a separate window for the plot.
;*      slice_type in draw_noaa_overview_flux must be set to +2 to enable this feature.
;*
;* INPUTS:       
;*      panelNr     an integer, the number of the panel for which the slice 
;*                  is to be drawn
;*      seconds     time of mouse click, a float
;*      yvalue      y-value of mouse click, a float
;*      
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      called by papco_DrawSLice (in $papco_PATH/papco_cursor.pro)
;*
;* MODIFICATION HISTORY:       
;*      June 1998 by S. BOURDARIE
;*      September 1999 by S. BOURDARIE
;******************************************************************************
PRO USER_ISOMAP_noaa_overview, panelNr, seconds, yValue, CLOSE=CLOSE,READDATA=READDATA

   common noaa_overview_data, input_header, input_data
   COMMON PAPCO_DRAWSLICE, sliceWidgetData
   COMMON PLOT_COMPOSER, widgetData
   COMMON ADDINS, plot_types
   COMMON ISREAD, IsReadArr

   common mjdt, mjdt_start, mjdt_end    ;common time limit in mjdt
   common USER_ISOMAP_noaa_overview_info, noaa_overview_panelNr, noaa_overview_seconds, noaa_overview_yValue
   common USER_ISOMAP_noaa_overview, IdColor,xyoutIndex

noaa_overview_panelNr = panelNr
noaa_overview_seconds = seconds
noaa_overview_yValue = yValue


;-- close the window ? --------------------------------------------------------
    IF XREGISTERED('USER_multiple_Vert_Slices_noaa_overview') THEN $
         IF N_ELEMENTS(sliceWidgetData) GT 0 THEN BEGIN
	    IF sliceWidgetData.base NE 0 THEN $
  	       WIDGET_CONTROL, sliceWidgetData.base, /DESTROY
            sliceWidgetData.base=0
         ENDIF
   IF KEYWORD_SET(CLOSE) THEN BEGIN
      IF XREGISTERED('USER_ISOMAP_noaa_overview') THEN $
         IF N_ELEMENTS(sliceWidgetData) GT 0 THEN BEGIN
	    IF sliceWidgetData.base NE 0 THEN $
  	       WIDGET_CONTROL, sliceWidgetData.base, /DESTROY
            sliceWidgetData.base=0
         ENDIF
      RETURN
   ENDIF
;-- if the window exists, bring it in front. Else, create it ------------------
   IF NOT XREGISTERED('USER_ISOMAP_noaa_overview') THEN BEGIN
      Slice_Base=WIDGET_BASE(COLUMN=1, $
		GROUP=widgetData.main_base, $
		title='USER ISO MAP')
;-- setup draw area -----------------------------------------------------------
      draw_base=WIDGET_BASE(Slice_base, COLUMN=1, /FRAME)
      dw_Slice  =WIDGET_DRAW(draw_base, XSIZE=500, YSIZE=500)

;-- set up label fields for user data -----------------------------------------
      user_label_base=WIDGET_BASE(slice_base, COLUMN=1, /FRAME)
      lbl_slice1=WIDGET_LABEL(user_label_base,VALUE=strcenter('uservalues',80))
      lbl_slice2=WIDGET_LABEL(user_label_base,VALUE=strcenter('uservalues',80))
;-- set up buttons for the Actions --------------------------------------------
      Butt_Base=WIDGET_BASE(Slice_Base, ROW=2, /FRAME)
      pb_help=WIDGET_BUTTON(Butt_Base, $
                              Value=strcenter('Help', 12), $
			      UVALUE='pb_help')
      pb_print=WIDGET_BUTTON(Butt_Base, $
                             Value=strcenter('Print', 12), $
                             UVALUE='pb_print')
      pb_done=WIDGET_BUTTON(Butt_Base, $
                              Value=strcenter('Close', 12), $
			      UVALUE='pb_done')
      Icn=cw_field(Butt_Base,value='6',title=' Iso contour number : ',xsize=3,/int)
      dummy=widget_label(Butt_Base,value=' Style : ')
      button_child=widget_base(Butt_Base,/ROW,/EXCLUSIVE)
      IsoCol=widget_button(button_child,value='Iso contour + Color',uvalue='IsoCol')
      Iso=widget_button(button_child,value='Iso contour',uvalue='Iso')
      Col=widget_button(button_child,value='Color',uvalue='Col')
      widget_control,IsoCol,/SET_BUTTON



      sliceWidgetData={ $
		base:slice_base, $
	        dw_slice:dw_slice, $
		lbl_slice1:lbl_slice1, $
		lbl_slice2:lbl_slice2, $
                slice_call:'', $
	        panelNr:panelNr, $
                Icn:6     , $
                IsoCol:0  , $
		BIcn:Icn,$
		BIsoCol:IsoCol,$
		BIso:Iso}
      WIDGET_CONTROL, Slice_Base, /REALIZE
      XMANAGER, 'USER_ISOMAP_noaa_overview', Slice_Base
   ENDIF
   thisPlot=widgetData.plotsDrawn(panelNr)


;--- prepare the drawing widget for plotting ----------------------------------
   PAPCO_SET_PLOT, 'X'
   WIDGET_CONTROL, sliceWidgetData.dw_slice,  GET_VALUE=drawIndex
   WSET, drawIndex

;--- store the current coordinate system --------------------------------------
   old_x = !x
   old_y = !y
   old_p = !p

; ---  Call add-in routine for slice  -----------------------------------------



; these two info strings are user-definable output strings to label the slice 
; window. To calculate the time use the start time in mjdt and the seconds 
; passed in. If your plot uses the papco philosophy then the time axis is in 
; running seconds since the start of the start day.
;
; However, you of course can use your own time format, then the information
; in seconds is whatever your time format is. papco provides a function
; to return a verbose time for ANY time format.    
; papco always knows the start end time of a plot from the time common
; block, and the start/end value of the x_axis shouldalways be stored in 
; papco by the user's plot routine:;
;
;   common coordinateSystems, plotted_x, plotted_y  
;
;   plotted_x = !x
;   plotted_y = !y     -   after the user has set up his axis.
;
; If this is done properly then the call
;   
;   time_str=papco_cursor_time(seconds,panelNr)
;   
; should return the correct time.
   
   time_str=papco_cursor_time(seconds,panelNr)
   time_mjdt=papco_cursor_time(seconds,panelNr,/mjdt)
   
;--- now, we need to get the data --------------------------------------------
   sliceWidgetData.slice_call='plot_noaa_overview_isomap,' +  string(panelNr)

   read_noaa_isofile,time_mjdt,widgetData.plotInfos(panelNr).filename,$
                               widgetData.plotInfos(panelNr).typeVector(0)
   plot_noaa_overview_isomap, panelNr, seconds, yValue


   info1=input_header.comment1+' '+input_header.comment2
   info2=string(time_str, yValue, $
        format="('time: ',A20,'   Y-value: ',f9.2)")

; Replace these labels and include your plot! 

; user defined routine for plotting the slice included here. An example is in 
; $papco_MODULES/noaa_MEB/papco_interface/noaa_slices.pro
; You typically need to include the commons from the read routine, a way
; of finding the index of the data you want to plot using the time "seconds"
; plus a simple plot statement to plot the data.
; Two strings, info1 and info2, can be used to annotate the slice window
; by providing additional information, ie ephemeris data, etc.

; these calls put your info strings in the provided labels of the slice widget

   WIDGET_CONTROL, sliceWidgetData.lbl_slice1, SET_VALUE=info1
   WIDGET_CONTROL, sliceWidgetData.lbl_slice2, SET_VALUE=info2

   jumpslice:

; --- restore the coordinate-system -------------------------------------------
   !x = old_x
   !y = old_y
   !p = old_p

END
;******************************************************************************
;* PROCEDURE:
;*      PRO papco_DrawSlice_Event, Event
;*
;* DESCRIPTION:
;*	The slice-window displays a slice through the data,
;*	when the user clicks in the drawing-widget.
;*	This procedure handles events for that window.
;* INPUTS:
;*	Event	 	an XMANAGER-event
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:
;*      June 1998 by S. BOURDARIE
;*      September 1999 by S. BOURDARIE
;******************************************************************************
PRO USER_ISOMAP_noaa_overview_Event, Event

  COMMON papco_DRAWSLICE, sliceWidgetData
  COMMON PLOT_COMPOSER, widgetData
   common USER_ISOMAP_noaa_overview_info, noaa_overview_panelNr, noaa_overview_seconds, noaa_overview_yValue
   common USER_ISOMAP_noaa_overview, IdColor,xyoutIndex
   common USER_ISOMAP_noaa_overview_bis,remindyIndex,save_y_str




  WIDGET_CONTROL,Event.Id,GET_UVALUE=Ev
  CASE Ev OF
     'pb_done' : BEGIN
        WIDGET_CONTROL, sliceWidgetData.base, /DESTROY
     END

     'pb_help': $
       xdisplayfile, papco_module_helpfile('papco_noaa_overview_slice.help'), $
       title='papco Online-Help', group=event.top
    'pb_print': BEGIN
       papco_PrintMenu_Event,sliceWidgetData.slice_call
     END
    'IsoCol':      sliceWidgetData.IsoCol = 0
    'Iso':         sliceWidgetData.IsoCol = 1
    'Col':         sliceWidgetData.IsoCol = 2
     ELSE : BEGIN
     END
   ENDCASE

END

;*********************************************************************
; plot routine
;
;*      June 1998 by S. BOURDARIE
;*      September 1999 by S. BOURDARIE
;*********************************************************************
pro plot_noaa_overview_isomap, panelNr, seconds, yValue

   COMMON PAPCO_DRAWSLICE, sliceWidgetData
   COMMON PLOT_COMPOSER, widgetData

   common noaa_iso_data, input_header, input_data
   common mjdt, mjdt_start, mjdt_end    ;common time limit in mjdt
   common USER_ISOMAP_noaa_overview, IdColor,xyoutIndex
   common USER_ISOMAP_noaa_overview_bis,remindyIndex,save_y_str
   common shift_label, down             ;common for x-axis label shifting

 COMMON papco_color, papco_color, r_papco, g_papco, b_papco 
 COMMON papco_color_names, black, red, green, yellow, blue, magenta, cyan, $
  white, burgundy, olive, dark_green, teal, $
  royal_blue, violet, dark_grey, grey

; make color array
  couleur_arr = [black, red, green, yellow, blue, magenta, cyan, $
  white, burgundy, olive, dark_green, teal, $
  royal_blue, violet, dark_grey, grey]



   WIDGET_CONTROL,/HOURGLASS


; use the same typevector, switch etc as is used in the call to your plot
; routine. thisPlot contains the full papco structure of plot information for
; the panel in which the mouse was clicked in. 

   thisPlot=widgetData.plotsDrawn(panelNr)
   info = widgetData.PLOTINFOS(panelNr)

   type=thisPlot.typeVector

; set the panel window for the slice to full window

   !p.position=[0.15,0.1,0.72,0.9]

; select the index for the yvalue chosen out of the ymat

erase,0
Xplot_size=700
Yplot_size=700
ydim = 0.35*Xplot_size

Xrec = FLTARR(4)
Yrec = FLTARR(4)

bleu  = couleur_arr(4)
jaune = couleur_arr(3)

if n_elements( papco_color ) gt 0 then begin
        cindex= where( papco_color(*,2) eq 1 ) ; search the active vector
        if (cindex(0) eq -1) then begin
            print, '% papco_plot_colorspec: Color system failure, '
            print, '  consult jbf@space-theory.physics.uiowa.edu'
            print, '  Using color set 0'
            cindex=0
        endif
        color_range= PAPCO_get_Colorindices( cindex )
endif else begin
        color_range= [0,!d.n_colors-1]
endelse
ncolors= color_range(1)-color_range(0)

widget_control,sliceWidgetData.BIcn,get_value=Icn
if Icn gt ncolors then Icn = ncolors
sliceWidgetData.Icn=Icn

   X1 = 0.10
   X2 = 0.80
   Y1 = 0.1
   Y2 = 0.1 + 0.35*Xplot_size/Yplot_size
   map_set,0,0,0,/cylindrical,/isotropic,/noborder,$
         position = [X1,Y1,X2,Y2]

;modifications pour idl V 5.0

   Xrec(0) = X1
   Xrec(1) = X2
   Xrec(2) = X2
   Xrec(3) = X1
   Yrec(0) = Y1
   Yrec(1) = Y1
   Yrec(2) = Y2
   Yrec(3) = Y2
   polyfill,Xrec,Yrec, color = bleu,/normal

;fin modif


   map_grid,color = black
   xyouts,X1-0.002,Y1-0.008,alignment=1,'-90',color=black,/normal
   xyouts,X1-0.002,Y1+(Y2-Y1)/6.-0.008,alignment=1,'-60',color=black,/normal
   xyouts,X1-0.002,Y1+(Y2-Y1)/3.-0.008,alignment=1,'-30',color=black,/normal
   xyouts,X1-0.002,(Y2+Y1)/2.-0.008,alignment=1,'0',color=black,/normal
   xyouts,X1-0.002,Y1+2.*(Y2-Y1)/3.-0.008,alignment=1,'30',color=black,/normal
   xyouts,X1-0.002,Y1+5.*(Y2-Y1)/6.-0.008,alignment=1,'60',color=black,/normal
   xyouts,X1-0.002,Y2-0.008,alignment=1,'90',color=black,/normal

   lon0 =  - 180.
   PasLon = 45.
   lon = fltarr(9)
   longi = strarr(9)
   for i=0,8 do lon(i) = lon0 + i*PasLon   ;format='(i4.4)')
   for i=0,8 do begin
       if lon(i) le -100. then longi(i) ='-'+string(ABS(lon(i)),format='(i3.3)')
       if lon(i) gt -100. and lon(i) le -10. then longi(i) ='-'+string(ABS(lon(i)),format='(i2.2)')
       if lon(i) gt -10. and lon(i) lt 0. then longi(i) ='-'+string(ABS(lon(i)),format='(i1.1)')
       if lon(i) ge 0. and lon(i) lt 10. then longi(i) =string(ABS(lon(i)),format='(i1.1)')
       if lon(i) ge 10. and lon(i) lt 100. then longi(i) =string(ABS(lon(i)),format='(i2.2)')
       if lon(i) ge 100.then longi(i) =string(ABS(lon(i)),format='(i3.3)')
   endfor
       
   xyouts,X1,Y1-0.04,alignment=0.5,longi(0),color=black,/normal
   xyouts,X1+(X2-X1)/8.,Y1-0.04,alignment=0.5,longi(1),color=black,/normal
   xyouts,X1+2.*(X2-X1)/8.,Y1-0.04,alignment=0.5,longi(2),color=black,/normal
   xyouts,X1+3.*(X2-X1)/8.,Y1-0.04,alignment=0.5,longi(3),color=black,/normal
   xyouts,X1+4.*(X2-X1)/8.,Y1-0.04,alignment=0.5,longi(4),color=black,/normal
   xyouts,X1+5.*(X2-X1)/8.,Y1-0.04,alignment=0.5,longi(5),color=black,/normal
   xyouts,X1+6.*(X2-X1)/8.,Y1-0.04,alignment=0.5,longi(6),color=black,/normal
   xyouts,X1+7.*(X2-X1)/8.,Y1-0.04,alignment=0.5,longi(7),color=black,/normal
   xyouts,X2,Y1-0.04,alignment=0.5,longi(8),color=black,/normal
   

   map_continents,/fill_continents,color=jaune
   
   max_color = sliceWidgetData.Icn

   lev = fltarr(max_color)
   iso_col = intarr(max_color-1)
   
   
   if thisPlot.zlinlog eq 1 then begin
      PasA = (ALOG(thisPlot.zscl_max)-ALOG(thisPlot.zscl_min))/max_color
      for I=0,max_color-1 do lev(i) = thisPlot.zscl_min*exp((i+1)*PasA)
   endif else begin
      PasA = (thisPlot.zscl_max-thisPlot.zscl_min)/max_color
      for I=0,max_color-1 do lev(i) = thisPlot.zscl_min + (i+1)*PasA
   endelse
   FOR I=1,max_color-1 do print,'level ',i,' : ',lev(I)
   label_lev = intarr(max_color)
   for I=1,max_color-1,2 do label_lev(i) = 1

   for I=1,max_color-1 do begin
      iso_col(I-1) = papco_Get_subtable_index([thisPlot.zscl_min,thisPlot.zscl_max],lev(i),$
                                             LOG=thisPlot.zlinlog)
   endfor
   
   if sliceWidgetData.IsoCol eq 0 then begin
      contour,input_data.ymat,input_header.lon,input_header.lat,$
       NLEVELS=sliceWidgetData.Icn-1,levels=lev(1:sliceWidgetData.Icn-1),$
        /overplot,/closed,/noerase,/cell_fill,c_color = iso_col

       for i=0,sliceWidgetData.Icn-2 do begin
          Xrec = [X2+0.02,X2+0.05,X2+0.05,X2+0.02]
          Yrec = [Y2-i*0.03,Y2-i*0.03,Y2-i*0.03-0.015,Y2-i*0.03-0.015]
          polyfill,Xrec,Yrec, color = iso_col(i),/normal
          xyouts,X2+0.06,Y2-i*0.03-0.013,'> '+strtrim(string(lev(i+1)),2),color=black,/normal,charsize=0.6
       endfor
       map_continents,color=blanc
   endif

   if sliceWidgetData.IsoCol eq 2 then begin
      contour,input_data.ymat,input_header.lon,input_header.lat,$
       NLEVELS=sliceWidgetData.Icn-1,levels=lev(1:sliceWidgetData.Icn-1),$
        /overplot,/closed,/noerase,/cell_fill,c_color = iso_col

       for i=0,sliceWidgetData.Icn-2 do begin
          Xrec = [X2+0.02,X2+0.05,X2+0.05,X2+0.02]
          Yrec = [Y2-i*0.03,Y2-i*0.03,Y2-i*0.03-0.015,Y2-i*0.03-0.015]
          polyfill,Xrec,Yrec, color = iso_col(i),/normal
          xyouts,X2+0.06,Y2-i*0.03-0.013,'> '+strtrim(string(lev(i+1)),2),color=black,/normal,charsize=0.6
       endfor
       map_continents,color=blanc
   endif

   if sliceWidgetData.IsoCol eq 3 then begin
      contour,input_data.ymat,input_header.lon,input_header.lat,$
       NLEVELS=max_color-1,levels=lev(1:max_color-1),$
        /overplot,/closed,/noerase,/cell_fill,c_color = iso_col

       map_continents,color=blanc

      b = bytarr(20,ydim)
      for i=0,ydim-1 do b(*,i)=i*(!D.N_COLORS-2.)/(ydim-1.)
      tv,b,0.85,0.15,xsize=0.03,ysize=Y2-Y1,/normal
      lx=[0,1]
      ly=[thisPlot.zscl_min,thisPlot.zscl_max]
      posit = [0.85,0.15,0.85+20./Xplot_size,0.15+float(ydim)/Yplot_size]
      if thisPlot.zlinlog eq 0 then begin
         plot_io,lx,ly,position=posit,color=black,$
         xrange=[0.,1.],yrange=[thisPlot.zscl_min,thisPlot.zscl_max],$
         xstyle = 5,ystyle = 5,/nodata,/noerase,/normal
         axis, yaxis = 1,ystyle = 1,yticklen = -0.6,/ylog,color = black,/normal
      endif else begin
         plot,lx,ly,position=posit,color=black,$
         xrange=[0.,1.],yrange=[thisPlot.zscl_min,thisPlot.zscl_max],$
         xstyle = 5,ystyle = 5,/nodata,/noerase,/normal
         axis, yaxis = 1,ystyle = 1,yticklen = -0.6,color = black,/normal
      endelse
   endif
   
   if sliceWidgetData.IsoCol lt 2 then $
      contour,input_data.ymat,input_header.lon,input_header.lat,$
         NLEVELS=sliceWidgetData.Icn-1,levels=lev(1:sliceWidgetData.Icn-1),c_labels=label_lev,$
         /overplot,/noerase,c_color = black

endf:
xyouts,0.5,0.97,alignment=0.5,input_header.titre,color=black,/normal
xyouts,0.5,0.94,alignment=0,input_header.com(0),color=black,/normal
xyouts,0.5,0.91,alignment=0,input_header.com(1),color=black,/normal
xyouts,0.5,0.88,alignment=0,input_header.com(2),color=black,/normal
xyouts,0.5,0.85,alignment=0,input_header.com(3),color=black,/normal
xyouts,0.1,0.91,alignment=0,input_header.com(4),color=black,/normal
end




pro read_noaa_isofile,time,sat,channel

common noaa_iso_data, input_header, input_data

data_dir='NOAA_DATA'
path=getenv(data_dir)

convert_t90_to_date, time, year, day_oy, hour, minute, second,$
                          month, cmonth, day_om, /mjdt   

canal = ['0P1','0P2','0P3','0P4','0P5','0E1','0E2','0E3' $
        ,'90P1','90P2','90P3','90P4','90P5','90E1','90E2','90E3' $
	,'P6','P7','P8']

result = strpos(sat,'done')
if result eq -1 then sat = sat else sat = strmid(sat,0,result)


fln=path+sat+'/sem/'+string(year,format='(i4.4)')+'/iso/'+canal(channel)+$
   '_'+string(month,format='(i2.2)')+'.iso.gz'
openr,iunit,fln,/get_lun,/compress

titre = STRARR(1)
xtitre = STRARR(1)
ytitre = STRARR(1)
com1 = STRARR(1)
com2 = STRARR(1)
com3 = STRARR(1)
com4 = STRARR(1)
com5 = STRARR(1)
Nval = INTARR(2)

c2 = STRARR(1)
c22 = STRARR(1)
UT = fltarr(1)

READF,iunit,titre
READF,iunit,com1
READF,iunit,format='(A8,F6.0,A3)',c2,UT,c22
ut = float(ut(0))
hour = long(UT)/3600
minute = long(UT-3600*hour)/60
sec = UT mod 60
com2 = c2+string(hour,minute,sec,format = "(i2.2,':',i2.2,':',i2.2)")+c22

rot_sol = -15*ut/3600. + 270.
modul = floor(rot_sol/360.)
rot_sol = rot_sol-modul*360.
if (rot_sol gt 180.) then rot_sol = rot_sol - 360.

READF,iunit,com3
READF,iunit,com4
READF,iunit,com5
READF,iunit,langue
READF,iunit,xtitre
READF,iunit,ytitre
READF,iunit,Nval
val = FLTARR(Nval(0),Nval(1))
READF,iunit,val

;calcul des longi et lati
lat = fltarr(Nval(1))
lon = fltarr(Nval(0))


LATmin =  -90.
LATmax =   90.
LONmin = - 180.
LONmax =   180.

PasLAT = (LATmax - LATmin)/(Nval(1)-1)
PasLON = (LONmax - LONmin)/(Nval(0)-1)

for I = 1,Nval(1) do lat(I-1) = (I-1.)*PasLAT + LATmin
for I = 1,Nval(0) do lon(I-1) = (I-1.)*PasLON + LONmin

; define the header and data structures. Edit to suit your data!
;
   input_header={lat:lat,$
                 lon:lon,$
                 titre:titre, $
                 com:strarr(5),$
                 xtitre:xtitre,$
                 ytitre:ytitre,$
                 rot_sol:rot_sol}

   input_data={ymat:val}

   input_header.com(0) = com1
   input_header.com(1) = com2
   input_header.com(2) = com3
   input_header.com(3) = com4
   input_header.com(4) = com5

close,iunit
free_lun,iunit

end
