;***************************************************************************
;* 
;* PROCEDURE:     
;*      FUNCTION noaa_satlist
;* 
;* DESCRIPTION:  
;*      for the given time period return a list of available 
;*      Goes satellite ID's 
;* 
;* INPUTS:       
;*      none
;* 
;* KEYWORDS:
;*      none
;*      
;* OUTPUT: 
;*      A string array of satellite id's eg GOES 07
;* 
;* CALLING SEQUENCE:
;*      result=goes_satlist
;*
;* MODIFICATION HISTORY:       
;*      october 1995, written by R. Friedel
;*      January 1997, to allow MJDT format time only
;***************************************************************************
FUNCTION noaa_satlist

COMMON PLOT_COMPOSER, widgetData

   xut1=widgetData.startTime
   xut2=widgetData.endTime

;get the number of LANL satellite present in the database
path = getenv('NOAA_DATA')

; check for env. variable pointing to data directory
   if strlen(path) eq 0 then begin
      dummy=messagebox(['Environmental variable NOAA_DATA not set'],$
                           ['O.K,'], $
                           title='no data found')
      get_err_msg='Environmental variable NOAA_DATA not set'
      print,get_err_msg
      files = 'no sat. found'
      return,files
   endif
   
; check for existence of data directory
   res=findfile(path,count=cc)
   if cc eq 0 then begin
      dummy=messagebox(['Data directory '+path+' not found'],$
                           ['O.K,'], $
                           title='no data found')
      get_err_msg='Data directory '+path+' not found'
      print,get_err_msg
      files = 'no sat. found'
      return,files
   endif

result=findfile(path,count=tot)
index=where(strmid(result,0,5) eq 'NOAA_')
noaa_name = result(index)
;print,lanl_name
id_sat = intarr(n_elements(noaa_name))
id_sat(*) = -1

   for i=0,n_elements(noaa_name)-1 do begin
      count=0
      xut1=widgetData.startTime
      while xut1.mjd le widgetData.endTime.mjd do begin
         convert_t90_to_Date, xut1, year,doy,hr,min,sec,mon,cmon,dom, /mjdt

         fln =path+noaa_name(i)+'/sem/'+string(year,format="(i4.4)")+'/data/*' $
           +string(year,doy,format="(i4.4,i3.3)")+'.dat.gz'
;         print,fln
         found=findfile(fln,count=nfs)
         if nfs ne 0 then count=count+1
         if nfs eq 0 then begin
            xut1.mjd = xut1.mjd+1
         endif else goto,endloop1
      endwhile
   endloop1:   if count ge 1 then id_sat(i) = i
   endfor

index = where(id_sat ne -1,count)
if count ne 0 then begin
   files = noaa_name(index)
endif else begin
   files = 'no sat. found'
endelse


return,files

end


FUNCTION noaa_overview_satlist

COMMON PLOT_COMPOSER, widgetData

   xut1=widgetData.startTime
   xut2=widgetData.endTime

;get the number of LANL satellite present in the database
path = getenv('NOAA_DATA')

; check for env. variable pointing to data directory
   if strlen(path) eq 0 then begin
      dummy=messagebox(['Environmental variable NOAA_DATA not set'],$
                           ['O.K,'], $
                           title='no data found')
      get_err_msg='Environmental variable NOAA_DATA not set'
      print,get_err_msg
      files = 'no sat. found'
      return,files
   endif
   
; check for existence of data directory
   res=findfile(path,count=cc)
   if cc eq 0 then begin
      dummy=messagebox(['Data directory '+path+' not found'],$
                           ['O.K,'], $
                           title='no data found')
      get_err_msg='Data directory '+path+' not found'
      print,get_err_msg
      files = 'no sat. found'
      return,files
   endif
   




result=findfile(path,count=tot)
index=where(strmid(result,0,5) eq 'NOAA_')
noaa_name = result(index)
;print,lanl_name
id_sat = intarr(n_elements(noaa_name))
id_sat(*) = -1

   for i=0,n_elements(noaa_name)-1 do begin
      count=0
      xut1=widgetData.startTime
      convert_t90_to_Date, xut1, year_start,doy,hr,min,sec,mon,cmon,dom, /mjdt
      xut2=widgetData.endTime
      convert_t90_to_Date, xut2, year_end,doy,hr,min,sec,mon,cmon,dom, /mjdt
      year = year_start

      while year le year_end do begin
         fln =path+noaa_name(i)+'/sem/'+string(year,format="(i4.4)")+$
	 '/map/*.map.gz'
;         print,fln
         found=findfile(fln,count=nfs)
         if nfs ne 0 then count=count+1
         if nfs eq 0 then begin
            year = year+1
         endif else goto,endloop1
      endwhile
   endloop1:   if count ge 1 then id_sat(i) = i
   endfor

index = where(id_sat ne -1,count)
if count ne 0 then begin
   files = noaa_name(index)
endif else begin
   files = 'no sat. found'
endelse


return,files

end
