;routine to set up common blocks for papco_cdf
PRO papco_cdf_commons

COMMON papco_cdf, papco_cdf_control

;set up a structure for all the variables needed by the
;papco cdf module to control the behaviour of the module. This
;replaces the old use of "ioptions, options and soptions" tags of the
;plotinfo structure by a user defined structure which contains are
;descriptive and verbose tags for easier use.

;you can also set up defaults for the control structure here.

papco_cdf_control = {papco_cdf_control, $
  cdf_dir:0,     cdf_dir_info:'index into the list of cdf directories ' + $
                              'under PAPCO_CDF_DATA', $
  var_list:0,    var_list_info:'index into the list of variables', $
  clust_no:0,    clust_no_info:'Cluster spacecraft number, 0,1,2,3', $
  coord:2^3,     coord_info:'Multiple coordinate selec, bit-wise toggle. '+ $
                            '2^0 -> X, 2^1 -> Y, 2^2 -> Z, 2^3 -> Magnitude', $
  cdf_type:'',   cdf_type_info:'Name of the cdf type, '+ $
                               'subdir under PAPCO_CDF_DATA', $
  cdf_file:'',   cdf_file_info:'Sample cdf file name from cdf directory', $
  cdfvar_name:'',cdfvar_name_info:'CDF variable name selected', $
  smooth:0,      smooth_info:'# of data points to smooth along time axis', $
  scaling:0,     scaling_info:'Attempt autoscale in Y of data. ' + $
                              '0-use cdf scaling info; 1-autoscale', $
  label:0,       label_info:'Label position; 0: Inside, 1: Outside', $
  time_shift:0.0, shift_info:'+/- shift of timeseries, for L1 monitors etc'}

END
