;******************************************************************************
PRO get_cluster_aux, control, aux, time, SC_ID = SC_ID

COMMON mjdt, mjdt_start, mjdt_end     ;common time limit in mjdt
COMMON papco_cdf_data, cluster_aux_data
COMMON papco_cdf
COMMON get_error, get_err_no, get_err_msg  

IF papco_check_data_env('PAPCO_CDF_DATA', PATH = path) EQ 0 THEN BEGIN
    get_err_msg = 'Cannot get CLUSTER FGM data, PUM CDAcdf not loaded'
    message, get_err_msg, /cont
    get_err_no = 1 & return
ENDIF 

;set timerange requested in TAI
tai1=utc2tai({mjd:mjdt_start.mjd, time:mjdt_start.t*1000})
tai2=utc2tai({mjd:mjdt_end.mjd, time:mjdt_end.t*1000})    

IF keyword_set(SC_ID) THEN sc_str = string(SC_ID) ELSE $
  sc_str = string(control.sc_id+1, format = "(i1.1)")

;set up control structure for cdf module and load into plotinfo
new_plotinfo = papco_getplotinfostruct()
new_control = papco_cdf_control
cdf_type = 'Cluster_aux'
new_control.cdf_type = cdf_type
cdf_file = path + cdf_type + '/2000/cl_sp_aux_20001101_v01.cdf'
new_control.cdf_file = cdf_file 
cdfvar_name_1 = 'sc_at'+sc_str+'_lat__CL_SP_AUX'
cdfvar_name_2 = 'sc_at'+sc_str+'_long__CL_SP_AUX'

;two calls to r_papco_cdf for eacho ne of the variables

    cdfvar_name = cdfvar_name_1
    new_control.cdfvar_name = cdfvar_name
    new_plotinfo.USR_PTR1 = ptr_new(new_control)

    r_papco_cdf, new_plotinfo
    IF get_err_no NE 0 THEN return

    ;get data array
    pos = strpos(tag_names(cluster_aux_data),strupcase(cdfvar_name))
    idx = where(pos NE -1)
    spin_gse_lat = cluster_aux_data.(idx(0)).dat

    cdfvar_name = cdfvar_name_2
    new_control.cdfvar_name = cdfvar_name
    new_plotinfo.USR_PTR1 = ptr_new(new_control)

    r_papco_cdf, new_plotinfo
    IF get_err_no NE 0 THEN return

    ;get data array
    pos = strpos(tag_names(cluster_aux_data),strupcase(cdfvar_name))
    idx = where(pos NE -1)
    spin_gse_long = cluster_aux_data.(idx(0)).dat


;get time array
pos = strpos(tag_names(cluster_aux_data), 'EPOCH')
idx = where(pos NE -1)
epoch_time = cluster_aux_data.(idx(0)).dat

nodata = cluster_aux_data.(idx(0)).FILLVAL

r1 = TAI2UTC(tai1,/ext) & r2 = TAI2UTC(tai2,/ext)
CDF_EPOCH, ep_1, r1.year, r1.month, r1.day, $
  r1.hour, r1.minute, r1.second, /COMPUTE_EPOCH
CDF_EPOCH, ep_2, r2.year, r2.month, r2.day, $
  r2.hour, r2.minute, r2.second, /COMPUTE_EPOCH

index=where((epoch_time GE ep_1) AND (epoch_time LE ep_2 ),c)
aux_time=(epoch_time(index)-ep_1)/1000.0
;aux_time is now aux field data time in sec from zero, same as time array

aux = fltarr(n_elements(aux_time), 2)
aux(*, 0) = spin_gse_long(index)
aux(*, 1) = spin_gse_lat(index)

;make time array - time can either be 1 or 2D array
r = size(time, /st)
IF r.N_DIMENSIONS EQ 2 THEN data_time = (time(*, 0) + time(*, 1))/2.0 $
ELSE data_time = time

;smooth aux data first to data resolution. Smooth needs to take into
;account bad data flags!
sm = n_elements(aux_time)/n_elements(data_time)
IF sm GE 3 THEN FOR i = 0, 1 DO aux(*, i) = papco_smooth(aux(*, i), sm, NODATA = nodata)

;now interpolate aux data to data time, preseving bad data flags.
new_aux = fltarr(n_elements(data_time), 2)
FOR i = 0, 1 DO new_aux(*, i) = $
    papco_interpol(aux(*, i), aux_time, data_time, NODATA = nodata)

aux = temporary(new_aux)

END
