;******************************************************************************
PRO get_cluster_mag, control, mag_fgm, time, SC_ID = SC_ID, $
                     ORIG_TIME = ORIG_TIME

COMMON mjdt, mjdt_start, mjdt_end     ;common time limit in mjdt
COMMON papco_cdf_data, cluster_mfi_data
COMMON papco_cdf
COMMON get_error, get_err_no, get_err_msg

IF papco_check_data_env('PAPCO_CDF_DATA', PATH = path) EQ 0 THEN BEGIN
    get_err_msg = 'Cannot get CLUSTER FGM data, PUM CDAcdf not loaded'
    message, get_err_msg, /cont
    get_err_no = 1 & return
ENDIF 

;check if cdf_type corresponds to a directory under PAPCO_CDF_DATA. 
cdf_type = 'cluster_fgm'
IF NOT papco_finddir(path+cdf_type) THEN BEGIN 
    message, 'Cluster FGM cdf data is expected in subdirectory:', /info
    print, '  ', path+cdf_type
    print, '  ', 'please supply this directory or a link of this name'
    get_err_no = 2
    get_err_msg = 'Cluster FGM cdf data directory not found'
    return
ENDIF 

;set timerange requested in TAI
tai1=utc2tai({mjd:mjdt_start.mjd, time:mjdt_start.t*1000})
tai2=utc2tai({mjd:mjdt_end.mjd, time:mjdt_end.t*1000})    

IF keyword_set(SC_ID) THEN sc_str = string(SC_ID) ELSE $
  sc_str = string(control.sc_id+1, format = "(i1.1)")

;set up control structure for cdf module and load into plotinfo
new_plotinfo = papco_getplotinfostruct()
new_control = papco_cdf_control
new_control.cdf_type = cdf_type
cdf_file = path + cdf_type + '/2000/c' + sc_str + '_pp_fgm_20001101_v01.cdf'
new_control.cdf_file = cdf_file 
cdfvar_name = 'B_xyz_gse__C'+sc_str+'_PP_FGM'
new_control.cdfvar_name = cdfvar_name
new_plotinfo.USR_PTR1 = ptr_new(new_control)

r_papco_cdf, new_plotinfo
IF get_err_no NE 0 THEN return

;get time array
pos = strpos(tag_names(cluster_mfi_data), 'EPOCH')
idx = where(pos NE -1)
epoch_time = cluster_mfi_data.(idx(0)).dat

;get data array
pos = strpos(tag_names(cluster_mfi_data),strupcase(cdfvar_name))
idx = where(pos NE -1)

mag_xyz = transpose(cluster_mfi_data.(idx(0)).dat)
nodata = cluster_mfi_data.(idx(0)).FILLVAL

r1 = TAI2UTC(tai1,/ext) & r2 = TAI2UTC(tai2,/ext)
CDF_EPOCH, ep_1, r1.year, r1.month, r1.day, $
  r1.hour, r1.minute, r1.second, /COMPUTE_EPOCH
CDF_EPOCH, ep_2, r2.year, r2.month, r2.day, $
  r2.hour, r2.minute, r2.second, /COMPUTE_EPOCH

index=where((epoch_time GE ep_1) AND (epoch_time LE ep_2 ),c)
mag_time=(epoch_time(index)-ep_1)/1000.0
;mag_time is now mag field data time in sec from zero, same as time array

mag_mfi = fltarr(n_elements(mag_time), 4)
mag_xyz = mag_xyz(index, *)
mag_mfi(*, 0:2) = mag_xyz
mag_mfi(*, 3) = sqrt(mag_xyz(*, 0)^2+mag_xyz(*, 1)^2+mag_xyz(*, 2)^2)

IF keyword_set(ORIG_TIME) THEN BEGIN
    mag_fgm = mag_mfi
    time = mag_time
    return
ENDIF 

;make time array - time can either be 1 or 2D array
r = size(time, /st)
IF r.N_DIMENSIONS EQ 2 THEN data_time = (time(*, 0) + time(*, 1))/2.0 $
ELSE data_time = time

;smooth mag data first to data resolution. Smooth needs to take into
;account bas data flags!
sm = n_elements(mag_time)/n_elements(data_time)
IF sm GE 3 THEN FOR i = 0, 3 DO mag_mfi(*, i) = papco_smooth(mag_mfi(*, i), sm)

;now interpolate mfi data to data time, preseving bad data flags.
new_mag_mfi = fltarr(n_elements(data_time), 4)
FOR i = 0, 3 DO new_mag_mfi(*, i) = $
    papco_interpol(mag_mfi(*, i), mag_time, data_time, NODATA = nodata)

mag_fgm = temporary(new_mag_mfi)

END
