;******************************************************************************
PRO get_goes_eph, control

COMMON mjdt, mjdt_start, mjdt_end     ;common time limit in mjdt
COMMON papco_cdf_data, goes_eph_data
COMMON papco_cdf
COMMON get_error, get_err_no, get_err_msg

COMMON goes_eph_data, input_header, input_data
COMMON goes_eph

IF papco_check_data_env('PAPCO_CDF_DATA', PATH = path) EQ 0 THEN BEGIN
    get_err_msg = 'Cannot get GOES EPH data, PAPCO CDF module not loaded'
    message, get_err_msg, /cont
    get_err_no = 1 & return
ENDIF 

;setup list of cdf directories for goes
goes_dirs = ['goes_06_mag', 'goes_07_mag', 'goes_08_mag', 'goes_09_mag', $
             'goes_10_mag', 'goes_12_mag']

;setup sample filenames for goes
goes_smpl = ['/1992/g6_k0_mag_19921212_v01.cdf', $
             '/1992/g7_k0_mag_19921218_v01.cdf', $
             '/1995/g8_k0_mag_19951210_v04.cdf', $
             '/1995/g9_k0_mag_19951211_v04.cdf', $
             '/1999/g0_k0_mag_19990627_v03.cdf', $
             '/2003/goes12_k0_mag_20030705_v03.cdf']

goes_vars = 'SC_pos_ll,SC_pos_eo,SC_pos_se,SC_pos_sm'

;make a structure for goes eph data
dummy = {TAI:0.0d, Epoch:0.0d, $
         SC_pos_ll:fltarr(3), SC_pos_eo:fltarr(3), $
         SC_pos_se:fltarr(3), SC_pos_sm:fltarr(3)}
input_header = {nodata:fltarr(4)}

;set timerange requested in TAI
tai1=utc2tai({mjd:mjdt_start.mjd, time:mjdt_start.t*1000})
tai2=utc2tai({mjd:mjdt_end.mjd, time:mjdt_end.t*1000})    

;set up control structure for cdf module and load into plotinfo
new_plotinfo = papco_getplotinfostruct()
new_control = papco_cdf_control
cdf_type = goes_dirs(control.sc_id)
new_control.cdf_type = cdf_type
cdf_file = path + cdf_type + goes_smpl(control.sc_id)
new_control.cdf_file = cdf_file 

cdfvar_name = goes_vars
new_control.cdfvar_name = cdfvar_name
new_plotinfo.USR_PTR1 = ptr_new(new_control)

r_papco_cdf, new_plotinfo, /verb

IF get_err_no NE 0 THEN return

;get time array
pos = strpos(tag_names(goes_eph_data), 'EPOCH')
idx = where(pos NE -1)
epoch_time = goes_eph_data.(idx(0)).dat

ndat = n_elements(epoch_time)
input_data = replicate(dummy, ndat)

input_data.epoch = epoch_time

;convert epoch time to TAI
r1 = TAI2UTC(tai1,/ext)
FOR i = 0, ndat-1 DO BEGIN
    CDF_EPOCH, input_data(i).epoch, y, m, d, h, min, s, /BREAKDOWN_EPOCH
    input_data(i).tai = utc2tai({year:y, month:m, day:d, $
                                 hour:h, minute:min, second:s, millisecond:0})
ENDFOR     

;get data arrays
vars = strsplit(goes_vars, ',', /extract)
FOR i = 0, n_elements(vars)-1 DO BEGIN
    pos = strpos(tag_names(goes_eph_data),strupcase(vars(i)))
    idx = where(pos NE -1)
    input_data.(i+2) = goes_eph_data.(idx(0)).dat
    input_header.nodata(i) = goes_eph_data.(idx(0)).FILLVAL
ENDFOR 

index=where((input_data.tai GE tai1) AND (input_data.tai LE tai2 ),c)
if c NE 0 THEN input_data = input_data(index) $
ELSE BEGIN
    get_err_no = 1
    get_err_msg = 'No data found for timerange'
ENDELSE

END
