;******************************************************************************
PRO get_polar_mag, control, mag_mfe, time

COMMON mjdt, mjdt_start, mjdt_end     ;common time limit in mjdt
COMMON papco_cdf_data, polar_mfe_data
COMMON papco_cdf
COMMON get_error, get_err_no, get_err_msg  

IF papco_check_data_env('PAPCO_CDF_DATA', PATH = path) EQ 0 THEN BEGIN
    get_err_msg = 'Cannot get POLAR MFE data, PUM CDAcdf not loaded'
    message, get_err_msg, /cont
    get_err_no = 1 & return
ENDIF 

;set timerange requested in TAI
tai1=utc2tai({mjd:mjdt_start.mjd, time:mjdt_start.t*1000})
tai2=utc2tai({mjd:mjdt_end.mjd, time:mjdt_end.t*1000})    

;set up control structure for cdf module and load into plotinfo
new_plotinfo = papco_getplotinfostruct()
new_control = papco_cdf_control
cdf_type = 'polar_mfe'
new_control.cdf_type = cdf_type
cdf_file = path + cdf_type + '/2000/po_k0_mfe_20000708_v01.cdf'
new_control.cdf_file = cdf_file 
cdfvar_name = 'B_GSE'
new_control.cdfvar_name = cdfvar_name
new_plotinfo.USR_PTR1 = ptr_new(new_control)

r_papco_cdf, new_plotinfo, /verb
IF get_err_no NE 0 THEN return

;get time array
pos = strpos(tag_names(polar_mfe_data), 'EPOCH')
idx = where(pos NE -1)
epoch_time = polar_mfe_data.(idx(0)).dat

;get data array
pos = strpos(tag_names(polar_mfe_data),strupcase(cdfvar_name))
idx = where(pos NE -1)

mag_xyz = transpose(polar_mfe_data.(idx(0)).dat)
nodata = polar_mfe_data.(idx(0)).FILLVAL

r1 = TAI2UTC(tai1,/ext) & r2 = TAI2UTC(tai2,/ext)
CDF_EPOCH, ep_1, r1.year, r1.month, r1.day, $
  r1.hour, r1.minute, r1.second, /COMPUTE_EPOCH
CDF_EPOCH, ep_2, r2.year, r2.month, r2.day, $
  r2.hour, r2.minute, r2.second, /COMPUTE_EPOCH

index=where((epoch_time GE ep_1) AND (epoch_time LE ep_2 ),c)
mag_time=(epoch_time(index)-ep_1)/1000.0
;mag_time is now mag field data time in sec from zero, same as time array

mag_mfe = fltarr(n_elements(mag_time), 4)
mag_xyz = mag_xyz(index, *)
mag_mfe(*, 0:2) = mag_xyz
mag_mfe(*, 3) = sqrt(mag_xyz(*, 0)^2+mag_xyz(*, 1)^2+mag_xyz(*, 2)^2)

;make time array - time can either be 1 or 2D array
r = size(time, /st)
IF r.N_DIMENSIONS EQ 2 THEN data_time = (time(*, 0) + time(*, 1))/2.0 $
ELSE data_time = time

;smooth mag data first to data resolution. Smooth needs to take into
;account bas data flags!
sm = n_elements(mag_time)/n_elements(data_time)
IF sm GE 3 THEN FOR i = 0, 3 DO mag_mfe(*, i) = papco_smooth(mag_mfe(*, i), sm)

;now interpolate mfe data to data time, preseving bad data flags.
new_mag_mfe = fltarr(n_elements(data_time), 4)
FOR i = 0, 3 DO new_mag_mfe(*, i) = $
    papco_interpol(mag_mfe(*, i), mag_time, data_time, NODATA = nodata)

mag_mfe = temporary(new_mag_mfe)

END
