;******************************************************************************
;* file papcoadd_papco_event
;*      papcoadd_papco_event
;* end
;*
;* this files contains all the collected routines which have to be added in
;* for events.
;*
;*    Those procedures are contained:
;*
;*    PRO addplottype_papco_event,plottypes_base,pb_plottype
;*        ->  adds the button for the new plot type to the main window.
;*
;*    PRO plottable_papco_event, plottable
;*        -> Sets a variable to indicate plottable without orbit.
;*
;*    PRO descriptor_papco_event, plotInfo, descriptStr
;*        -> Constructs the string used to label plots in the panels window
;*
;*    PRO addpanel_papco_event
;*        -> Calls the panel editor for this plottype and adds the plot to the
;*            panel window.
;*
;*    PRO editor_papco_event, plotNumber, newPlotData
;*        -> This procedure calls the panel editor when called from 
;*	     papco_EditPlot (papco_paneledit.pro).
;*
;*    PRO  draw_papco_event, panelVector, currPlotInfo, get_data_call, IsRead
;*        -> This procedure performs the actual data read and plot calls
;*           for this plottype
;******************************************************************************

;******************************************************************************
;* PROCEDURE:     
;*      PRO addplottype_papco_event,plottypes_base,buttonGeometry,pb_plottype
;* 
;* DESCRIPTION:  
;*	This procedure adds a button for this plottype to the plottypes_base.
;*      The UVALUE declared here is critical, since it is used to construct
;*      the procedure names of all procedures contained in this add-in
;*	papckage, so that they can be automatically called when needed.
;*
;* INPUTS:       
;*	plottypes_base	the widget ID of the parent widget to contain the
;*			plottype buttons.
;*
;* OUTPUTS: 
;*   	pb_plottype	the widget ID of the button created here.
;*      buttonGeometry  size of the button. Only used in simple
;*                      WIDGET_BUTTON to make them the same size as the
;*                      compound CW_PDMENU, pulldown for subtypes.
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	addplottype_papco_event,plottypes_base,buttonGeometry,pb_plottype
;*
;* MODIFICATION HISTORY:       
;*     written February 1996, Haje Korth
;*
;******************************************************************************
pro addplottype_papco_event,plottypes_base,buttonGeometry,pdm_papco_event

  MenuDesc = [ $
        { CW_PDMENU_S, 3, strcenter('PUM Event',10) }, $ 
        { CW_PDMENU_S, 0, ' configure papco_event ' }, $
        { CW_PDMENU_S, 2, ' plot papco_event      ' } ]  
  
  pdm_papco_event= CW_PDMENU(plottypes_base, MenuDesc, $
                            UVALUE='pdm_papco_event')  
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO addpanel_papco_event
;*
;* DESCRIPTION:  
;*	Calls the panel editor for this plottype and adds the plot to the
;*      panel window.
;*      using an instance of the papco_PLOTINFO structure called "defaults"
;*      the default settings of the panel editor can be controlled.
;*      panelEditor must be set to the name of the panel editor routine
;*
;* INPUTS:       
;*	event		event value of papco main window. This is
;*                      only used if there are plot sub_types, 
;*                      for example see papcoadd_crres_plots
;*
;* OUTPUTS: 
;*   	none
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	addpanel_papco_event
;*
;* MODIFICATION HISTORY:       
;*     written February 1996, Haje Korth
;******************************************************************************
pro addpanel_papco_event,event
  
  common get_error, get_err_no, get_err_msg
  
  r_module_config, strlowcase('papco_event'), config_data, msg
  if (get_err_no ne 0) and (event.value ne 1) then begin
    print,'% addpanel_papco_event: You need to configure the module first'
    papco_module_configure,'papco_event'
    return
  endif  
 
  CASE event.value of
    1: BEGIN
        papco_module_configure,'papco_event'
    end
    2: BEGIN
        panelKind='papco_event'
        panelEditor=panelkind+'_panel'
        defaults=papco_getPlotInfoStruct() ;returns a basic plotinfo structure
        defaults.typeVector=[0,0,0,0]      ;set some tags to desired defaults
        defaults.channel=0       
        defaults.YLINLOG=0
        papco_Add_Plot, panelEditor, panelKind, initialPlotInfo=defaults     
    end
    else: begin
      print,'% addpanel_papco_event: Nothing defined for this submenu entry'
      return
    end  
  endcase
  
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO plottable_papco_event, plottable
;*
;* DESCRIPTION:  
;*	Sets a variable to indicate plottable without orbit.
;*
;* INPUTS:       
;*	none
;*
;* OUTPUTS: 
;*   	plottable	a boolean 0 if plottable only by CRRES orbit
;*                                1 if plottable by time also.
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	plottable_papco_event, plottable
;*
;* MODIFICATION HISTORY:       
;*     written February 1996, Haje Korth
;*
;******************************************************************************
pro plottable_papco_event, plottable

   plottable=1

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO descriptor_papco_event, plotInfo, descriptStr
;*
;* DESCRIPTION:  
;*	Constructs the string used to label plots in the panel window
;*
;* INPUTS:       
;*	plotInfo        structure containing all data for this plot.
;*                      (structure type: papco_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*   	descriptStr	a string containing the label
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	descriptor_papco_event, plotInfo, descriptStr
;*
;* MODIFICATION HISTORY:       
;*     written February 1996, Haje Korth
;******************************************************************************
pro descriptor_papco_event, plotInfo, descriptStr

   descriptStr=descriptStr+'Filename : ' + plotInfo.filename

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO editor_papco_event, plotNumber, newPlotData
;* 
;* DESCRIPTION:  
;*	This procedure calls the panel editor when called from 
;*	papco_EditPlot (papco_paneledit.pro).
;*
;* INPUTS:       
;*	plotNumber	anInteger. 0<=plotNumber<=widgetData.numberOfPlots
;*			the index of the plot in widgetData.plotInfos.
;*		
;* OUTPUTS: 
;*   	newPlotData     the new structure returned by the panel editor
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	editor_papco_event, plotNumber, newPlotData
;*
;* MODIFICATION HISTORY:       
;*     written February 1996, Haje Korth
;******************************************************************************
PRO editor_papco_event, plotNumber, newPlotData

  COMMON PLOT_COMPOSER, widgetData

   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=papco_event_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO draw_papco_event, panelVector, currPlotInfo, orbitNo $
;*                          get_data_call, slice_type, IsRead
;* DESCRIPTION:  
;*	This procedure performs the actual data read call and the plot call
;*      for this plottype.
;*      
;*
;* INPUTS:       
;*	panelVector	position of the plot (see papco_conventions.text, 6)
;*	currPlotInfo	structure containing all data for this plot.
;*                      (structure type: papco_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*   	get_data_call	a string containing the data call. Used by other
;*                      routines that need to know how to get the data in
;*                      a panel, e.g. to draw spectra, distribution functions
;*      IsRead		a boolean which is set when the the data is read the
;*                      first time. Useful if a given data read puts data
;*                      into commons which can be plotted in many ways.
;*                      When set, data does not have to be read again.
;*      slice_type      Selects which slices are supported and for which
;*                      slice routines have been written.
;*                      This is a byte logical with 8 swittches. Currently
;*                      Three are supported (this may be extended later)
;*                       1 = mouse zooms (default, always possible)
;*                       2 = mouse slices
;*                       4 = mouse calls level zero
;*                       8, 16, 32, 64, 128 = not supported yet
;*                      you can support more than one type of slice
;*                      by arythmetically adding the options, eg
;*                      slice_type=5  support zoom and level zero
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	draw_papco_event, panelVector, currPlotInfo, orbitNo, $
;*                                 get_data_call, slice_type, IsRead
;* MODIFICATION HISTORY:       
;*     written February 1996, Haje Korth
;******************************************************************************
pro draw_papco_event, panelVector, currPlotInfo, orbitNo, $
                                   get_data_call, slice_type, IsRead

  common extra, extra_PlotInfo
  common mjdt, mjdt_start, mjdt_end    ;common time limit in mjdt
  common times, tev, events           ;plot data
  common get_error, get_err_no, get_err_msg

  filename=currPlotInfo.filename
  yvals=currPlotInfo.soptions(0)
  select=currPlotInfo.typevector(0)
  get_data_call=''
  IsRead=0
  slice_Type=1  

  if filename ne '' then begin
    r_papco_event, filename
  endif else begin
    if yvals ne '' then begin
      tev=mjdt_start
      tev.mjd=0 & tev.t=0
      IsRead=1
    endif 
  endelse
  
  if (filename eq '' ) and (yvals eq '') then begin
    get_err_no=1
    get_err_msg='No yvalues to plot, no event times file specified'  
  endif  
  
  if papco_Draw_CheckResult(currPlotInfo.panelKind, panelVector, orbitNr, $
    currPlotInfo.typeVector, currPlotInfo.channel) then IsRead=1   
  
  if IsRead then $
    p_papco_event, panelVector, currPlotInfo, _EXTRA=extra_PlotInfo

END
