;****************************************************************************
;*  NAME:        r_papco_event
;*
;*  DESCRIPTION: This procedure reads the event data.
;*
;*  INPUT:       filename
;*
;*  OUTPUT:
;*
;*  DATUM:       March 1996
;*
;*  AUTHOR:      Haje Korth
;****************************************************************************
pro readUserEvents, filename

COMMON times, time, events
COMMON time, xut1,xut2
COMMON get_error, get_err_no, get_err_msg

  junk=''
  no=0 & dd=0 & mm=0 & yy=0 & hrs=0.0 & hre=0.0 & ilats=0.0 & ilate=0.0
  time=fltarr(100)
  events=fltarr(100)
  ilat=fltarr(2,100)
  i=-1

  get_err_no=0  &  get_err_msg='Events-file read successfully'
  
; check env. variable pointing to data directory
  if not (papco_check_data_env('PAPCO_EVENT_DATA', path=PATH)) then return

;data can be in PAPCO_EVENT_DATA or PAPCO_EVENT_DATA/slice  
r = findfile(path+filename, count = c)
IF c EQ 0 THEN r = findfile(path+'slice\'+filename, count = c)
IF c NE 0 THEN path = path+'slice\'

stop

  openr,u,path+filename, /GET_LUN, ERROR=err
  
    IF err NE 0 THEN BEGIN
      message, filename + '  :  not available.', /cont
      get_err_no=2
      get_err_msg=!ERR_STRING
      message, !ERR_STRING,/cont
      RETURN
    ENDIF 

    readf,u,junk
    readf,u,junk & print,junk
    while not eof(u) do begin 
      i=i+1
      case strmid(filename,0,2) of
        'su': BEGIN
               readf,u,junk
               no=fix(strmid(junk,0,2))
               dd=fix(strmid(junk,10,2))
               mm=fix(strmid(junk,13,2))
               yy=fix(strmid(junk,16,2))
               hrs=fix(strmid(junk,20,2))
             END
        'ss': BEGIN
               readf,u,no,dd,mm,yy,hrs,hre
             END
        'dr': BEGIN
               readf,u,no,dd,mm,yy,hrs,hre,ilats,ilate
               ilat(0,i)=ilats & ilat(1,i)=ilate
             END
      endcase
      time(i)=convert_date_to_t90(day=dd,month=mm,year=yy,hour=hrs)
      events(i)=1.0
    endwhile

  close,u  &  free_lun, u

  time=time(0:i)
  events=events(0:i)

END

;****************************************************************************
pro r_papco_event, fln, VERBOSE=VERBOSE

COMMON papco_event_data, input_header, input_data
COMMON get_error, get_err_no, get_err_msg

get_err_no=0  &  get_err_msg='Events-file read successfully'

; check env. variable pointing to data directory
if not (papco_check_data_env('PAPCO_EVENT_DATA', path=PATH)) then return

; clear data arrays for reuse
input_header=0  &  input_data=0   

on_ioerror, read_original
restore,path+fln+'.idl', VERBOSE=VERBOSE
dealloc_lun,/quiet   ;frees logical units used by save/restore
message,'idl saveset read: '+fln+'.idl', /cont
return

read_original:       ;if the .idl file is not found, try to read the original
r_papco_event_original, fln, VERBOSE=VERBOSE

END 

;****************************************************************************
pro r_papco_event_original, fln, VERBOSE=VERBOSE

COMMON times, time, events
COMMON papco_event_data, input_header, input_data
COMMON mjdt, mjdt_start, mjdt_end    ;common time limit in mjdt
COMMON get_error, get_err_no, get_err_msg

get_err_no=0  &  get_err_msg='Events-file read successfully'
IF keyword_set(VERBOSE) THEN vebose = 1 ELSE verbose = 0

time_struct = {papco_events, t1_tai:0.0d, t1_str:'',t2_tai:0.0d, t2_str:''}
input_data = replicate(time_struct, 1000)

; check env. variable pointing to data directory
if not (papco_check_data_env('PAPCO_EVENT_DATA', path=PATH)) then return

papco_sepdir, fln, dir, fln2, ext
fln = fln2+ext

;data can be in PAPCO_EVENT_DATA or PAPCO_EVENT_DATA/slice  
r = findfile(path+fln, count = c)
IF c EQ 0 THEN BEGIN 
    r = findfile(path+'slice/'+fln, count = c)
    IF c NE 0 THEN path = path+'slice/'
ENDIF

OPENR, u, path+fln, /GET_LUN, ERROR=err
IF err NE 0 THEN BEGIN
    message, + path+fln+'  :  not available.', /cont
    get_err_no=2  &  get_err_msg=!ERR_STRING
    message,!ERR_STRING, /cont
    RETURN
ENDIF 

IF verbose THEN message, 'Reading original Event file (slow)....', /cont

on_ioerror, io_error  &  instr='' & i = 0
while not eof(u) do begin
    readf, u, instr
    if (strmid(instr,0,1) eq ';') OR (strmid(instr,0,1) eq '#') then continue
    ;check if we have two times per line (defining range)
    dummy1=str_sep(instr,' - ')
    dummy=strmid(dummy1(0),0,19)
    t1=convert_timeToSeconds(dummy,/t90,/MJDT)
    convert_t90_to_Date, t1.value, year,doy,hr,min,sec,mon,cmon,doym, /mjdt 
    tai_1=UTC2TAI({YEAR:year, MONTH:mon, DAY:doym, HOUR:hr, MINUTE:min, $
                   SECOND:sec, MILLISECOND:0})
    input_data(i).t1_tai = tai_1
    input_data(i).t1_str = dummy
    if n_elements(dummy1) gt 1 then begin
      dummy=strmid(dummy1(1),0,19)
      t2=convert_timeToSeconds(dummy,/t90,/MJDT)
      convert_t90_to_Date, t2.value, year,doy,hr,min,sec,mon,cmon,doym, /mjdt 
      tai_2=UTC2TAI({YEAR:year, MONTH:mon, DAY:doym, HOUR:hr, MINUTE:min, $
                     SECOND:sec, MILLISECOND:0})
      input_data(i).t2_tai = tai_2
      input_data(i).t2_str = dummy
    endif 

    i=i+1
    IF (i MOD 1000) EQ 0 THEN $
        input_data = [input_data, replicate(time_struct, 1000)]

    continue
    
    io_error: 
    message, 'Error while reading event number: '+varprt(i),/cont
    i=i-1      
      
endwhile

close, u  &  free_lun, u
input_data = input_data(0:i-1) 
  
IF verbose THEN print, '  ' + fln
         
;for some files, i.e. large ones, make idl files for quicker reading!
IF i GT 999 THEN BEGIN
      message, 'Saving Event data to IDL saveset', /cont
      save,  file = filename+'.idl', input_header, input_data, $
        /compress, VERBOSE=VERBOSE
ENDIF 

END

