function papco_file_format, data, n_time_tags, time_format
  
  formats=['YYYY', 'DOY', 'DD', 'MM', 'hh', 'mm', 'ss', $
           'ddf', 'dhf', 'dmf', 'dms']
  
  timevar=['year','doy','day','month','hour','min','sec', $
           'ddf', 'dhf', 'dmf', 'dms']
  
  for i=0, n_elements(timevar)-1 do result=execute(timevar(i)+'=0')  
  tf=str_sep(time_format,' ')
  result={mjd:-1,t:-1.0}  
  
  for i=0,n_time_tags -1 do begin
    case tf(i) of
      'YYYY': begin
        year=data.(i+2)
      end
      'DOY' :begin
        doy=data.(i+2)
      end
      'DD' :begin
        day=data.(i+2)
      end    
      'MM' :begin
        month=data.(i+2)
      end    
      'hh' :begin
        hour=data.(i+2)
      end    
      'mm' :begin
        min=data.(i+2)
      end    
      'ss' :begin
        sec=data.(i+2)
      end    
      'ddf' :begin
        sec= fix((data.(i+2)*86400.0) mod 60)
        min= fix((data.(i+2)*1440.0) mod 60)
        hour=fix((data.(i+2)*24.0))
      end    
      'dmf' :begin
        
      end    
      'dms' :begin
        
      end    
      '' :begin
      end    
      else: begin
        message,'Time format '+tf(i)+' not known',/cont
        return,result
      end  
    endcase  
  endfor  

  if doy ne 0 then $
    result=convert_date_to_t90(doy=doy, year=year, $
                               hour=hour, minutes=min, seconds=sec, /MJDT) $
  else $
    result=convert_date_to_t90(day=day, month=month, year=year, $
                               hour=hour, minutes=min, seconds=sec, /MJDT)    
    
  return,result
  
end  
