pro papco_file_modify
  
  common r_papco_file,  column_label, time_format
  common mjdt, mjdt_start, mjdt_end
  common get_error, get_err_no, get_err_msg
  
  fln='ace_121-135_1999.txt'
  new='ace_mod_121-135_1999.txt'
  
  r_papco_file, fln, ['','',''], input_header, input_data  
  
  ram_p=fltarr(n_elements(input_data)) & ram_p(*)=-999.900
  mpaus=fltarr(n_elements(input_data)) & mpaus(*)=-999.900
  Bmp=fltarr(n_elements(input_data))
  
; mp = 1.67e-27 kg
; np = proton density in cm-3
; speed is in km/s
; It looks like I took 0.35e-4 Tesla for Bs
  
  mu_not = 4e-7 * !pi
  
  mp=1.67e-27
  np=input_data.DENSITY
  speed=input_data.SPEED
  
  idx=where(np gt 0)
  
  ram_p(idx)=mp*np(idx)*speed(idx)^2*1.e12*1.e9
  
  Bmp(idx) = sqrt( mp*np(idx)*1.e6*(speed(idx)*1.e3)^2*2.*mu_not)
  mpaus(idx)=(2.*0.35e-4/Bmp(idx) )^(1./3.)
  
  
; check env. variable pointing to data directory
  if not (papco_check_data_env('PAPCO_FILE_DATA', path=PATH)) then return
  
  instr=''
  openr,unit1,path+fln,/get_lun
  openw,unit2,path+new,/get_lun
  
  readf,unit1,instr & printf,unit2,instr 
  readf,unit1,instr & printf,unit2,instr+ '  RAM_PRESSURE  MPAUSE_DIST' 
  readf,unit1,instr & printf,unit2,instr+ '       nP          Re      '
  
  i=0l
  while not eof(unit1) do begin ;AND (i ne n_elements(input_data)) do begin
    readf,unit1,instr 
    printf,unit2,instr+ string(ram_p(i),mpaus(i),format="(2(f12.3))")
    i=(i+1) < (n_elements(input_data)-1)
  endwhile
  
  close,unit1,unit2  & free_lun,unit1,unit2
 
end  



;Ram pressure is proton_mass*density*speed*speed.

;(1.67e-27kg)*(density cm-3)*(1.e6)*(speed km/s*(1.e3))^2*1.e-9
;  = pressure in nano-Pascals

;Bs is the Earth dipole field strength at 1 Re (the surface).


;If you can read IDL code, here are my lines of code that did
;the plots:

; mp = 1.67e-27 kg
; np = proton density in cm-3
; speed is in km/s
; It looks like I took 0.35e-4 Tesla for Bs


; plot, p_time(jj), mp*np(jj)*speed(jj)^2*1.e12*1.e9,$
;  title = ' ACE SWEPAM ', ytitle = 'RAM PRESS (nP)'
; Bmp = sqrt( mp*np(jj)*1.e6*(speed(jj)*1.e3)^2*2.*mu_not)
; Rmp = (2.*0.35e-4/Bmp )^(1./3.)
; !x.tickname = ''
; plot, p_time(jj), Rmp, ytitle = 'MPAUSE DIST R!DE!N',$
;xtitle = ' DOY 1999 ', yra = [0,40]

