;***************************************************************************
;* PROCEDURE:     
;*      p_papco_text, panel, _EXTRA=extra_par
;* 
;* DESCRIPTION:  
;*	This procedure plots data of type papco_text for inclusion in papco.  
;*      Data must have been read and placed into common blocks before this
;*      routine is called. Behaviour is controlled by the vector panel
;*	which controls positioning of the plot (see papco_conventions.papco_text
;*      in $papco). 
;*
;* INPUTS:       
;*      none        
;* OUTPUTS: 
;*      none
;*
;* KEYWORDS:
;*      OVERPLOT  if you support this you can alter the appearance of your
;*              plot if it is an overplot to an exisiting panel. Standard is
;*              to plot data, no axis, using the y-scaling of the first plot
;*              and to shift the labeling on the left down one line. Useful
;*              to plot model data together with real data, ie mag. field.
;*              see p_crres_mag for an example.
;*      PLOTS_ATTHISPOSITION  used to control the left side labeling for more
;*              than one overplot at the same position.
;*      _EXTRA  the plot structure containing some keyword for calls to
;*              plot. Used to customize color and line style.   
;* 
;* CALLING SEQUENCE:
;*       p_papco_text, panel, 
;*           _EXTRA=extra_par
;*
;* MODIFICATION HISTORY:       
;*     written December 1995, Reiner Friedel, at Goddard
;***************************************************************************
pro p_papco_text, panel, currPlotInfo, _EXTRA=extra_par

  common coordinateSystems, plotted_x, plotted_y  
                                        ;info on coords used by mouse
  common papco_text_data, input_header, input_data
					;sample data common block from 
					;r_papco_text

  panelset,panel			;sets the panel position viewport

  chrs=convert_coord(!D.x_ch_size,!D.y_ch_size,/device,/to_normal)
  chrd=chrs*!P.CHARSIZE*1.5
  
  thick=currPlotInfo.options(0)
  size=currPlotInfo.options(1)
  
  papco_text_label, panel, input_data, thick, size
  
  ;for i=0,n_elements(input_data)-1 do begin
  ;  yoffset=(i+1)*chrd(1)
  ;  xyouts,!p.position(0),!p.position(3)-yoffset, $
  ;   input_data(i), color=1, /normal, charsize=size, charthick=thick
  ;endfor
    
  x=findgen(10)
  plot,x,/nodata,xstyle=4,ystyle=4,/noerase
  plotted_x = !x  &  plotted_y = !y

end 
