;****************************************************************************
;*  NAME:        r_papco_text
;*
;*  DESCRIPTION: Routine to read papco_text files. Adheres to
;*               papco conventions: Error common block
;*                                  Uses MJDT time
;*                                  papco read philosophy
;*
;*  INPUT:       none (uses common block time from papco)
;*
;*  OUTPUT:      none (places data into common blocks)
;*
;*  DATE:        June 1996
;*
;*  AUTOR:       R. Friedel
;*
;*  CHANGES:     February 1997. Used MJDT time now, and is a fully
;*                              running example module on it's own
;****************************************************************************
pro r_papco_text,fln

   common papco_text_data, input_header, input_data
   common get_error, get_err_no, get_err_msg

; common get_error is used by papco to check if the data read was successful.
; it is up to the user to set this correctly and to make sure that the read- 
; routine does not crash on an I/O error - otherwise papco will crash at that
; point, too. papco draws an empty panel when get_err_no in not equal to zero
; and prints get_err_msg in that panel for user information.

   get_err_no=0
   get_err_msg='papco_text read succesfully'

; check for env. variable pointing to data directory
   data_dir='PAPCO_TEXT_DATA'
   c_path=papco_getenv(data_dir)
   if strlen(c_path) eq 0 then begin
      get_err_no=1
      get_err_msg='Environmental variable '+data_dir+' not set'
      print,get_err_msg
      return
   endif

   input_data=strarr(100)
   dummy='' & i=-1

   on_ioerror, no_read
   OPENR, f_unit, c_path+fln, /GET_LUN
   while not eof(f_unit) do begin
     i=i+1
     readf,f_unit,dummy
     input_data(i)=dummy
   endwhile

   input_data=input_data(0:i)
   return

   no_read: print, !err_string
            get_err_msg=!ERR_STRING
            return

   close, f_unit
   free_lun, f_unit     
 
end
