;******************************************************************************
;* PROCEDURE:     
;*      PRO plot_type_commons
;* 
;* DESCRIPTION:  
;*      Sets up common blocks and control structure used by module plot_type
;*
;* INPUTS:       
;*      none
;*      
;* OUTPUTS:
;*      none (common block plot_type is initialized)
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      automatically called by init_module for plot_type on PAPCO startup
;*
;* MODIFICATION HISTORY:       
;*      November 2003, written by R. Friedel
;******************************************************************************
PRO plot_type_commons

COMMON plot_type, names_1,  names_2, plot_type_control

names_1 = ['']
names_2 = ['']

;finally, set up a structure for all the variables needed by the
;lanl geo eph  module to control the behaviour of the module. This
;replaces the old use of "ioptions, options and soptions" tags of the
;plotinfo structure by a user defined structure which contains a more
;descriptive and verbose tags for easier use.

;format for this structure: variable and vaiable_info tags, the latter
;being the description of the former. 

;format for the info tags: up to the user, but if the variable is also
;used in the module's panel editor, this format is useful for
;automatically setting up a button choice widget for the variable:
;'Variable_name; 0: Choice one, 1: Choice two, .... '

plot_type_control = { $
  sc_id:0,      sc_id_info:'Index into sat_names, Geo Satellite ID', $
  product:0,    product_info:'Index into eph_names, choice of original '+$
                             'ephemeris coord', $
  ticks:0,      ticks_info:'Plot Style; 0: line, 1: x-axis ticks', $
  orig:0,       orig_info:'Coord source; 0: original, 1: model'}


;there are several "built-in" widgets in PAPCO that can be used in a
;module's panel editor. The variables for these widgets need to be
;added to the module's control structure. This is done by exactly the
;same call that is used to add these widgets in the panel editor, with
;the keyword "STRUCT_ONLY" added.

;papco_panel_Add_MagMod_Widgets adds cghoices for calculating magnetic
;field coordinates and values with a choice of models.

;now get the papco_panel tags for the papco_panel_Add_MagMod_Widgets
;tags, add them to plot_type_control
;plot_type_control = CREATE_STRUCT(plot_type_control, $
;                           papco_panel_Add_MagMod_Widgets(/STRUCT_ONLY))


;finally name the control structure. This is required for load/save operations!
plot_type_control = CREATE_STRUCT(name = 'plot_type_control', $
                                  plot_type_control)

END
