pro day_date, dayofyr, year, month, day

;	Converts the day-of-year and year into month and day format

; Inputs:
;	dayofyr	Day number, 1-366
;	year	Either 1993 or 93

; Outputs:
;	month	Number 1-12
;	day	Number 1-31

;	Day numbers for ends of the months for a nonleap year
days=[0,31,59,90,120,151,181,212,243,273,304,334,365]

;	Day numbers for ends of the months for a leap year
days_leap=days
days_leap(2)=days_leap(2:*)+1

;	Use either year format
if year(0) lt 1900 then yr=year+1900 else yr=year

;	Compute month number and day number
n_days=n_elements(dayofyr)
month=intarr(n_days)
leap=((yr mod 4) eq 0)
noleap=1-leap
for i=0,n_days-1 do begin
	if noleap(i) then m=where(dayofyr(i) le days) else $
		m=where(dayofyr(i) le days_leap)
	if m(0) ne -1 then month(i)=m(0) else stop,'Illegal month'
endfor

month=reform(month)
day=noleap*(dayofyr-days(month-1))+ $
	leap*(dayofyr-days_leap(month-1)) 
day=reform(day)

if n_days eq 1 then begin
	day=day(0)
	month=month(0)
endif

end
