;------------------------------------------------------------------------------
; File: HIT_CHA.PRO     Channel selection routines for CAMMICE HIT Rate Scalers
; Revision: 08/14/96    J L Roeder   
;------------------------------------------------------------------------------
; Routines:
;	hrates_init	Initialize possible HIT sectored channel settings
;	set_hrates	Sets the HIT sectored channels for processing
;	hsrates_init	Initialize possible HIT spin avg channel settings
;	set_hsrates	Sets the HIT sectored channels for processing
;------------------------------------------------------------------------------
pro hrates_init, dummy   

;	Initializes the hrates common block which lists possible HIT scaler
;	channels
   
; BLOCK: hrates   
;       possible_chan   Strings identifying channels for menu   
;       index           Index of which channels selected for listing   
   
common hrates, possible_chan, index   
   
possible_chan = [ $   
    'HR0', $   
    'HR1', $   
    'HR2', $   
    'HR3', $   
    'HR4', $   
    'HR5', $   
    'HR6', $   
    'HR7', $   
    'HR8', $   
    'HR9', $   
    'HR10', $   
    'HR11', $   
    'HID0', $   
    'HID2', $   
    'HID5', $   
    'HID6', $   
    'HID7', $   
    'HID8' ]   
   
index = -1

print,'HIT Rate Scaler Channels:'
print,'Index    Channel'
nchan = n_elements(possible_chan)
for i = 0, nchan - 1 do print,i,possible_chan(i), format='(i4,8x,a)'

end   
;------------------------------------------------------------------------------
pro set_hrates, channels

;	Set the requested scaler channels

; BLOCK: hrates   
;       possible_chan   Strings identifying channels for menu   
;       index           Index of which channels selected for listing   
   
common hrates, possible_chan, index   
   
;	Initialize common block first time through
if n_elements(index) eq 0 then hrates_init

index = channels

end
;------------------------------------------------------------------------------
pro hsrates_init, dummy   

;	Initializes the hsrates common block which lists possible HIT
;	spin-averaged scaler channels
   
; BLOCK: hsrates   
;       possible_chan   Strings identifying channels for menu   
;       index           Index of which channels selected for listing   
   
common hsrates, possible_chan, index   
   
possible_chan = [ $   
    'HR12', $   
    'HID4', $   
    'HS1', $   
    'HS5', $   
    'HID1', $   
    'HR13', $   
    'HID9', $   
    'HS2', $   
    'HS6', $
    'HR14', $   
    'HID10', $   
    'HS3', $   
    'HID3', $   
    'HR15', $   
    'HID12', $   
    'HS4']
   
index = -1

print,'HIT Spin-Averaged Scaler Channels:'
print,'Index    Channel'
nchan = n_elements(possible_chan)
for i = 0, nchan - 1 do print,i,possible_chan(i), format='(i4,8x,a)'

end   
;------------------------------------------------------------------------------
pro set_hsrates, channels

;	Set the requested HIT spin-averaged rate scaler channels

; BLOCK: hsrates   
;       possible_chan   Strings identifying channels for menu   
;       index           Index of which channels selected for listing   
   
common hsrates, possible_chan, index   
   
;	Initialize common block first time through
if n_elements(index) eq 0 then hsrates_init

index = channels

end
