;------------------------------------------------------------------------------ 
; File: HIT_SUN.PRO     CAMMICE HIT Sun Sector and Other Parameters 
; Revision: 03/14/96    J L Roeder             
;------------------------------------------------------------------------------ 
; Routines:             
;      def_hsunstat_strc        Create structure for HIT Status from Mux
;      load_hsunstat            Loads structure with HIT status data
;------------------------------------------------------------------------------ 
pro def_hsunstat_strc, strc, nbytes

;       Define the structure to hold the HIT Multiplexed Status bits

strc = { HIT_SunStat,          $
	cal_flag: 0B,		$ ; MDPU Calibration Flag
	dep_scheme: 0B,		$ ; Direct Event Priority Scheme
	rss_page: 0B, 		$ ; Rate Scaler Select Page Number
	result_mode: 0B,	$ ; Cause of DPU Reset and Ram Reload
	Sun_Detected: 0B, 	$ ; Sun Pulse Received Flag
	Sun_Sector: 0B	 	$ ; Sector in which Sun Detected
	}

nbytes = 6

end
;------------------------------------------------------------------------------ 
pro load_hsunstat, status, hsun_stat

;       Loads structure with HIT status info from mux data

; Inputs:
;	status		Array of bytes from mux data, intarr( nrec, 2)

; Outputs:
;       hsun_stat       Structure filled with sun sector and status flags

;       Number of major frames to process
;       assume status array is nmajor x 2
sz = size( status)
nmajor = sz( 1)

;       Define output structure
def_hsunstat_strc, struc, nbytes

;       Create output array
hsun_stat = replicate( struc, nmajor)

;	Load data into structure
;	HDPU Result Mode
temp = status( *, 0)
rm = ishft( temp and '30'X, -4) * (temp ne -1) + 255B * (temp eq -1) 
hsun_stat.result_mode = rm

;	HDPU Cal FLag
cal = ishft( temp and '08'X, -3) * (temp ne -1) + 255B * (temp eq -1) 
hsun_stat.cal_flag = cal

;	Direct Event Priority Scheme
dep = ishft( temp and '04'X, -2) * (temp ne -1) + 255B * (temp eq -1) 
hsun_stat.dep_scheme = dep

;	Rate Scaler Select Page Number
rss = ( temp and '03'X) * (temp ne -1) + 255B * (temp eq -1) 
hsun_stat.rss_page = rss

;	HDPU Sun Detected
temp = status( *, 1)
sun = ishft( temp and '20'X, -5) * (temp ne -1) + 255B * (temp eq -1) 
hsun_stat.Sun_Detected = sun

;	HDPU Sun Sector
sunsect = ( temp and '1F'X) * (temp ne -1) + 255B * (temp eq -1) 
hsun_stat.Sun_Sector = sunsect

end
