;------------------------------------------------------------------------------
; File: MICS_CHA.PRO    Channel selection routines for CAMMICE MICS Rate Scalers
; Revision: 12/07/95    J L Roeder   
;------------------------------------------------------------------------------
; Routines:
;	mrates_init	Initialize possible MICS sectored channel settings
;	set_mrates	Sets the MICS sectored channels for processing
;	msrates_init	Initialize possible MICS spin avg channel settings
;	set_msrates	Sets the MICS sectored channels for processing
;------------------------------------------------------------------------------
pro mrates_init, dummy   

;	Initializes the mrates common block which lists possible MICS scaler
;	channels
   
; BLOCK: mrates   
;       possible_chan   Strings identifying channels for menu   
;       index           Index of which channels selected for listing   
   
common mrates, possible_chan, index   
   
possible_chan = [ $   
    'MR0', $   
    'MR1', $   
    'MR2', $   
    'MR3', $   
    'MR4', $   
    'MR5', $   
    'MR6', $   
    'MR7', $   
    'MR8', $   
    'DCR', $   
    'FSR' ]   
   
index = -1

print,'MICS Rate Scaler Channels:'
print,'Index    Channel'
nchan = n_elements(possible_chan)
for i = 0, nchan - 1 do print,i,possible_chan(i), format='(i4,8x,a)'

end   
;------------------------------------------------------------------------------
pro set_mrates, channels

;	Set the requested scaler channels

; BLOCK: mrates   
;       possible_chan   Strings identifying channels for menu   
;       index           Index of which channels selected for listing   
   
common mrates, possible_chan, index   
   
;	Initialize common block first time through
if n_elements(index) eq 0 then mrates_init

index = channels

end
;------------------------------------------------------------------------------
pro msrates_init, dummy   

;	Initializes the msrates common block which lists possible MICS 
;	spin-averaged scaler channels
   
; BLOCK: msrates   
;       possible_chan   Strings identifying channels for menu   
;       index           Index of which channels selected for listing   
   
common msrates, possible_chan, index   
   
possible_chan = [ $   
    'MR0', $   
    'MR1', $   
    'MR2', $   
    'MR3', $   
    'MR4', $   
    'MR5', $   
    'MR6', $   
    'MR7', $   
    'MR8', $   
    'MR9', $   
    'MR10', $   
    'MR11', $   
    'MR12', $   
    'MR13', $   
    'MR14', $   
    'MR15']   
   
index = -1

print,'MICS Spin-Averaged Scaler Channels:'
print,'Index    Channel'
nchan = n_elements(possible_chan)
for i = 0, nchan - 1 do print,i,possible_chan(i), format='(i4,8x,a)'

end   
;------------------------------------------------------------------------------
pro set_msrates, channels

;	Set the requested MICS spin-averaged rate scaler channels

; BLOCK: msrates   
;       possible_chan   Strings identifying channels for menu   
;       index           Index of which channels selected for listing   
   
common msrates, possible_chan, index   
   
;	Initialize common block first time through
if n_elements(index) eq 0 then msrates_init

index = channels

end
