;------------------------------------------------------------------------------  
; File: MICS_OFF.PRO    CAMMICE MICS Sector Offsets Routines             
; Revision: 05/10/97    J L Roeder             
;------------------------------------------------------------------------------  
pro get_moff_LZ, revoff, auxoff
          
;       Extract MICS Sector Offsets from a single Level Zero record 
          
; Inputs: None.
          
; Outputs: 
;       revoff          ; 5-bit sector offset used to determine spin starts
;       auxoff          ; 7-bit fine offset set by DPU software
                    
common camLZ_data, $    ; BLOCK holds one record of Level Zero Data 
        recnumb, $      ; Record number of data  
        drh, $          ; Data record header 
        hk, $           ; Housekeeping bytes dim 250 x 2 
        subcom, $       ; Subcom (Loose) bytes dim 250 x 2 
        mics_fixed, $   ; Fixed-Column MICS Science Allocation, dim 50 x 15  
        hit_fixed       ; Fixed-Column HIT Science Allocation, dim 50 x 15     
 
;       Get quality bytes from header for minor frames 2 and 3
qual2 = drh.mnfr_qua(2)
qual3 = drh.mnfr_qua(3)
   
;       Get Fine and Coarse offsets for sector angle from loose bytes 
revoff = (subcom(2, 0) and '1F'X) * (qual2 eq 0B) - (qual2 ne 0B)
auxoff = (subcom(3, 0) and '7F'X) * (qual3 eq 0B) - (qual3 ne 0B)

end

