;------------------------------------------------------------------------------   
; File: MMAGSECT.PRO    CAMMICE MICS Level Zero File Magnetic AZ and EL   
; Revision: 06/20/97    J L Roeder               
;------------------------------------------------------------------------------   
; Routines:               
;      mmagsect        Compute ESA step number for each sector and event      
;------------------------------------------------------------------------------   
pro mmagsect, recnumber, sectors, mux_data, mag_az, mag_el  
      
;       Compute MagAz and MagEl for each sector from one record  
      
; Inputs:  
;       recnumber       Record number of this data      
;       sectors         Sector numbers, 0-31      
;       mux_data        Mux data for each sector  
  
; Outputs:  
;       mag_az          Mag Azimuth for each sector   
;       mag_el          Mag Elevation for each sector   
      
common last_mag, $      ; Storage of esa step for record processed previously  
        last_record, $  ; Previous record number, 1-9391  
        last_magaz, $   ; MagAz from last spin in previous record  
        last_magel      ; MagEl from last spin in previous record  
  
;       Initialize last esa step common block if first execution  
if n_elements( last_record) eq 0L then begin  
  
        last_record = -1L  
        last_magaz = 255B  
        last_magel = 255B  
  
endif  
  
;       Number of sectors in data arrays      
nsect = n_elements( sectors)      
      
;       Find begining of spins at sector zero  
jsect0 = where( sectors eq 0B, njsect0)  
js0 = jsect0(0)  
  
jsect_el = where ( sectors eq 1B, nj_el)      
jsect_az = where ( sectors eq 17B, nj_az)      
jel0 = jsect_el(0)      
jaz0 = jsect_az(0)      
  
;       Check if any elevation spins found  
if (nj_el ne 0) and (njsect0 ne 0) then begin  
  
;       MagEl at sector crossings  
        magel0 = mux_data( jsect_el)  
  
;       Number of sectors with zero crossings  
        nmagel = (njsect0 * 32) < nsect  
        magel_values = magel0( lindgen( nmagel) / 32L)  
        loc_el = (lindgen( nmagel) mod 32L) + jsect0( lindgen( nmagel) / 32L)  
        mag_el = replicate( 255B, nsect)  
        mag_el( loc_el) = magel_values  
  
;       Fill in MagEl values from last spin in previous record  
        if (jsect0(0) ne 0L) and (recnumber eq last_record+1L) then $  
                mag_el(0) = replicate( last_magel, jsect0(0)<31L)  
  
endif else begin  
  
        if recnumber eq last_record + 1L then $  
                mag_el = replicate( last_magel, nsect) else $  
                mag_el = replicate( 255B, nsect)  
  
endelse  
  
;       Check if any Azimuth data found  
if (nj_az ne 0) and (njsect0 ne 0) then begin  
  
;       MagAz at sector crossings  
        magaz0 = mux_data( jsect_az)  
  
;       Number of sectors with zero crossings  
        nmagaz = (njsect0 * 32) < nsect  
        magaz_values = magaz0( lindgen( nmagaz) / 32L)  
        loc_az = (lindgen( nmagaz) mod 32L) + jsect0( lindgen( nmagaz) / 32L)  
        mag_az = replicate( 255B, nsect)  
        mag_az( loc_az) = magaz_values  
  
;       Fill in MagAz values from last spin in previous record  
        if (jsect0(0) ne 0L) and (recnumber eq last_record+1L) then $  
                mag_az(0) = replicate( last_magaz, jsect0(0)<31L)  
  
endif else begin  
  
        if recnumber eq last_record + 1L then $  
                mag_az = replicate( last_magaz, nsect) else $  
                mag_az = replicate( 255B, nsect)  
  
endelse  
  
;       Save last MagEl and MagAz from this record for next time  
last_record = recnumber  
last_magel = mag_el( nsect - 1L)  
last_magaz = mag_az( nsect - 1L)  
  
end
