;------------------------------------------------------------------------------    
; File: OPN_LZ.PRO     Level Zero File Reading Routines                       
; Revision: 04/11/97   J L Roeder                       
;------------------------------------------------------------------------------    
; Routines:                 
;       opn_LZ          Initializes a POLAR Level Zero File for reading            
;       cls_LZ          Close a POLAR Level Zero File                 
;------------------------------------------------------------------------------    
pro opn_LZ, filename, err                 
                 
;       Opens and initializes a POLAR Level Zero File for reading                 
                 
; Inputs:                 
;       filename    Complete LZ filename including path                 
                 
; Outputs:
;       err         Error message string is null if no error 
                 
; BLOCK: LZfile                       
;       pth         Path to LZ file including device and all directories    
;       fname       LZ filename including path info                       
;       unit        Unit number if file is open, else -1                 
;       spacecraft  Name string should be 'POLAR'                 
;       instrument  Name string should be one of ['CAMMICE','CEPPAD','SEPS',    
;                   'MFE', or 'PIXIE']                 
;       tm_mode     Must be one of ['SCIENCE','MANUEVER','CONTINGENCY']    
;       nbytes      Number of bytes per record                 
;       nfill       Number of fill bytes per record    
                 
common LZfile, pth, fname, unit, spacecraft, instrument, tm_mode, nbytes, nfill    
                 
if n_elements( unit) eq 0 then unit = -1                 
                 
if unit eq -1 then begin                 
                 
    if filename ne '' then begin               

        fname = filename                 
        openr, unit, fname, /GET_LUN, /BLOCK, ERROR = error_numb

	if error_numb eq 0 then begin

            check_lz                 
            interval_init, recrng 
	    mspin_avg_init
	    hspin_avg_init
            reclast = recrng(1) 
            if nbytes gt 0L then begin

                case instrument of

                    'CAMMICE': init_camLZ, unit, nbytes, nfill, reclast
                    'PIXIE': init_sepsLZ, unit, nbytes, nfill, reclast

                endcase 

            endif

	endif else begin

;		LZ file would not open correctly
	    print, !ERR_STRING
	    err = 'opn_LZ: Error opening LZ file'

	endelse    

    endif else err = 'opn_LZ: File Not Selected'                     

endif else err = 'opn_LZ: A Level Zero file is already open.'                 
                 
end                 
;------------------------------------------------------------------------------    
pro cls_LZ, err        
                 
;       Close a POLAR Level Zero File                 
                 
; Inputs: None.
                 
; Outputs:
;       err         Error message string is null if no error 
                 
; BLOCK: LZfile                       
;       pth         Path to LZ file including device and all directories    
;       fname       LZ filename including path info                       
;       unit        Unit number if file is open, else -1                 
;       spacecraft  Name string should be one of ['POLAR','GEOTAIL','WIND']    
;       instrument  Name string should be one of ['CAMMICE','CEPPAD','SEPS',    
;                   'MFE', or 'PIXIE']                 
;       tm_mode     Must be one of ['SCIENCE','MANUEVER','CONTINGENCY']    
;       nbytes      Number of bytes per record                 
;       nfill       Number of fill bytes per record    
                 
common LZfile, pth, fname, unit, spacecraft, instrument, tm_mode, nbytes, nfill    
                 
if n_elements( unit) eq 0 then unit = -1                 
                 
if unit ne -1 then begin                 
                 
        free_lun, unit                 
        fname = ''                 
        unit = -1                 
        nbytes = 0  
        nfill = 0 
                  
endif else err = 'cls_lz: No LZ file is open.'                 
                         
end                 
   
