;------------------------------------------------------------------------------
; File: PATH_LZ.PRO	Routines provide device independent paths to data files
; Revision: 01/02/96	J L Roeder
;------------------------------------------------------------------------------
; Routines:
;	path_lz		Returns paths to various files 
;------------------------------------------------------------------------------
pro path_lz, path_prog, path_data, path_cals

;	Returns paths to various files needed by POLAR Level Zero programs

; Inputs/Outputs:
;	path_prog	Complete path to program codes
;	path_data	Path to level zero data files
;	path_cals	Path to instrument calibration files

; BLOCK: path_cam
;	prog_pth	Stored path to program files
;	data_pth	Stored path to level zero data files
;	cals_pth        Stored path to calibration files

common path_cam, prog_pth, data_pth, cals_pth

if n_elements( path_prog) ne 0 then prog_pth = path_prog
if n_elements( path_data) ne 0 then data_pth = path_data
if n_elements( path_cals) ne 0 then cals_pth = path_cals

if n_elements( prog_pth) ne 0 then path_prog = prog_pth
if n_elements( data_pth) ne 0 then path_data = data_pth
if n_elements( cals_pth) ne 0 then path_cals = cals_pth

end
