;------------------------------------------------------------------------------
; File: PLATFORM.PRO	Routines depending on platform or operating system
; Revision: 02/07/96	J L Roeder      
;-----------------------------------------------------------------------------
; Routines:
;	swap_bytes	Interchanges bytes of integers depending on platform
;------------------------------------------------------------------------------
pro swap_bytes, data

;	Interchanges bytes for longs or ints depending on operating system
;	Note that data is modified in place, same as byteorder.  If data
;	is not a long or int then no action is taken and a warning is given.

opsys = !version.os
if (opsys eq 'MacOS') or (opsys eq 'sunos') or $
	(opsys eq 'IRIX') or (opsys eq 'hp-ux') then begin

;	Type of input data array
	sz = size( data)
	nz = n_elements( sz)
	type = sz( nz - 2)

	if type eq 3L then byteorder, data, /LSWAP else if type eq 2L then $
		byteorder, data, /SSWAP else $
		print,'Warning swap_bytes: wrong data type=',type

endif 

end
