;------------------------------------------------------------------------------    
; File: READ_LZ.PRO     Unbuffered Level Zero File Reading Routines                       
; Revision: 01/18/97    J L Roeder                       
;------------------------------------------------------------------------------    
; Routines:                 
;       rd_LZ           Reads a single POLAR Level Zero Record                       
;------------------------------------------------------------------------------    
pro rd_LZ, rec_numb, data_bytes, err                 
                       
;       Reads a single POLAR Level Zero Record                       
                 
; Inputs:                       
;       rec_numb    Record number with 0 being the first record                 
                 
; Outputs:                       
;       data_bytes  Array of data                       
;       err         Error string is '' if no error                       
                 
; BLOCK: LZfile                       
;       pth         Path to LZ file including device and all directories    
;       fname       LZ filename including path info                       
;       unit        Unit number if file is open, else -1                 
;       spacecraft  Name string should be one of ['POLAR','GEOTAIL','WIND']    
;       instrument  Name string should be one of ['CAMMICE','CEPPAD','SEPS',    
;                   'MFE', or 'PIXIE']                 
;       tm_mode     Must be one of ['SCIENCE','MANUEVER','CONTINGENCY']    
;       nbytes      Number of bytes per record                 
;       nfill       Number of fill bytes per record    
                 
common LZfile, pth, fname, unit, spacecraft, instrument, tm_mode, nbytes, nfill    
  
;   Check if input file has been opened   
if unit ne -1L then begin                 
                 
;   Read a single unbuffered record                 
    aa = assoc( unit, bytarr(nbytes))                       
    data_bytes = aa( rec_numb)                 
                 
;   Eliminate fill bytes from records    
    if nfill ne 0L then data_bytes = data_bytes(0:nbytes-1-nfill)    
                 
;   No error
    err = ''

endif else begin  
  
    err = 'rd_LZ: Level Zero file is not open.'  
    data_bytes = -1B 
 
endelse                                                     
                 
end                       
   
