;------------------------------------------------------------------------------  
; File: SRCH_LZ.PRO     Level Zero File Searching Routines                     
; Revision: 03/21/97    J L Roeder                     
;------------------------------------------------------------------------------  
; Routines:               
;       search_LZ       Searchs for Time in POLAR Level Zero File                
;------------------------------------------------------------------------------  
pro search_LZ, time, recnumb, err                     
               
;       Returns record number of specified time in Level Zero File  
;       via binary search                    
               
; Inputs:                    
;       time           Time from start of day in sec to find                    
               
; Outputs:                    
;       recnumb        Record number where 0 is File Header Record  
;       err            Error string is null if no error                    
               
;       Get File Label Record                    
LZ_flr, flr, err                    
               
;       Begin and end time in file in msec from start of day                    
file_start = flr.atc_beg(2)                   
file_end = flr.atc_end(2)               
               
;       Convert desired time to milliseconds               
tt = time * 1000L                
               
;       Test if search time is within file                    
if (tt lt file_start) or (tt gt file_end) then begin                    
               
;       Print warnings                     
        if tt lt file_start then $                    
         fmt1='("Warning: Search time ",i6," s lies before file start.")' $  
        else $                    
         fmt1='("Warning: Search time ",i6," s lies beyond file end.")'      
        print,tt/1000L,FORMAT=fmt1                    
        recnumb = (tt lt file_start) + $               
           flr.mjfrm_file * (tt gt file_end)                    
               
endif else begin                    
               
;       Start binary search                    
        rec0 = 1L                    
        rec1 = flr.mjfrm_file                    
        recnumb = 0L                    
        drec = 1L               
        while drec ne 0 do begin                    
           recnumb = rec0 + drec                    
           rd_LZ, recnumb, dbytes, err                    
           if err ne '' then return                    
           t = long( dbytes(28:31), 0)               
           swap_bytes, t               
               
           if t le tt then rec0 = recnumb else rec1 = recnumb                    
           drec = long( (rec1-rec0) /2L)                    
;          print, 'SEARCH_LZ: ',  recnumb, drec, t, tt               
        endwhile                    
               
endelse                    
               
end                    
 
