;------------------------------------------------------------------------------
; File: TEST_HIT.PRO	Executes all CAMMICE HIT routines on LZ data file
; Revision: 3/14/96	J L Roeder
;------------------------------------------------------------------------------
pro test_hit, filename

;	Open CAMMICE Level Zero file
if n_elements(filename) eq 0 then filename=pickfile()
print,'HIT Testing File: ',filename
opn_lz, filename

cmd = ' '
read, 'Process entire file (y/n)? ', cmd
if strlowcase(cmd) ne 'y' then begin
	rec1 = 0
	rec2 = 0
        read,'Enter Record Range: ', rec1, rec2
        set_records,[rec1,rec2]
endif

;	HIT Direct Events
get_hde, times, eng, deng, eprime, sample, m, err
print
print, 'HIT Direct Event Arrays'
help, times, eng, deng, eprime, sample, m, err

; 	HIT Sectored Rate Scalers
set_hrates, indgen(11)
get_hsrates, times, mf, sectors, chans, cnts, err
print
print, 'HIT Sectored Rate Scaler Arrays'
help, times, mf, sectors, chans, cnts, err

; 	HIT Spin-Averages Rate Scalers
set_hsrates, indgen(16)
get_htotrts, times, chans, cnts, err
print
print, 'HIT Spin-Averaged Rate Scaler Arrays'
help, times, chans, cnts, err

;	HIT Singles
get_hsing, timesa, sectora, cntsa, timesb, sectorb, cntsb, err
print
print, 'HIT Singles Arrays'
help, timesa, sectora, cntsa, timesb, sectorb, cntsb, err

;	HIT X Scalers
get_hxrates, times, sectors, stype, snum, cnts, err
print
print,'HIT X Scaler Arrays'
help, times, sectors, stype, snum, cnts, err

;	HIT YScalers
get_hyrates, times, sectors, stype, snum, cnts, err
print
print,'HIT Y Scaler Arrays'
help, times, sectors, stype, snum, cnts, err

;	HIT Matrix Scalers
get_hmatrx, times, cnts, err
print
print, 'HIT Matrix Scaler Arrays'
help, times, cnts, err

;	HIT Sun Sector and Other Status
get_hsun, times, hsun, err
print
print, 'HIT Sun Sector and Other Status'
help, times, hsun, err

;	HIT DPU Status
get_hdpustat, times, hdpustat, err
print
print, 'HIT DPU Status Arrays'
help, times, hdpustat, err

;	HIT DPU Housekeeping
get_hdpuhk, times, hdpuhk, err
print
print, 'HIT DPU Housekeeping Arrays'
help, times, hdpuhk, err

;	Close Level Zero File
cls_lz

end
